/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter;

import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.CanceledFlowNodeFilterDataDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.QueryFilterOS;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class CanceledFlowNodeQueryFilterOS
implements QueryFilterOS<CanceledFlowNodeFilterDataDto> {
    private static final Logger LOG = LoggerFactory.getLogger(CanceledFlowNodeQueryFilterOS.class);

    @Override
    public List<Query> filterQueries(List<CanceledFlowNodeFilterDataDto> flowNodeFilters, FilterContext filterContext) {
        return flowNodeFilters.stream().map(this::createFilterQuery).toList();
    }

    private Query createFilterQuery(CanceledFlowNodeFilterDataDto flowNodeFilter) {
        Query isCanceledQuery = QueryDSL.and((Query[])new Query[]{QueryDSL.exists((String)this.nestedCanceledFieldLabel()), QueryDSL.term((String)this.nestedCanceledFieldLabel(), (boolean)true)});
        List<Query> queries = flowNodeFilter.getValues().stream().map(value -> QueryDSL.nested((String)"flowNodeInstances", (Query)QueryDSL.and((Query[])new Query[]{isCanceledQuery, QueryDSL.term((String)this.nestedActivityIdFieldLabel(), (String)value)}), (ChildScoreMode)ChildScoreMode.None)).toList();
        return QueryDSL.or(queries);
    }

    private String nestedActivityIdFieldLabel() {
        return "flowNodeInstances.flowNodeId";
    }

    private String nestedCanceledFieldLabel() {
        return "flowNodeInstances.canceled";
    }
}

