/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.OperatorMultipleValuesFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.BooleanVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.DateVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.OperatorMultipleValuesVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.StringVariableFilterDataDto;
import io.camunda.optimize.service.db.filter.util.OperatorMultipleValuesVariableFilterDataDtoUtil;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.time.ZoneId;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVariableQueryFilterOS {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractVariableQueryFilterOS.class);

    protected abstract Query createContainsOneOfTheGivenStringsQuery(StringVariableFilterDataDto var1);

    protected abstract Query createContainsOneOfTheGivenStringsQuery(String var1, List<String> var2);

    protected abstract Query createContainsGivenStringQuery(String var1, String var2);

    protected abstract Query createEqualsOneOrMoreValuesQuery(OperatorMultipleValuesVariableFilterDataDto var1);

    protected abstract Query createBooleanQuery(BooleanVariableFilterDataDto var1);

    protected abstract Query createNumericQuery(OperatorMultipleValuesVariableFilterDataDto var1);

    protected abstract Query createDateQuery(DateVariableFilterDataDto var1, ZoneId var2);

    protected Query createStringQuery(StringVariableFilterDataDto stringVarDto) {
        OperatorMultipleValuesVariableFilterDataDtoUtil.validateMultipleValuesFilterDataDto((OperatorMultipleValuesVariableFilterDataDto)stringVarDto);
        if (stringVarDto.hasContainsOperation()) {
            return this.createContainsOneOfTheGivenStringsQuery(stringVarDto);
        }
        if (stringVarDto.hasEqualsOperation()) {
            return this.createEqualsOneOrMoreValuesQuery((OperatorMultipleValuesVariableFilterDataDto)stringVarDto);
        }
        String message = String.format("String variable operator [%s] is not supported!", ((OperatorMultipleValuesFilterDataDto)stringVarDto.getData()).getOperator().getId());
        LOG.debug(message);
        throw new OptimizeRuntimeException(message);
    }
}

