/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.os.client.sync.OpenSearchDocumentOperations;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.reader.TenantReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class TenantReaderOS
implements TenantReader {
    private static final Logger LOG = LoggerFactory.getLogger(TenantReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public TenantReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public Set<TenantDto> getTenants() {
        OpenSearchDocumentOperations.AggregatedResult scrollResp;
        LOG.debug("Fetching all available tenants");
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index("tenant", new String[0]).size(Integer.valueOf(1000)).query(QueryDSL.matchAll()).scroll(RequestDSL.time((String)String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())));
        try {
            scrollResp = this.osClient.retrieveAllScrollResults(searchRequest, TenantDto.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Was not able to retrieve tenants!", (Throwable)e);
        }
        return new HashSet<TenantDto>(OpensearchReaderUtil.extractAggregatedResponseValues(scrollResp));
    }
}

