/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.ReportType;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.sync.OpenSearchDocumentOperations;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.get.GetResult;
import org.opensearch.client.opensearch.core.mget.MultiGetResponseItem;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.core.search.SourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ReportReaderOS
implements ReportReader {
    private static final Logger LOG = LoggerFactory.getLogger(ReportReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public ReportReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public Optional<ReportDefinitionDto> getReport(String reportId) {
        LOG.debug("Fetching report with id [{}]", (Object)reportId);
        MgetResponse<ReportDefinitionDto> multiGetItemResponses = this.performMultiGetReportRequest(reportId);
        Optional<Object> result = Optional.empty();
        for (MultiGetResponseItem itemResponse : multiGetItemResponses.docs()) {
            GetResult response = itemResponse.result();
            Optional reportDefinitionDto = OpensearchReaderUtil.processGetResponse(response);
            if (!reportDefinitionDto.isPresent()) continue;
            result = reportDefinitionDto;
            break;
        }
        return result;
    }

    @Override
    public Optional<SingleProcessReportDefinitionRequestDto> getSingleProcessReportOmitXml(String reportId) {
        LOG.debug("Fetching single process report with id [{}]", (Object)reportId);
        GetRequest.Builder getRequest = this.getGetRequestOmitXml("single-process-report", reportId);
        String errorMessage = String.format("Could not fetch single process report with id [%s]", reportId);
        GetResponse getResponse = this.osClient.get(getRequest, SingleProcessReportDefinitionRequestDto.class, errorMessage);
        if (!getResponse.found()) {
            return Optional.empty();
        }
        return Optional.ofNullable((SingleProcessReportDefinitionRequestDto)getResponse.source());
    }

    @Override
    public Optional<SingleDecisionReportDefinitionRequestDto> getSingleDecisionReportOmitXml(String reportId) {
        LOG.debug("Fetching single decision report with id [{}]", (Object)reportId);
        GetRequest.Builder getRequest = this.getGetRequestOmitXml("single-decision-report", reportId);
        String errorMessage = String.format("Could not fetch single decision report with id [%s]", reportId);
        GetResponse getResponse = this.osClient.get(getRequest, SingleDecisionReportDefinitionRequestDto.class, errorMessage);
        if (!getResponse.found()) {
            return Optional.empty();
        }
        return Optional.ofNullable((SingleDecisionReportDefinitionRequestDto)getResponse.source());
    }

    @Override
    public List<ReportDefinitionDto> getAllReportsForIdsOmitXml(List<String> reportIds) {
        OpenSearchDocumentOperations.AggregatedResult searchResponse;
        if (reportIds.isEmpty()) {
            LOG.debug("No report IDs supplied so no reports to fetch");
            return Collections.emptyList();
        }
        LOG.debug("Fetching all report definitions for Ids {}", reportIds);
        String[] reportIdsAsArray = reportIds.toArray(new String[0]);
        Query reportIdsQuery = QueryDSL.ids((String[])reportIdsAsArray);
        SearchRequest.Builder searchRequest = this.getSearchRequestOmitXml(reportIdsQuery, ALL_REPORT_INDICES, 1000).scroll((Time)new Time.Builder().time(String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())).build());
        try {
            searchResponse = this.osClient.retrieveAllScrollResults(searchRequest, ReportDefinitionDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch all reports definitions for ids [%s]", reportIds);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(searchResponse);
    }

    @Override
    public List<ReportDefinitionDto> getAllReportsForProcessDefinitionKeyOmitXml(String definitionKey) {
        List<ReportDefinitionDto> processReportsForKey = this.getAllProcessReportsForDefinitionKeyOmitXml(definitionKey);
        List<String> processReportIds = processReportsForKey.stream().map(ReportDefinitionDto::getId).toList();
        List<CombinedReportDefinitionRequestDto> combinedReports = this.getCombinedReportsForSimpleReports(processReportIds);
        processReportsForKey.addAll(combinedReports);
        return processReportsForKey;
    }

    @Override
    public List<ReportDefinitionDto> getAllPrivateReportsOmitXml() {
        OpenSearchDocumentOperations.AggregatedResult searchResponse;
        LOG.debug("Fetching all available private reports");
        Query privateReportsQuery = new BoolQuery.Builder().mustNot(QueryDSL.exists((String)"collectionId"), new Query[0]).mustNot(QueryDSL.term((String)"data.managementReport", (boolean)true), new Query[0]).mustNot(QueryDSL.term((String)"data.instantPreviewReport", (boolean)true), new Query[0]).build().toQuery();
        SearchRequest.Builder searchRequest = this.getSearchRequestOmitXml(privateReportsQuery, ALL_REPORT_INDICES, 1000).scroll((Time)new Time.Builder().time(String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())).build());
        try {
            searchResponse = this.osClient.retrieveAllScrollResults(searchRequest, ReportDefinitionDto.class);
        }
        catch (IOException e) {
            String reason = "Was not able to fetch all private reports";
            LOG.error("Was not able to fetch all private reports", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to fetch all private reports", (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(searchResponse);
    }

    @Override
    public List<ReportDefinitionDto> getReportsForCollectionIncludingXml(String collectionId) {
        return this.getReportsForCollection(collectionId, true);
    }

    @Override
    public List<SingleProcessReportDefinitionRequestDto> getAllSingleProcessReportsForIdsOmitXml(List<String> reportIds) {
        LOG.debug("Fetching all available single process reports for IDs [{}]", reportIds);
        String[] indices = new String[]{"single-process-report"};
        return this.getReportDefinitionDtos(reportIds, indices);
    }

    @Override
    public List<ReportDefinitionDto> getReportsForCollectionOmitXml(String collectionId) {
        return this.getReportsForCollection(collectionId, false);
    }

    @Override
    public List<CombinedReportDefinitionRequestDto> getCombinedReportsForSimpleReport(String simpleReportId) {
        return this.getCombinedReportsForSimpleReports(Collections.singletonList(simpleReportId));
    }

    @Override
    public long getReportCount(ReportType reportType) {
        String errorMessage = String.format("Was not able to retrieve %s report counts!", reportType);
        if (ReportType.PROCESS.equals((Object)reportType)) {
            Query query = new BoolQuery.Builder().mustNot(QueryDSL.term((String)"data.managementReport", (boolean)true), new Query[0]).mustNot(QueryDSL.term((String)"data.instantPreviewReport", (boolean)true), new Query[0]).build().toQuery();
            return this.osClient.count(new String[]{"single-process-report"}, query, errorMessage);
        }
        return this.osClient.count(new String[]{"single-decision-report"}, QueryDSL.matchAll(), errorMessage);
    }

    @Override
    public long getUserTaskReportCount() {
        Query query = new BoolQuery.Builder().mustNot(QueryDSL.term((String)"data.managementReport", (boolean)true), new Query[0]).mustNot(QueryDSL.term((String)"data.instantPreviewReport", (boolean)true), new Query[0]).build().toQuery();
        SearchRequest.Builder searchRequest = this.getSearchRequestOmitXml(query, new String[]{"single-process-report"});
        String errorMessage = "Was not able to fetch process reports to count userTask reports.";
        SearchResponse searchResponse = this.osClient.search(searchRequest, SingleProcessReportDefinitionRequestDto.class, "Was not able to fetch process reports to count userTask reports.");
        List allProcessReports = OpensearchReaderUtil.extractResponseValues(searchResponse);
        return allProcessReports.stream().filter(report -> ((ProcessReportDataDto)report.getData()).isUserTaskReport()).count();
    }

    private List<ReportDefinitionDto> getAllProcessReportsForDefinitionKeyOmitXml(String definitionKey) {
        OpenSearchDocumentOperations.AggregatedResult searchResponse;
        LOG.debug("Fetching all available process reports for process definition key {}", (Object)definitionKey);
        Query processReportQuery = new BoolQuery.Builder().must(QueryDSL.term((String)String.join((CharSequence)".", "data", "definitions", "key"), (String)definitionKey), new Query[0]).build().toQuery();
        SearchRequest.Builder searchRequest = this.getSearchRequestOmitXml(processReportQuery, new String[]{"single-process-report"}, 1000).scroll((Time)new Time.Builder().time(String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())).build());
        try {
            searchResponse = this.osClient.retrieveAllScrollResults(searchRequest, ReportDefinitionDto.class);
        }
        catch (IOException e) {
            String reason = String.format("Was not able to fetch all process reports for definition key [%s]", definitionKey);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(searchResponse);
    }

    private List<CombinedReportDefinitionRequestDto> getCombinedReportsForSimpleReports(List<String> simpleReportIds) {
        LOG.debug("Fetching first combined reports using simpleReports with ids {}", simpleReportIds);
        Query inner = new NestedQuery.Builder().path(String.join((CharSequence)".", "data", "reports")).query(QueryDSL.terms((String)String.join((CharSequence)".", "data", "reports", "id"), simpleReportIds, FieldValue::of)).scoreMode(ChildScoreMode.None).build().toQuery();
        Query getCombinedReportsBySimpleReportIdQuery = new NestedQuery.Builder().path("data").query(inner).scoreMode(ChildScoreMode.None).build().toQuery();
        SearchRequest.Builder searchRequest = this.getSearchRequestOmitXml(getCombinedReportsBySimpleReportIdQuery, new String[]{"combined-report"});
        String errorMessage = String.format("Was not able to fetch combined reports that contain reports with ids [%s]", simpleReportIds);
        SearchResponse searchResponse = this.osClient.search(searchRequest, CombinedReportDefinitionRequestDto.class, errorMessage);
        return OpensearchReaderUtil.extractResponseValues(searchResponse);
    }

    private List<ReportDefinitionDto> getReportsForCollection(String collectionId, boolean includeXml) {
        LOG.debug("Fetching reports using collection with id {}", (Object)collectionId);
        Query reportByCollectionQuery = new BoolQuery.Builder().must(QueryDSL.term((String)"collectionId", (String)collectionId), new Query[0]).mustNot(QueryDSL.term((String)"data.managementReport", (boolean)true), new Query[0]).mustNot(QueryDSL.term((String)"data.instantPreviewReport", (boolean)true), new Query[0]).build().toQuery();
        SearchRequest.Builder searchRequest = includeXml ? this.getSearchRequestIncludingXml(reportByCollectionQuery, ALL_REPORT_INDICES) : this.getSearchRequestOmitXml(reportByCollectionQuery, ALL_REPORT_INDICES);
        String errorMessage = String.format("Was not able to fetch reports for collection with id [%s]", collectionId);
        SearchResponse searchResponse = this.osClient.search(searchRequest, ReportDefinitionDto.class, errorMessage);
        return OpensearchReaderUtil.extractResponseValues(searchResponse);
    }

    private <T extends ReportDefinitionDto> List<T> getReportDefinitionDtos(List<String> reportIds, String[] indices) {
        if (reportIds.isEmpty()) {
            return Collections.emptyList();
        }
        String[] reportIdsAsArray = reportIds.toArray(new String[0]);
        Query qb = QueryDSL.ids((String[])reportIdsAsArray);
        SearchResponse searchResponse = this.performGetReportRequestOmitXml(qb, indices, reportIdsAsArray.length);
        return OpensearchReaderUtil.extractResponseValues(searchResponse).stream().sorted(Comparator.comparingInt(element -> reportIds.indexOf(element.getId()))).collect(Collectors.toList());
    }

    private GetRequest.Builder getGetRequestOmitXml(String index, String reportId) {
        return new GetRequest.Builder().index(index).id(reportId).sourceExcludes(Arrays.asList(REPORT_LIST_EXCLUDES));
    }

    private SearchRequest.Builder getSearchRequestOmitXml(Query query, String[] indices) {
        return this.getSearchRequestOmitXml(query, indices, 1000);
    }

    private SearchRequest.Builder getSearchRequestIncludingXml(Query query, String[] indices) {
        return this.getSearchRequest(query, indices, 1000, new String[0]);
    }

    private SearchRequest.Builder getSearchRequestOmitXml(Query query, String[] indices, int size) {
        return this.getSearchRequest(query, indices, size, REPORT_LIST_EXCLUDES);
    }

    private SearchRequest.Builder getSearchRequest(Query query, String[] indices, int size, String[] excludeFields) {
        SourceConfig.Builder sourceConfig = new SourceConfig.Builder();
        if (excludeFields.length == 0) {
            sourceConfig.fetch(Boolean.valueOf(true));
        } else {
            SourceFilter filter = new SourceFilter.Builder().excludes(Arrays.asList(excludeFields)).build();
            sourceConfig.filter(filter);
        }
        return new SearchRequest.Builder().index(Arrays.asList(indices)).query(query).size(Integer.valueOf(size)).source(sourceConfig.build());
    }

    private SearchResponse performGetReportRequestOmitXml(Query query, String[] indices, int size) {
        SearchRequest.Builder searchRequest = this.getSearchRequestOmitXml(query, indices, size);
        String errorMessage = "Was not able to retrieve reports!";
        return this.osClient.search(searchRequest, ReportDefinitionDto.class, "Was not able to retrieve reports!");
    }

    private MgetResponse<ReportDefinitionDto> performMultiGetReportRequest(String reportId) {
        String errorMessage = String.format("Could not fetch report with id [%s]", reportId);
        HashMap<String, String> indexesToEntitiesId = new HashMap<String, String>();
        indexesToEntitiesId.put("single-process-report", reportId);
        indexesToEntitiesId.put("single-decision-report", reportId);
        indexesToEntitiesId.put("combined-report", reportId);
        return this.osClient.mget(ReportDefinitionDto.class, errorMessage, indexesToEntitiesId);
    }
}

