/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.dto.optimize.query.collection.BaseCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionEntity;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameRequestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameResponseDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityType;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.os.client.sync.OpenSearchDocumentOperations;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.os.schema.index.DashboardIndexOS;
import io.camunda.optimize.service.db.os.schema.index.report.CombinedReportIndexOS;
import io.camunda.optimize.service.db.os.schema.index.report.SingleDecisionReportIndexOS;
import io.camunda.optimize.service.db.os.schema.index.report.SingleProcessReportIndexOS;
import io.camunda.optimize.service.db.reader.EntitiesReader;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.types.MapUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.mget.MultiGetResponseItem;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.core.search.SourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class EntitiesReaderOS
implements EntitiesReader {
    private static final Logger LOG = LoggerFactory.getLogger(EntitiesReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;
    private final OptimizeIndexNameService optimizeIndexNameService;
    private final LocalizationService localizationService;

    public EntitiesReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService, OptimizeIndexNameService optimizeIndexNameService, LocalizationService localizationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
        this.optimizeIndexNameService = optimizeIndexNameService;
        this.localizationService = localizationService;
    }

    @Override
    public List<CollectionEntity> getAllPrivateEntities() {
        return this.getAllPrivateEntitiesForOwnerId(null);
    }

    @Override
    public List<CollectionEntity> getAllPrivateEntitiesForOwnerId(String ownerId) {
        OpenSearchDocumentOperations.AggregatedResult scrollResp;
        LOG.debug("Fetching all available entities for user [{}]", (Object)ownerId);
        BoolQuery.Builder query = new BoolQuery.Builder().mustNot(QueryDSL.exists((String)"collectionId"), new Query[0]).must(new BoolQuery.Builder().minimumShouldMatch("1").should(QueryDSL.term((String)"managementDashboard", (boolean)false), new Query[0]).should(QueryDSL.term((String)"data.managementReport", (boolean)false), new Query[0]).should(new BoolQuery.Builder().mustNot(QueryDSL.exists((String)"managementDashboard"), new Query[0]).mustNot(QueryDSL.exists((String)"data.managementReport"), new Query[0]).build().toQuery(), new Query[0]).build().toQuery(), new Query[0]).must(new BoolQuery.Builder().minimumShouldMatch("1").should(QueryDSL.term((String)"instantPreviewDashboard", (boolean)false), new Query[0]).should(QueryDSL.term((String)"data.instantPreviewReport", (boolean)false), new Query[0]).should(new BoolQuery.Builder().mustNot(QueryDSL.exists((String)"instantPreviewDashboard"), new Query[0]).mustNot(QueryDSL.exists((String)"data.instantPreviewReport"), new Query[0]).build().toQuery(), new Query[0]).build().toQuery(), new Query[0]);
        if (ownerId != null) {
            query.must(QueryDSL.term((String)"owner", (String)ownerId), new Query[0]);
        }
        SourceFilter filter = new SourceFilter.Builder().excludes(Arrays.asList(ENTITY_LIST_EXCLUDES)).build();
        SourceConfig sourceConfig = (SourceConfig)new SourceConfig.Builder().filter(filter).build();
        SearchRequest.Builder requestBuilder = this.createReportAndDashboardSearchRequest().size(Integer.valueOf(1000)).query(query.build().toQuery()).source(sourceConfig).scroll(RequestDSL.time((String)String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())));
        try {
            scrollResp = this.osClient.retrieveAllScrollResults(requestBuilder, CollectionEntity.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve private entities!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve private entities!", (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(scrollResp);
    }

    @Override
    public Map<String, Map<EntityType, Long>> countEntitiesForCollections(List<? extends BaseCollectionDefinitionDto<?>> collections) {
        List<String> collectionIds = collections.stream().map(BaseCollectionDefinitionDto::getId).toList();
        LOG.debug("Counting all available entities for collection ids [{}]", collectionIds);
        if (collections.isEmpty()) {
            return new HashMap<String, Map<EntityType, Long>>();
        }
        Map aggregations = (Map)collectionIds.stream().map(collectionId -> {
            Aggregation termsAggregation = new TermsAggregation.Builder().field("_index").build()._toAggregation();
            Aggregation aggregation = new Aggregation.Builder().filter(QueryDSL.term((String)"collectionId", (String)collectionId)).aggregations(Map.of("byIndexCount", termsAggregation)).build();
            return Pair.of((Object)collectionId, (Object)aggregation);
        }).collect(MapUtil.pairCollector());
        SearchRequest.Builder searchRequestBuilder = this.createReportAndDashboardSearchRequest().query(QueryDSL.terms((String)"collectionId", collectionIds)).aggregations(aggregations).size(Integer.valueOf(0));
        String errorMessage = "Was not able to count collection entities!";
        SearchResponse searchResponse = this.osClient.search(searchRequestBuilder, CollectionEntity.class, "Was not able to count collection entities!");
        return searchResponse.aggregations().entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), this.extractEntityIndexCounts(((Aggregate)entry.getValue()).filter()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public List<CollectionEntity> getAllEntitiesForCollection(String collectionId) {
        OpenSearchDocumentOperations.AggregatedResult scrollResp;
        LOG.debug("Fetching all available entities for collection [{}]", (Object)collectionId);
        SearchRequest.Builder requestBuilder = this.createReportAndDashboardSearchRequest().size(Integer.valueOf(1000)).query(QueryDSL.term((String)"collectionId", (String)collectionId)).scroll(RequestDSL.time((String)String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())));
        try {
            scrollResp = this.osClient.retrieveAllScrollResults(requestBuilder, CollectionEntity.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve collection entities!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve entities!", (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(scrollResp);
    }

    @Override
    public Optional<EntityNameResponseDto> getEntityNames(EntityNameRequestDto requestDto, String locale) {
        LOG.debug(String.format("Performing get entity names search request %s", requestDto.toString()));
        MgetResponse<CollectionEntity> multiGetItemResponse = this.runGetEntityNamesRequest(requestDto);
        boolean atLeastOneResponseExistsForMultiGet = multiGetItemResponse.docs().stream().anyMatch(doc -> doc.result().found());
        if (!atLeastOneResponseExistsForMultiGet) {
            return Optional.empty();
        }
        EntityNameResponseDto result = new EntityNameResponseDto();
        for (MultiGetResponseItem itemResponse : multiGetItemResponse.docs()) {
            if (!itemResponse.isResult()) continue;
            Optional<CollectionEntity> optionalResponse = OpensearchReaderUtil.processGetResponse(itemResponse.result());
            optionalResponse.ifPresent(entity -> {
                String entityId = entity.getId();
                if (entityId.equals(requestDto.getCollectionId())) {
                    result.setCollectionName(entity.getName());
                }
                if (entityId.equals(requestDto.getDashboardId())) {
                    result.setDashboardName(this.getLocalizedDashboardName((DashboardDefinitionRestDto)entity, locale));
                } else if (entityId.equals(requestDto.getReportId())) {
                    result.setReportName(this.getLocalizedReportName(this.localizationService, (CollectionEntity)entity, locale));
                }
            });
        }
        return Optional.of(result);
    }

    private Map<EntityType, Long> extractEntityIndexCounts(FilterAggregate collectionFilterAggregation) {
        StringTermsAggregate byIndexNameTerms = ((Aggregate)collectionFilterAggregation.aggregations().get("byIndexCount")).sterms();
        long singleProcessReportCount = this.getDocCountForIndex(byIndexNameTerms, (IndexMappingCreator<?>)new SingleProcessReportIndexOS());
        long combinedProcessReportCount = this.getDocCountForIndex(byIndexNameTerms, (IndexMappingCreator<?>)new CombinedReportIndexOS());
        long singleDecisionReportCount = this.getDocCountForIndex(byIndexNameTerms, (IndexMappingCreator<?>)new SingleDecisionReportIndexOS());
        long dashboardCount = this.getDocCountForIndex(byIndexNameTerms, (IndexMappingCreator<?>)new DashboardIndexOS());
        return ImmutableMap.of((Object)EntityType.DASHBOARD, (Object)dashboardCount, (Object)EntityType.REPORT, (Object)(singleProcessReportCount + singleDecisionReportCount + combinedProcessReportCount));
    }

    private long getDocCountForIndex(StringTermsAggregate byIndexNameTerms, IndexMappingCreator<?> indexMapper) {
        return byIndexNameTerms.buckets().array().stream().filter(s -> this.optimizeIndexNameService.getOptimizeIndexNameWithVersionWithoutSuffix(indexMapper).equals(s.key())).findFirst().map(MultiBucketBase::docCount).orElse(0L);
    }

    private MgetResponse<CollectionEntity> runGetEntityNamesRequest(EntityNameRequestDto requestDto) {
        HashMap<String, String> indexesToEntitiesId = new HashMap<String, String>();
        indexesToEntitiesId.put("single-process-report", requestDto.getReportId());
        indexesToEntitiesId.put("single-decision-report", requestDto.getReportId());
        indexesToEntitiesId.put("combined-report", requestDto.getReportId());
        indexesToEntitiesId.put("dashboard", requestDto.getDashboardId());
        indexesToEntitiesId.put("collection", requestDto.getCollectionId());
        boolean isEmpty = indexesToEntitiesId.entrySet().stream().noneMatch(e -> e.getValue() != null);
        if (isEmpty) {
            throw new BadRequestException("No ids for entity name request provided");
        }
        String errorMessage = String.format("Could not get entity names search request %s", requestDto);
        return this.osClient.mget(CollectionEntity.class, errorMessage, indexesToEntitiesId);
    }

    private SearchRequest.Builder createReportAndDashboardSearchRequest() {
        return new SearchRequest.Builder().index("single-process-report", new String[]{"single-decision-report", "combined-report", "dashboard"});
    }

    private String getLocalizedDashboardName(DashboardDefinitionRestDto dashboardEntity, String locale) {
        if (dashboardEntity.isInstantPreviewDashboard()) {
            return this.localizationService.getLocalizationForInstantPreviewDashboardCode(locale, dashboardEntity.getName());
        }
        if (dashboardEntity.isManagementDashboard()) {
            return this.localizationService.getLocalizationForManagementDashboardCode(locale, dashboardEntity.getName());
        }
        return dashboardEntity.getName();
    }
}

