/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.analysis.DurationChartEntryDto;
import io.camunda.optimize.dto.optimize.query.analysis.FindingsDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.FlowNodeOutlierVariableParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.OutlierAnalysisServiceParameters;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessDefinitionParametersDto;
import io.camunda.optimize.dto.optimize.query.analysis.ProcessInstanceIdDto;
import io.camunda.optimize.dto.optimize.query.analysis.VariableTermDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessToQueryDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.builders.OptimizeSearchRequestOS;
import io.camunda.optimize.service.db.os.report.filter.ProcessQueryFilterEnhancerOS;
import io.camunda.optimize.service.db.os.schema.index.ProcessInstanceIndexOS;
import io.camunda.optimize.service.db.os.util.DefinitionQueryUtilOS;
import io.camunda.optimize.service.db.reader.DurationOutliersReader;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.reader.ProcessVariableReader;
import io.camunda.optimize.service.db.schema.index.AbstractInstanceIndex;
import io.camunda.optimize.service.db.util.AggregationNameUtil;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.LogUtil;
import java.io.IOException;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.ExtendedStatsAggregate;
import org.opensearch.client.opensearch._types.aggregations.ExtendedStatsAggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.ReverseNestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.StatsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StatsAggregation;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DurationOutliersReaderOS
implements DurationOutliersReader {
    private static final Logger LOG = LoggerFactory.getLogger(DurationOutliersReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ProcessDefinitionReader processDefinitionReader;
    private final ProcessVariableReader processVariableReader;
    private final ProcessQueryFilterEnhancerOS queryFilterEnhancer;
    private final ConfigurationService configurationService;

    public DurationOutliersReaderOS(OptimizeOpenSearchClient osClient, ProcessDefinitionReader processDefinitionReader, ProcessVariableReader processVariableReader, ProcessQueryFilterEnhancerOS queryFilterEnhancer, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.processDefinitionReader = processDefinitionReader;
        this.processVariableReader = processVariableReader;
        this.queryFilterEnhancer = queryFilterEnhancer;
        this.configurationService = configurationService;
    }

    @Override
    public List<DurationChartEntryDto> getCountByDurationChart(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierAnalysisParams) {
        SearchResponse search;
        BoolQuery query = this.buildBaseQuery(outlierAnalysisParams).build();
        FlowNodeOutlierParametersDto outlierParams = outlierAnalysisParams.getProcessDefinitionParametersDto();
        long interval = this.getInterval(query, outlierParams.getFlowNodeId(), outlierParams.getProcessDefinitionKey());
        Aggregation histogram = Aggregation.of(a -> a.histogram(h -> h.field("flowNodeInstances.totalDurationInMs").interval(Double.valueOf(interval))));
        Aggregation nestedAgg = this.buildNestedFlowNodeFilterAggregation(outlierParams.getFlowNodeId(), "histogram", histogram);
        SearchRequest searchRequest = OptimizeSearchRequestOS.of(s -> s.optimizeIndex(this.osClient, new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)outlierParams.getProcessDefinitionKey())}).query(q -> q.bool(query)).source(o -> o.fetch(Boolean.valueOf(false))).aggregations("flowNodeInstances", nestedAgg).size(Integer.valueOf(0)));
        try {
            search = this.osClient.searchUnsafe(searchRequest, DurationChartEntryDto.class);
        }
        catch (IOException e) {
            LOG.warn("Couldn't retrieve duration chart");
            throw new OptimizeRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (OpenSearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to evaluate count by duration chart because instance index with alias {} does not exist. Returning empty list.", (Object)LogUtil.sanitizeLogMessage((String)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)outlierParams.getProcessDefinitionKey())));
                return Collections.emptyList();
            }
            throw e;
        }
        return ((Aggregate)((Aggregate)((Aggregate)search.aggregations().get("flowNodeInstances")).nested().aggregations().get("filteredFlowNodes")).filter().aggregations().get("histogram")).histogram().buckets().array().stream().map(b -> {
            try {
                Long durationKey = Double.valueOf(b.key()).longValue();
                return new DurationChartEntryDto(durationKey, b.docCount(), this.isOutlier(outlierParams.getLowerOutlierBound(), outlierParams.getHigherOutlierBound(), durationKey));
            }
            catch (NumberFormatException exception) {
                throw new OptimizeRuntimeException("Error mapping key to numerical value: " + b.keyAsString());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, FindingsDto> getFlowNodeOutlierMap(OutlierAnalysisServiceParameters<ProcessDefinitionParametersDto> outlierAnalysisParams) {
        SearchResponse searchResponse;
        BoolQuery.Builder processInstanceQuery = this.buildBaseQuery(outlierAnalysisParams);
        ExtendedStatsAggregation extendedStatsAggregation = ExtendedStatsAggregation.of(e -> (ObjectBuilder)e.field("flowNodeInstances.totalDurationInMs"));
        BoolQuery.Builder builder = new BoolQuery.Builder();
        ProcessDefinitionParametersDto processDefinitionParametersDto = outlierAnalysisParams.getProcessDefinitionParametersDto();
        if (Boolean.TRUE.equals(processDefinitionParametersDto.getDisconsiderAutomatedTasks())) {
            builder.filter(f -> f.terms(t -> t.field("flowNodeInstances.flowNodeType").terms(tt -> tt.value(this.generateListOfHumanTasks().stream().map(FieldValue::of).toList()))));
        } else {
            builder.filter(f -> f.bool(b -> b.mustNot(m -> m.terms(t -> t.field("flowNodeInstances.flowNodeType").terms(tt -> tt.value(this.generateListOfStandardExcludedFlowNodeTypes().stream().map(FieldValue::of).toList()))))));
        }
        Aggregation aggregationFlowNodeTypeAndId = Aggregation.of(a -> a.filter(f -> f.bool(builder.build())).aggregations("flowNodeId", Aggregation.of(aa -> aa.terms(t -> t.field("flowNodeInstances.flowNodeId").size(this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit())).aggregations("stats", Aggregation.of(aaa -> aaa.extendedStats(extendedStatsAggregation))))));
        Aggregation nested = Aggregation.of(a -> a.nested(n -> n.path("flowNodeInstances")).aggregations("flowNodeTypeFilter", aggregationFlowNodeTypeAndId));
        BoolQuery boolQuery = processInstanceQuery.build();
        SearchRequest searchRequest = OptimizeSearchRequestOS.of(o -> o.optimizeIndex(this.osClient, new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionParametersDto.getProcessDefinitionKey())}).query(q -> q.bool(boolQuery)).source(s -> s.fetch(Boolean.valueOf(false))).aggregations("nested", nested).size(Integer.valueOf(0)));
        try {
            searchResponse = this.osClient.searchUnsafe(searchRequest, Object.class);
        }
        catch (IOException e2) {
            String reason = "Could not fetch data to generate Outlier Analysis Heatmap";
            LOG.error("Could not fetch data to generate Outlier Analysis Heatmap", (Throwable)e2);
            throw new OptimizeRuntimeException("Could not fetch data to generate Outlier Analysis Heatmap", (Throwable)e2);
        }
        catch (OpenSearchException e3) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e3))) {
                LOG.info("Was not able to get Flow Node outlier map because instance index with alias {} does not exist. Returning empty results.", (Object)LogUtil.sanitizeLogMessage((String)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionParametersDto.getProcessDefinitionKey())));
                return Collections.emptyMap();
            }
            throw e3;
        }
        List deviationForEachFlowNode = ((Aggregate)((Aggregate)((Aggregate)searchResponse.aggregations().get("nested")).nested().aggregations().get("flowNodeTypeFilter")).filter().aggregations().get("flowNodeId")).sterms().buckets().array();
        return this.createFlowNodeOutlierMap(deviationForEachFlowNode, boolQuery, processDefinitionParametersDto);
    }

    @Override
    public List<VariableTermDto> getSignificantOutlierVariableTerms(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierAnalysisParams) {
        FlowNodeOutlierParametersDto outlierParams = outlierAnalysisParams.getProcessDefinitionParametersDto();
        if (outlierParams.getLowerOutlierBound() == null && outlierParams.getHigherOutlierBound() == null) {
            throw new OptimizeValidationException("One of lowerOutlierBound or higherOutlierBound must be set.");
        }
        try {
            List<String> variableNames = this.getVariableNames(outlierParams);
            Map<String, String> sanitisedNameToVarName = variableNames.stream().filter(AggregationNameUtil::containsIllegalChar).collect(Collectors.toMap(AggregationNameUtil::sanitiseAggName, Function.identity()));
            ReverseNestedAggregate outlierNestedProcessInstancesAgg = this.getTopVariableTermsOfOutliers(outlierAnalysisParams, variableNames);
            Map<String, Map<String, Long>> outlierVariableTermOccurrences = this.createVariableTermOccurrencesMap(((Aggregate)outlierNestedProcessInstancesAgg.aggregations().get("variables")).nested(), sanitisedNameToVarName);
            long outlierProcessInstanceCount = outlierNestedProcessInstancesAgg.docCount();
            Map<String, Set<String>> outlierVariableTerms = outlierVariableTermOccurrences.entrySet().stream().map(variableAndTerms -> new AbstractMap.SimpleEntry((String)variableAndTerms.getKey(), ((Map)variableAndTerms.getValue()).keySet())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (outlierProcessInstanceCount == 0L) {
                return new ArrayList<VariableTermDto>();
            }
            ReverseNestedAggregate nonOutlierNestedProcessInstancesAgg = this.getVariableTermOccurrencesOfNonOutliers(outlierAnalysisParams, outlierVariableTerms);
            Map<String, Map<String, Long>> nonOutlierVariableTermOccurrence = this.createVariableTermOccurrencesMap(((Aggregate)nonOutlierNestedProcessInstancesAgg.aggregations().get("variables")).nested(), sanitisedNameToVarName);
            long nonOutlierProcessInstanceCount = nonOutlierNestedProcessInstancesAgg.docCount();
            long totalProcessInstanceCount = outlierProcessInstanceCount + nonOutlierProcessInstanceCount;
            Map<String, Map<String, Long>> outlierSignificantVariableTerms = this.filterSignificantOutlierVariableTerms(outlierVariableTermOccurrences, nonOutlierVariableTermOccurrence, outlierProcessInstanceCount, nonOutlierProcessInstanceCount);
            return this.mapToVariableTermList(outlierSignificantVariableTerms, nonOutlierVariableTermOccurrence, outlierProcessInstanceCount, nonOutlierProcessInstanceCount, totalProcessInstanceCount);
        }
        catch (IOException e) {
            LOG.warn("Couldn't determine significant outlier variable terms.");
            throw new OptimizeRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (OpenSearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to determine significant outlier variable terms because instance index with name {} does not exist. Returning empty list.", (Object)LogUtil.sanitizeLogMessage((String)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)outlierParams.getProcessDefinitionKey())));
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<ProcessInstanceIdDto> getSignificantOutlierVariableTermsInstanceIds(OutlierAnalysisServiceParameters<FlowNodeOutlierVariableParametersDto> outlierParamsDto) {
        FlowNodeOutlierVariableParametersDto flowNodeOutlierVariableParams = outlierParamsDto.getProcessDefinitionParametersDto();
        BoolQuery.Builder mainFilterQuery = this.buildBaseQuery(outlierParamsDto);
        BoolQuery.Builder flowNodeFilterQuery = this.createFlowNodeOutlierQuery(outlierParamsDto);
        mainFilterQuery.must(m -> m.nested(n -> n.path("flowNodeInstances").query(q -> q.bool(flowNodeFilterQuery.build())).scoreMode(ChildScoreMode.None)));
        BoolQuery.Builder variableTermFilterQuery = new BoolQuery.Builder();
        variableTermFilterQuery.must(m -> m.term(t -> t.field("variables.name").value(FieldValue.of((String)flowNodeOutlierVariableParams.getVariableName()))));
        variableTermFilterQuery.must(m -> m.term(t -> t.field("variables.value").value(FieldValue.of((String)flowNodeOutlierVariableParams.getVariableTerm()))));
        mainFilterQuery.must(m -> m.nested(n -> n.path("variables").query(q -> q.bool(variableTermFilterQuery.build())).scoreMode(ChildScoreMode.None)));
        Integer recordLimit = this.configurationService.getCsvConfiguration().getExportCsvLimit();
        SearchRequest scrollSearchRequest = OptimizeSearchRequestOS.of(b -> b.optimizeIndex(this.osClient, new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)flowNodeOutlierVariableParams.getProcessDefinitionKey())}).query(q -> q.bool(mainFilterQuery.build())).source(s -> s.filter(f -> f.includes("processInstanceId", new String[0]))).size(Integer.valueOf(recordLimit > 10000 ? 10000 : recordLimit)).scroll(s -> s.time(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds() + "s")));
        try {
            ArrayList hits = new ArrayList();
            SearchResponse response = this.osClient.searchUnsafe(scrollSearchRequest, ProcessInstanceIdDto.class);
            this.osClient.scrollWith(response, hits::addAll, ProcessInstanceIdDto.class, recordLimit.intValue());
            return hits.stream().map(Hit::source).toList();
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Could not obtain outlier instance ids.", (Throwable)e);
        }
        catch (OpenSearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to obtain outlier instance IDs because instance index with name {} does not exist. Returning empty list.", (Object)LogUtil.sanitizeLogMessage((String)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)flowNodeOutlierVariableParams.getProcessDefinitionKey())));
                return Collections.emptyList();
            }
            throw e;
        }
    }

    private <T extends FlowNodeOutlierParametersDto> BoolQuery.Builder createFlowNodeOutlierQuery(OutlierAnalysisServiceParameters<T> outlierParameters) {
        FlowNodeOutlierParametersDto outlierParams = (FlowNodeOutlierParametersDto)outlierParameters.getProcessDefinitionParametersDto();
        BoolQuery.Builder flowNodeFilterQuery = new BoolQuery.Builder();
        flowNodeFilterQuery.must(m -> m.term(t -> t.field("flowNodeInstances.flowNodeId").value(FieldValue.of((String)outlierParams.getFlowNodeId())))).minimumShouldMatch("1");
        if (outlierParams.getHigherOutlierBound() != null) {
            flowNodeFilterQuery.should(s -> s.range(r -> r.gt(JsonData.of((Object)outlierParams.getHigherOutlierBound())).field("flowNodeInstances.totalDurationInMs")));
        }
        if (outlierParams.getLowerOutlierBound() != null) {
            flowNodeFilterQuery.should(s -> s.range(r -> r.lt(JsonData.of((Object)outlierParams.getLowerOutlierBound())).field("flowNodeInstances.totalDurationInMs")));
        }
        flowNodeFilterQuery.filter(this.getQueryFilters(outlierParams, outlierParameters.getZoneId()));
        return flowNodeFilterQuery;
    }

    private List<Query> getQueryFilters(ProcessDefinitionParametersDto params, ZoneId zoneId) {
        return this.queryFilterEnhancer.filterQueries(params.getFilters(), FilterContext.builder().timezone(zoneId).build());
    }

    private ReverseNestedAggregate getVariableTermOccurrencesOfNonOutliers(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierParams, Map<String, Set<String>> outlierVariableTerms) throws IOException {
        SearchRequest nonOutliersTermOccurrencesRequest = this.createTopVariableTermsOfNonOutliersQuery(outlierParams, outlierVariableTerms);
        return this.extractNestedProcessInstanceAgg(this.osClient.searchUnsafe(nonOutliersTermOccurrencesRequest, Object.class));
    }

    private ReverseNestedAggregate getTopVariableTermsOfOutliers(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierAnalysisParams, List<String> variableNames) throws IOException {
        SearchRequest outlierTopVariableTermsRequest = this.createTopVariableTermsOfOutliersQuery(outlierAnalysisParams, variableNames);
        return this.extractNestedProcessInstanceAgg(this.osClient.searchUnsafe(outlierTopVariableTermsRequest, Object.class));
    }

    private List<String> getVariableNames(FlowNodeOutlierParametersDto outlierParams) {
        List<String> variableNames = this.processVariableReader.getVariableNames(new ProcessVariableNameRequestDto(List.of(new ProcessToQueryDto(outlierParams.getProcessDefinitionKey(), outlierParams.getProcessDefinitionVersions(), outlierParams.getTenantIds())))).stream().map(ProcessVariableNameResponseDto::getName).collect(Collectors.toList());
        return variableNames;
    }

    private SearchRequest createTopVariableTermsOfOutliersQuery(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierParams, List<String> variableNames) {
        BoolQuery.Builder flowNodeFilterQuery = this.createFlowNodeOutlierQuery(outlierParams);
        Aggregation nestedVariableAggregation = Aggregation.of(a -> {
            Aggregation.Builder.ContainerBuilder nested = a.nested(n -> n.path("variables"));
            variableNames.stream().distinct().forEach(variableName -> nested.aggregations(AggregationNameUtil.sanitiseAggName(variableName), Aggregation.of(aa -> aa.filter(f -> f.term(t -> t.field("variables.name").value(FieldValue.of((String)variableName)))).aggregations("variableValueTerms", Aggregation.of(aaa -> aaa.terms(tt -> tt.field("variables.value").minDocCount(Integer.valueOf(3))))))));
            return nested;
        });
        return this.createFilteredFlowNodeVariableAggregation(outlierParams, flowNodeFilterQuery.build(), "variables", nestedVariableAggregation);
    }

    private SearchRequest createTopVariableTermsOfNonOutliersQuery(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierParameters, Map<String, Set<String>> variablesAndTerms) {
        FlowNodeOutlierParametersDto outlierParams = outlierParameters.getProcessDefinitionParametersDto();
        BoolQuery.Builder flowNodeFilterQuery = new BoolQuery.Builder();
        flowNodeFilterQuery.must(m -> m.term(t -> t.field("flowNodeInstances.flowNodeId").value(FieldValue.of((String)outlierParams.getFlowNodeId())))).minimumShouldMatch("1");
        if (outlierParams.getHigherOutlierBound() != null) {
            flowNodeFilterQuery.should(s -> s.range(r -> r.field("flowNodeInstances.totalDurationInMs").lte(JsonData.of((Object)outlierParams.getHigherOutlierBound()))));
        }
        if (outlierParams.getLowerOutlierBound() != null) {
            flowNodeFilterQuery.should(s -> s.range(r -> r.field("flowNodeInstances.totalDurationInMs").gte(JsonData.of((Object)outlierParams.getLowerOutlierBound()))));
        }
        Aggregation nestedVariableAggregation = Aggregation.of(a -> {
            Aggregation.Builder.ContainerBuilder nested = a.nested(n -> n.path("variables"));
            variablesAndTerms.forEach((variableName, value) -> nested.aggregations(variableName, Aggregation.of(aa -> aa.filter(f -> f.term(t -> t.field("variables.name").value(FieldValue.of((String)variableName)))).aggregations("variableValueTerms", Aggregation.of(aaa -> aaa.terms(t -> t.field("variables.value").include(tt -> tt.terms(value.stream().toList()))))))));
            return nested;
        });
        return this.createFilteredFlowNodeVariableAggregation(outlierParameters, flowNodeFilterQuery.build(), "variables", nestedVariableAggregation);
    }

    private SearchRequest createFilteredFlowNodeVariableAggregation(OutlierAnalysisServiceParameters<FlowNodeOutlierParametersDto> outlierParams, BoolQuery flowNodeFilterQuery, String aggName, Aggregation nestedVariableAggregation) {
        Aggregation flowNodeFilterAggregation = Aggregation.of(a -> a.filter(f -> f.bool(flowNodeFilterQuery)).aggregations("processInstance", Aggregation.of(aa -> aa.reverseNested(r -> r).aggregations(aggName, nestedVariableAggregation))));
        Aggregation nestedFlowNodeAggregation = Aggregation.of(a -> a.nested(n -> n.path("flowNodeInstances")).aggregations("filteredFlowNodes", flowNodeFilterAggregation));
        return OptimizeSearchRequestOS.of(b -> b.optimizeIndex(this.osClient, new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)((FlowNodeOutlierParametersDto)outlierParams.getProcessDefinitionParametersDto()).getProcessDefinitionKey())}).query(q -> q.bool(this.buildBaseQuery(outlierParams).build())).source(s -> s.fetch(Boolean.valueOf(false))).aggregations("flowNodeInstances", nestedFlowNodeAggregation).size(Integer.valueOf(0)));
    }

    private Map<String, Map<String, Long>> createVariableTermOccurrencesMap(NestedAggregate allVariableAggregations, Map<String, String> sanitisedVarsToVarNames) {
        HashMap<String, Map<String, Long>> outlierVariableTermOccurrences = new HashMap<String, Map<String, Long>>();
        allVariableAggregations.aggregations().forEach((aggName, aggregation) -> {
            FilterAggregate variableFilterAggregation = aggregation.filter();
            StringTermsAggregate variableValueTerms = ((Aggregate)variableFilterAggregation.aggregations().get("variableValueTerms")).sterms();
            if (!variableValueTerms.buckets().array().isEmpty()) {
                Map<String, Long> termOccurrences = variableValueTerms.buckets().array().stream().map(bucket -> new AbstractMap.SimpleEntry<String, Long>(bucket.key(), bucket.docCount())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
                outlierVariableTermOccurrences.put(Optional.ofNullable((String)sanitisedVarsToVarNames.get(aggName)).orElse((String)aggName), termOccurrences);
            }
        });
        return outlierVariableTermOccurrences;
    }

    private Map<String, FindingsDto> createFlowNodeOutlierMap(List<StringTermsBucket> deviationForEachFlowNode, BoolQuery processInstanceQuery, ProcessDefinitionParametersDto processDefinitionParams) {
        HashMap<String, ExtendedStatsAggregate> statsByFlowNodeId = new HashMap<String, ExtendedStatsAggregate>();
        Aggregation nestedFlowNodeAggregation = Aggregation.of(a -> {
            Aggregation.Builder.ContainerBuilder nested = a.nested(n -> n.path("flowNodeInstances"));
            deviationForEachFlowNode.forEach(bucket -> {
                String flowNodeId = bucket.key();
                ExtendedStatsAggregate statsAgg = ((Aggregate)bucket.aggregations().get("stats")).extendedStats();
                statsByFlowNodeId.put(flowNodeId, statsAgg);
                if (statsAgg.stdDeviation() != 0.0) {
                    double stdDeviationBoundLower = statsAgg.stdDeviationBounds().lower();
                    double stdDeviationBoundHigher = statsAgg.stdDeviationBounds().upper();
                    double average = statsAgg.avg();
                    stdDeviationBoundLower = Math.min(stdDeviationBoundLower, average - (double)processDefinitionParams.getMinimumDeviationFromAvg().longValue());
                    stdDeviationBoundHigher = Math.max(stdDeviationBoundHigher, average + (double)processDefinitionParams.getMinimumDeviationFromAvg().longValue());
                    double finalStdDeviationBoundLower = stdDeviationBoundLower;
                    Aggregation lowerOutlierEventFilter = Aggregation.of(aa -> aa.filter(f -> f.range(r -> r.field("flowNodeInstances.totalDurationInMs").lte(JsonData.of((Object)finalStdDeviationBoundLower)))));
                    double finalStdDeviationBoundHigher = stdDeviationBoundHigher;
                    Aggregation higherOutlierEventFilter = Aggregation.of(aa -> aa.filter(f -> f.range(r -> r.field("flowNodeInstances.totalDurationInMs").gte(JsonData.of((Object)finalStdDeviationBoundHigher)))));
                    TermQuery terms = TermQuery.of(t -> t.field("flowNodeInstances.flowNodeId").value(FieldValue.of((String)flowNodeId)));
                    Aggregation filteredFlowNodes = Aggregation.of(aa -> aa.filter(f -> f.term(terms)).aggregations("lowerDurationAgg", lowerOutlierEventFilter).aggregations("higherDurationAgg", higherOutlierEventFilter));
                    nested.aggregations(this.getFilteredFlowNodeAggregationName(flowNodeId), filteredFlowNodes);
                }
            });
            return nested;
        });
        SearchRequest searchRequest = OptimizeSearchRequestOS.of(s -> s.optimizeIndex(this.osClient, new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionParams.getProcessDefinitionKey())}).query(q -> q.bool(processInstanceQuery)).source(o -> o.fetch(Boolean.valueOf(false))).size(Integer.valueOf(0)).aggregations("flowNodeInstances", nestedFlowNodeAggregation));
        try {
            Map allFlowNodesPercentileRanks = this.osClient.searchUnsafe(searchRequest, Object.class).aggregations();
            Map allFlowNodeFilterAggs = ((Aggregate)allFlowNodesPercentileRanks.get("flowNodeInstances")).nested().aggregations();
            return this.mapToFlowNodeFindingsMap(statsByFlowNodeId, allFlowNodeFilterAggs);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (OpenSearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to retrieve flownode outlier map because instance index with alias {} does not exist. Returning empty map.", (Object)LogUtil.sanitizeLogMessage((String)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionParams.getProcessDefinitionKey())));
                return Collections.emptyMap();
            }
            throw e;
        }
    }

    private Map<String, FindingsDto> mapToFlowNodeFindingsMap(Map<String, ExtendedStatsAggregate> statsByFlowNodeId, Map<String, Aggregate> allFlowNodeFilterAggs) {
        AtomicLong totalLowerOutlierCount = new AtomicLong(0L);
        AtomicLong totalHigherOutlierCount = new AtomicLong(0L);
        Map<String, FindingsDto> findingsDtoMap = statsByFlowNodeId.entrySet().stream().map(flowNodeStatsEntry -> {
            String flowNodeId = (String)flowNodeStatsEntry.getKey();
            ExtendedStatsAggregate stats = (ExtendedStatsAggregate)flowNodeStatsEntry.getValue();
            FindingsDto finding = new FindingsDto();
            finding.setTotalCount(stats.count());
            if (stats.stdDeviation() != 0.0 && allFlowNodeFilterAggs.get(this.getFilteredFlowNodeAggregationName(flowNodeId)) != null) {
                double percent;
                long count;
                Aggregate flowNodeFilterAgg = (Aggregate)allFlowNodeFilterAggs.get(this.getFilteredFlowNodeAggregationName(flowNodeId));
                Aggregate lowerOutlierFilterAgg = (Aggregate)flowNodeFilterAgg.filter().aggregations().get("lowerDurationAgg");
                Aggregate higherOutlierFilterAgg = (Aggregate)flowNodeFilterAgg.filter().aggregations().get("higherDurationAgg");
                double avg = stats.avg();
                double stdDeviationBoundLower = stats.stdDeviationBounds().lower();
                double stdDeviationBoundHigher = stats.stdDeviationBounds().upper();
                if (stdDeviationBoundLower > stats.min() && lowerOutlierFilterAgg.filter().docCount() > 0L) {
                    count = lowerOutlierFilterAgg.filter().docCount();
                    percent = (double)count / (double)flowNodeFilterAgg.filter().docCount();
                    finding.setLowerOutlier((long)stdDeviationBoundLower, percent, avg / stdDeviationBoundLower, count);
                    totalLowerOutlierCount.addAndGet(count);
                }
                if (stdDeviationBoundHigher < stats.max() && higherOutlierFilterAgg.filter().docCount() > 0L) {
                    count = higherOutlierFilterAgg.filter().docCount();
                    percent = (double)count / (double)flowNodeFilterAgg.filter().docCount();
                    finding.setHigherOutlier((long)stdDeviationBoundHigher, percent, stdDeviationBoundHigher / avg, count);
                    totalHigherOutlierCount.addAndGet(count);
                }
            }
            return new AbstractMap.SimpleEntry<String, FindingsDto>(flowNodeId, finding);
        }).filter(entry -> ((FindingsDto)entry.getValue()).getOutlierCount() > 0L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        long totalOutlierCount = totalLowerOutlierCount.get() + totalHigherOutlierCount.get();
        findingsDtoMap.values().forEach(finding -> {
            finding.getLowerOutlier().ifPresent(lowerOutlier -> finding.setLowerOutlierHeat(this.getRatio(totalLowerOutlierCount.get(), lowerOutlier.getCount())));
            finding.getHigherOutlier().ifPresent(higherOutlier -> finding.setHigherOutlierHeat(this.getRatio(totalHigherOutlierCount.get(), higherOutlier.getCount())));
            finding.setHeat(this.getRatio(totalOutlierCount, finding.getOutlierCount()));
        });
        return findingsDtoMap;
    }

    private long getInterval(BoolQuery query, String flowNodeId, String processDefinitionKey) {
        SearchResponse search;
        StatsAggregation statsAgg = StatsAggregation.of(s -> (ObjectBuilder)s.field("flowNodeInstances.totalDurationInMs"));
        Aggregation termsAgg = this.buildNestedFlowNodeFilterAggregation(flowNodeId, "stats", Aggregation.of(a -> a.stats(statsAgg)));
        SearchRequest searchRequest = OptimizeSearchRequestOS.of(s -> s.optimizeIndex(this.osClient, new String[]{InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)}).query(q -> q.bool(query)).source(o -> o.fetch(Boolean.valueOf(false))).aggregations("flowNodeInstances", termsAgg).size(Integer.valueOf(0)));
        try {
            search = this.osClient.searchUnsafe(searchRequest, Object.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (OpenSearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to determine interval because instance index {} does not exist. Returning 0.", (Object)LogUtil.sanitizeLogMessage((String)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)processDefinitionKey)));
                return 0L;
            }
            throw e;
        }
        StatsAggregate stats = ((Aggregate)((Aggregate)((Aggregate)search.aggregations().get("flowNodeInstances")).nested().aggregations().get("filteredFlowNodes")).filter().aggregations().get("stats")).stats();
        double min = stats.min();
        double max = stats.max();
        if (max == min || stats.count() == 0L) {
            return 1L;
        }
        return (long)Math.ceil((max - min) / 80.0);
    }

    private Aggregation buildNestedFlowNodeFilterAggregation(String flowNodeId, String agrKey, Aggregation subAggregation) {
        TermQuery.Builder terms = new TermQuery.Builder();
        terms.field("flowNodeInstances.flowNodeId");
        terms.value(FieldValue.of((String)flowNodeId));
        Aggregation filteredFlowNodes = Aggregation.of(a -> a.filter(f -> f.term(terms.build())).aggregations(agrKey, subAggregation));
        return Aggregation.of(a -> a.nested(n -> n.path("flowNodeInstances")).aggregations("filteredFlowNodes", filteredFlowNodes));
    }

    private ReverseNestedAggregate extractNestedProcessInstanceAgg(SearchResponse<?> outlierTopVariableTermsResponse) {
        return ((Aggregate)((Aggregate)((Aggregate)outlierTopVariableTermsResponse.aggregations().get("flowNodeInstances")).nested().aggregations().get("filteredFlowNodes")).filter().aggregations().get("processInstance")).reverseNested();
    }

    private <T extends ProcessDefinitionParametersDto> BoolQuery.Builder buildBaseQuery(OutlierAnalysisServiceParameters<T> outlierParams) {
        T processDefinitionParams = outlierParams.getProcessDefinitionParametersDto();
        BoolQuery.Builder definitionQuery = DefinitionQueryUtilOS.createDefinitionQuery(((ProcessDefinitionParametersDto)processDefinitionParams).getProcessDefinitionKey(), ((ProcessDefinitionParametersDto)processDefinitionParams).getProcessDefinitionVersions(), ((ProcessDefinitionParametersDto)processDefinitionParams).getTenantIds(), (AbstractInstanceIndex)new ProcessInstanceIndexOS(((ProcessDefinitionParametersDto)processDefinitionParams).getProcessDefinitionKey()), this.processDefinitionReader::getLatestVersionToKey);
        definitionQuery.filter(this.getQueryFilters((ProcessDefinitionParametersDto)processDefinitionParams, outlierParams.getZoneId()));
        return definitionQuery;
    }
}

