/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.dto.optimize.query.definition.DefinitionWithTenantIdsDto;
import io.camunda.optimize.dto.optimize.query.definition.TenantIdWithDefinitionsDto;
import io.camunda.optimize.dto.optimize.rest.DefinitionVersionResponseDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.os.OpenSearchCompositeAggregationScroller;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.RequestDSL;
import io.camunda.optimize.service.db.os.client.sync.OpenSearchDocumentOperations;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.os.schema.index.DecisionDefinitionIndexOS;
import io.camunda.optimize.service.db.os.schema.index.ProcessDefinitionIndexOS;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.reader.DefinitionReader;
import io.camunda.optimize.service.db.schema.DefaultIndexMappingCreator;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DefinitionVersionHandlingUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.ScriptSort;
import org.opensearch.client.opensearch._types.ScriptSortType;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBuilders;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregate;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregation;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.CompositeBucket;
import org.opensearch.client.opensearch._types.aggregations.CompositeTermsAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.FiltersAggregation;
import org.opensearch.client.opensearch._types.aggregations.FiltersBucket;
import org.opensearch.client.opensearch._types.aggregations.MinAggregation;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketAggregateBase;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.aggregations.TopHitsAggregate;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.core.search.SourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DefinitionReaderOS
implements DefinitionReader {
    private static final Logger LOG = LoggerFactory.getLogger(DefinitionReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public DefinitionReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public Optional<DefinitionWithTenantIdsDto> getDefinitionWithAvailableTenants(DefinitionType type, String key) {
        return this.getDefinitionWithAvailableTenants(type, key, null, null);
    }

    @Override
    public Optional<DefinitionWithTenantIdsDto> getDefinitionWithAvailableTenants(DefinitionType type, String key, List<String> versions, Supplier<String> latestVersionSupplier) {
        if (type == null || key == null) {
            return Optional.empty();
        }
        BoolQuery.Builder query = new BoolQuery.Builder().must(QueryDSL.term((String)"key", (String)key), new Query[0]).must(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]);
        this.addVersionFilterToQuery(versions, latestVersionSupplier, query);
        return this.getDefinitionWithTenantIdsDtos(query.build().toQuery(), type).stream().findFirst();
    }

    @Override
    public List<DefinitionWithTenantIdsDto> getFullyImportedDefinitionsWithTenantIds(DefinitionType type, Set<String> keys, Set<String> tenantIds) {
        BoolQuery.Builder filterQuery = new BoolQuery.Builder();
        filterQuery.filter(new BoolQuery.Builder().minimumShouldMatch("1").must(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]).should(QueryDSL.exists((String)"bpmn20Xml"), new Query[0]).should(QueryDSL.exists((String)"dmn10Xml"), new Query[0]).build().toQuery(), new Query[0]);
        if (!CollectionUtils.isEmpty(keys)) {
            filterQuery.filter(QueryDSL.terms((String)"key", keys, FieldValue::of), new Query[0]);
        }
        this.addTenantIdFilter(tenantIds, filterQuery);
        return this.getDefinitionWithTenantIdsDtos(filterQuery.build().toQuery(), type);
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> List<T> getFullyImportedDefinitions(DefinitionType type, boolean withXml) {
        return this.getDefinitions(type, true, withXml, false);
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> Optional<T> getFirstFullyImportedDefinitionFromTenantsIfAvailable(DefinitionType type, String definitionKey, List<String> definitionVersions, List<String> tenantIds) {
        String tenantId;
        if (definitionKey == null || definitionVersions == null || definitionVersions.isEmpty()) {
            return Optional.empty();
        }
        String mostRecentValidVersion = DefinitionVersionHandlingUtil.convertToLatestParticularVersion(definitionVersions, () -> this.getLatestVersionToKey(type, definitionKey));
        Optional definition = Optional.empty();
        Iterator<String> iterator = tenantIds.iterator();
        while (iterator.hasNext() && !(definition = this.getFullyImportedDefinition(type, definitionKey, mostRecentValidVersion, tenantId = iterator.next())).isPresent()) {
        }
        return definition;
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> List<T> getLatestFullyImportedDefinitionsFromTenantsIfAvailable(DefinitionType type, String definitionKey) {
        if (definitionKey == null) {
            return Collections.emptyList();
        }
        return this.getLatestFullyImportedDefinitionPerTenant(type, definitionKey);
    }

    @Override
    public Set<String> getDefinitionEngines(DefinitionType type, String definitionKey) {
        TermsAggregation enginesAggregation = AggregationDSL.termAggregation((String)"dataSource.name", (int)1000);
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index(DefinitionType.PROCESS.equals((Object)type) ? "process-definition" : "decision-definition", new String[0]).query(new BoolQuery.Builder().must(QueryDSL.term((String)this.resolveDefinitionKeyFieldFromType(type), (String)definitionKey), new Query[0]).must(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]).build().toQuery()).size(Integer.valueOf(0)).aggregations(Collections.singletonMap("engines", enginesAggregation._toAggregation()));
        String errorMessage = String.format("Was not able to fetch engines for definition key [%s] and type [%s]", definitionKey, type);
        SearchResponse searchResponse = this.osClient.search(searchRequest, String.class, errorMessage);
        return Stream.of(((Aggregate)searchResponse.aggregations().get("engines")).sterms()).map(MultiBucketAggregateBase::buckets).flatMap(bucket -> bucket.array().stream()).map(StringTermsBucket::key).collect(Collectors.toSet());
    }

    @Override
    public Map<String, TenantIdWithDefinitionsDto> getDefinitionsGroupedByTenant() {
        TermsAggregation nameAggregation = AggregationDSL.termAggregation((String)"name", (int)1);
        TermsAggregation enginesAggregation = AggregationDSL.termAggregation((String)"dataSource.name", (int)1000);
        ArrayList<Map<String, CompositeAggregationSource>> keyAndTypeAndTenantSources = new ArrayList<Map<String, CompositeAggregationSource>>();
        keyAndTypeAndTenantSources.add(Collections.singletonMap("tenants", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)((CompositeTermsAggregationSource.Builder)((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().missingBucket(Boolean.valueOf(true))).field("tenantId")).order(SortOrder.Asc)).build()).build()));
        keyAndTypeAndTenantSources.add(Collections.singletonMap("definitionKey", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().field("key")).build()).build()));
        keyAndTypeAndTenantSources.add(Collections.singletonMap("definitionType", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().field("_index")).build()).build()));
        CompositeAggregation keyAndTypeAndTenantAggregation = new CompositeAggregation.Builder().sources(keyAndTypeAndTenantSources).size(this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit()).build();
        Aggregation complexAggregation = Aggregation.of(a -> a.composite(keyAndTypeAndTenantAggregation).aggregations("definitionName", nameAggregation._toAggregation()).aggregations("engines", enginesAggregation._toAggregation()));
        HashMap<String, List> keyAndTypeAggBucketsByTenantId = new HashMap<String, List>();
        OpenSearchCompositeAggregationScroller.create().setClient(this.osClient).query(QueryDSL.term((String)"deleted", (boolean)false)).index(List.of(ALL_DEFINITION_INDEXES)).aggregations(Collections.singletonMap("definitionKeyAndTypeAndTenant", complexAggregation)).size(0).setPathToAggregation("definitionKeyAndTypeAndTenant").setCompositeBucketConsumer(bucket -> {
            String tenantId = (String)((JsonData)bucket.key().get("tenants")).to(String.class);
            if (!keyAndTypeAggBucketsByTenantId.containsKey(tenantId)) {
                keyAndTypeAggBucketsByTenantId.put(tenantId, new ArrayList());
            }
            ((List)keyAndTypeAggBucketsByTenantId.get(tenantId)).add(bucket);
        }).consumeAllPages();
        HashMap<String, TenantIdWithDefinitionsDto> resultMap = new HashMap<String, TenantIdWithDefinitionsDto>();
        keyAndTypeAggBucketsByTenantId.forEach((key, value) -> {
            String tenantId = "null".equalsIgnoreCase((String)key) ? null : key;
            List<SimpleDefinitionDto> simpleDefinitionDtos = value.stream().map(parsedBucket -> {
                String indexAliasName = (String)((JsonData)parsedBucket.key().get("definitionType")).to(String.class);
                String definitionKey = (String)((JsonData)parsedBucket.key().get("definitionKey")).to(String.class);
                String definitionName = ((Aggregate)parsedBucket.aggregations().get("definitionName")).sterms().buckets().array().stream().findFirst().map(StringTermsBucket::key).orElse(null);
                Set engines = ((Aggregate)parsedBucket.aggregations().get("engines")).sterms().buckets().array().stream().map(StringTermsBucket::key).collect(Collectors.toSet());
                return new SimpleDefinitionDto(definitionKey, definitionName, this.resolveDefinitionTypeFromIndexAlias(indexAliasName), engines);
            }).toList();
            resultMap.put(tenantId, new TenantIdWithDefinitionsDto(tenantId, simpleDefinitionDtos));
        });
        return resultMap;
    }

    @Override
    public String getLatestVersionToKey(DefinitionType type, String key) {
        LOG.debug("Fetching latest [{}] definition for key [{}]", (Object)type, (Object)key);
        Script script = OpenSearchWriterUtil.createDefaultScript("Integer.parseInt(doc['" + this.resolveVersionFieldFromType(type) + "'].value)");
        SearchRequest.Builder searchBuilder = new SearchRequest.Builder().index(List.of(this.resolveIndexNameForType(type))).size(Integer.valueOf(1)).query(new BoolQuery.Builder().must(QueryDSL.term((String)this.resolveDefinitionKeyFieldFromType(type), (String)key), new Query[0]).must(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]).build().toQuery()).sort((SortOptions)new SortOptions.Builder().script(new ScriptSort.Builder().script(script).order(SortOrder.Desc).type(ScriptSortType.Number).build()).build(), new SortOptions[0]);
        String errorMessage = String.format("Was not able to fetch latest [%s] definition for key [%s]", type, key);
        SearchResponse searchResponse = this.osClient.search(searchBuilder, this.resolveDefinitionClassFromType(type), errorMessage);
        if (searchResponse.hits().hits().size() == 1) {
            return ((DefinitionOptimizeResponseDto)((Hit)searchResponse.hits().hits().get(0)).source()).getVersion();
        }
        throw new NotFoundException("Unable to retrieve latest version for " + String.valueOf(type) + " definition key: " + key);
    }

    @Override
    public List<DefinitionVersionResponseDto> getDefinitionVersions(DefinitionType type, String key, Set<String> tenantIds) {
        BoolQuery.Builder filterQuery = new BoolQuery.Builder().filter(QueryDSL.term((String)"key", (String)key), new Query[0]).filter(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]);
        this.addTenantIdFilter(tenantIds, filterQuery);
        TermsAggregation versionTagAggregation = AggregationDSL.termAggregation((String)"versionTag", (int)1);
        TermsAggregation versionAggregation = AggregationDSL.termAggregation((String)"version", (int)this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit());
        SearchRequest.Builder searchBuilder = new SearchRequest.Builder().index(List.of(this.resolveIndexNameForType(type))).query(filterQuery.build().toQuery()).aggregations(Collections.singletonMap("versions", AggregationDSL.withSubaggregations((TermsAggregation)versionAggregation, Collections.singletonMap("versionTags", versionTagAggregation._toAggregation())))).size(Integer.valueOf(0));
        String errorMessage = String.format("Was not able to fetch [%s] definition versions with key [%s], tenantIds [%s]", type, key, tenantIds);
        SearchResponse searchResponse = this.osClient.search(searchBuilder, DefinitionVersionResponseDto.class, errorMessage);
        return Stream.of(((Aggregate)searchResponse.aggregations().get("versions")).sterms()).map(MultiBucketAggregateBase::buckets).flatMap(stringTermsBucketBuckets -> stringTermsBucketBuckets.array().stream()).map(versionBucket -> {
            String version = versionBucket.key();
            Aggregate versionTags = (Aggregate)versionBucket.aggregations().get("versionTags");
            String versionTag = Optional.ofNullable(versionTags).map(Aggregate::sterms).map(MultiBucketAggregateBase::buckets).map(Buckets::array).flatMap(a -> a.stream().findFirst()).map(StringTermsBucket::key).orElse(null);
            return new DefinitionVersionResponseDto(version, versionTag);
        }).sorted(Comparator.comparing(DefinitionVersionResponseDto::getVersion).reversed()).collect(Collectors.toList());
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> List<T> getDefinitions(DefinitionType type, boolean fullyImported, boolean withXml, boolean includeDeleted) {
        return this.getDefinitions(type, Collections.emptySet(), fullyImported, withXml, includeDeleted);
    }

    @Override
    public <T extends DefinitionOptimizeResponseDto> List<T> getDefinitions(DefinitionType type, Set<String> definitionKeys, boolean fullyImported, boolean withXml, boolean includeDeleted) {
        String xmlField = this.resolveXmlFieldFromType(type);
        BoolQuery.Builder rootQuery = new BoolQuery.Builder().must(fullyImported ? QueryDSL.exists((String)xmlField) : QueryDSL.matchAll(), new Query[0]);
        BoolQuery.Builder filteredQuery = rootQuery.must(QueryDSL.matchAll(), new Query[0]);
        if (!includeDeleted) {
            filteredQuery.must(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]);
        }
        if (!definitionKeys.isEmpty()) {
            filteredQuery.must(QueryDSL.terms((String)this.resolveDefinitionKeyFieldFromType(type), definitionKeys, FieldValue::of), new Query[0]);
        }
        return this.getDefinitions(type, filteredQuery.build(), withXml);
    }

    public <T extends DefinitionOptimizeResponseDto> List<T> getDefinitions(DefinitionType type, BoolQuery filterQuery, boolean withXml) {
        OpenSearchDocumentOperations.AggregatedResult scrollResp;
        String xmlField = this.resolveXmlFieldFromType(type);
        List<Object> fieldsToExclude = withXml ? Collections.emptyList() : List.of(xmlField);
        SourceConfig searchSourceBuilder = (SourceConfig)new SourceConfig.Builder().filter(new SourceFilter.Builder().excludes(fieldsToExclude).build()).build();
        SearchRequest.Builder searchBuilder = new SearchRequest.Builder().index(List.of(this.resolveIndexNameForType(type))).query(filterQuery.toQuery()).source(searchSourceBuilder).size(Integer.valueOf(1000)).scroll(RequestDSL.time((String)String.valueOf(this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds())));
        Class typeClass = this.resolveDefinitionClassFromType(type);
        try {
            scrollResp = this.osClient.retrieveAllScrollResults(searchBuilder, typeClass);
        }
        catch (IOException e) {
            String errorMsg = String.format("Was not able to retrieve definitions of type %s", type);
            LOG.error(errorMsg, (Throwable)e);
            throw new OptimizeRuntimeException(errorMsg, (Throwable)e);
        }
        return OpensearchReaderUtil.extractAggregatedResponseValues(scrollResp, this.createMappingFunctionForDefinitionType(typeClass));
    }

    private void addVersionFilterToQuery(List<String> versions, Supplier<String> latestVersionSupplier, BoolQuery.Builder filterQuery) {
        if (!CollectionUtils.isEmpty(versions) && !DefinitionVersionHandlingUtil.isDefinitionVersionSetToAll(versions)) {
            filterQuery.filter(QueryDSL.terms((String)"version", (Collection)versions.stream().map(version -> DefinitionVersionHandlingUtil.convertToLatestParticularVersion(version, latestVersionSupplier)).collect(Collectors.toSet()), FieldValue::of), new Query[0]);
        }
    }

    private <T extends DefinitionOptimizeResponseDto> Optional<T> getFullyImportedDefinition(DefinitionType type, String definitionKey, String definitionVersion, String tenantId) {
        if (definitionKey == null || definitionVersion == null) {
            return Optional.empty();
        }
        String validVersion = DefinitionVersionHandlingUtil.convertToLatestParticularVersion(definitionVersion, () -> this.getLatestVersionToKey(type, definitionKey));
        BoolQuery.Builder query = new BoolQuery.Builder().must(QueryDSL.term((String)this.resolveDefinitionKeyFieldFromType(type), (String)definitionKey), new Query[0]).must(QueryDSL.term((String)this.resolveVersionFieldFromType(type), (String)validVersion), new Query[0]).must(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]).must(QueryDSL.exists((String)this.resolveXmlFieldFromType(type)), new Query[0]);
        if (tenantId != null) {
            query.must(QueryDSL.term((String)"tenantId", (String)tenantId), new Query[0]);
        } else {
            query.mustNot(QueryDSL.exists((String)"tenantId"), new Query[0]);
        }
        SearchRequest.Builder searchBuilder = new SearchRequest.Builder().index(List.of(this.resolveIndexNameForType(type))).query(query.build().toQuery()).size(Integer.valueOf(1));
        Class typeClass = this.resolveDefinitionClassFromType(type);
        String errorMessage = String.format("Was not able to fetch [%s] definition with key [%s], version [%s] and tenantId [%s]", type, definitionKey, validVersion, tenantId);
        SearchResponse searchResponse = this.osClient.search(searchBuilder, typeClass, errorMessage);
        if (searchResponse.hits().total().value() == 0L) {
            LOG.debug("Could not find [{}] definition with key [{}], version [{}] and tenantId [{}]", new Object[]{type, definitionKey, validVersion, tenantId});
            return Optional.empty();
        }
        return Optional.ofNullable((DefinitionOptimizeResponseDto)OpensearchReaderUtil.extractResponseValues(searchResponse, this.createMappingFunctionForDefinitionType(typeClass)).get(0));
    }

    private <T extends DefinitionOptimizeResponseDto> List<T> getLatestFullyImportedDefinitionPerTenant(DefinitionType type, String key) {
        LOG.debug("Fetching latest fully imported [{}] definitions for key [{}] on each tenant", (Object)type, (Object)key);
        FiltersAggregation keyFilterAgg = AggregationDSL.filtersAggregation(Collections.singletonMap("definitionKeyFilter", new BoolQuery.Builder().must(QueryDSL.term((String)this.resolveDefinitionKeyFieldFromType(type), (String)key), new Query[0]).must(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]).must(QueryDSL.exists((String)this.resolveXmlFieldFromType(type)), new Query[0]).build().toQuery()));
        TermsAggregation tenantsAggregation = new TermsAggregation.Builder().field("tenantId").missing(FieldValue.of((String)"null")).size(Integer.valueOf(1000)).build();
        Script numericVersionScript = OpenSearchWriterUtil.createDefaultScript("Integer.parseInt(doc['" + this.resolveVersionFieldFromType(type) + "'].value)");
        TermsAggregation versionAggregation = new TermsAggregation.Builder().field("version").size(Integer.valueOf(1)).order(Collections.singletonMap("versionForSorting", SortOrder.Desc), new Map[0]).build();
        HashMap<String, Aggregation> subAggregations = new HashMap<String, Aggregation>();
        subAggregations.put("versionForSorting", ((MinAggregation.Builder)AggregationBuilders.min().script(numericVersionScript)).build()._toAggregation());
        subAggregations.put("topHits", AggregationDSL.topHitsAggregation((int)1, (SortOptions[])new SortOptions[0])._toAggregation());
        Aggregation definitionAgg = AggregationDSL.withSubaggregations((FiltersAggregation)keyFilterAgg, Collections.singletonMap("tenants", AggregationDSL.withSubaggregations((TermsAggregation)tenantsAggregation, Collections.singletonMap("versions", AggregationDSL.withSubaggregations((TermsAggregation)versionAggregation, subAggregations)))));
        SearchRequest.Builder searchBuilder = new SearchRequest.Builder().index(List.of(this.resolveIndexNameForType(type))).size(Integer.valueOf(0)).aggregations("definitionKeyFilter", definitionAgg);
        String errorMessage = String.format("Was not able to fetch latest [%s] definitions for key [%s]", type, key);
        SearchResponse searchResponse = this.osClient.search(searchBuilder, this.resolveDefinitionClassFromType(type), errorMessage);
        List<T> result = this.retrieveResultsFromLatestDefinitionPerTenant(type, searchResponse);
        if (result.isEmpty()) {
            LOG.debug("Could not find latest [{}] definitions with key [{}]", (Object)type, (Object)key);
        }
        return result;
    }

    private List<DefinitionWithTenantIdsDto> getDefinitionWithTenantIdsDtos(Query filterQuery, DefinitionType type) {
        TermsAggregation tenantsAggregation = new TermsAggregation.Builder().field("tenantId").size(Integer.valueOf(1000)).missing(FieldValue.of((String)"null")).order(Collections.singletonMap("_key", SortOrder.Asc), new Map[0]).build();
        TermsAggregation nameAggregation = new TermsAggregation.Builder().field("name").size(Integer.valueOf(1)).order(Collections.singletonMap("versionForSorting", SortOrder.Desc), new Map[0]).build();
        Aggregation nameAggregationSub = AggregationDSL.withSubaggregations((TermsAggregation)nameAggregation, Collections.singletonMap("versionForSorting", ((MinAggregation.Builder)AggregationBuilders.min().script(OpenSearchWriterUtil.createDefaultScript("Integer.parseInt(doc['version'].value)"))).build()._toAggregation()));
        TermsAggregation enginesAggregation = AggregationDSL.termAggregation((String)"dataSource.name", (int)1000);
        ArrayList<Map<String, CompositeAggregationSource>> keyAndTypeSources = new ArrayList<Map<String, CompositeAggregationSource>>();
        keyAndTypeSources.add(Collections.singletonMap("definitionKey", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().field("key")).build()).build()));
        keyAndTypeSources.add(Collections.singletonMap("definitionType", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().field("_index")).build()).build()));
        CompositeAggregation.Builder keyAndTypeCompositeAggregation = new CompositeAggregation.Builder().sources(keyAndTypeSources).size(this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit());
        Aggregation.Builder complexKeyAndTypeAggregationBuilder = new Aggregation.Builder().aggregations("tenants", tenantsAggregation._toAggregation()).aggregations("definitionName", nameAggregationSub).aggregations("engines", enginesAggregation._toAggregation());
        List<CompositeBucket> keyAndTypeAggBuckets = this.performSearchAndCollectAllKeyAndTypeBuckets(filterQuery, this.resolveIndexNameForType(type), complexKeyAndTypeAggregationBuilder, keyAndTypeCompositeAggregation, this.resolveDefinitionClassFromType(type));
        return keyAndTypeAggBuckets.stream().map(keyAndTypeAgg -> {
            String indexAliasName = (String)((JsonData)keyAndTypeAgg.key().get("definitionType")).to(String.class);
            String definitionKey = (String)((JsonData)keyAndTypeAgg.key().get("definitionKey")).to(String.class);
            StringTermsAggregate tenantResult = ((Aggregate)keyAndTypeAgg.aggregations().get("tenants")).sterms();
            StringTermsAggregate nameResult = ((Aggregate)keyAndTypeAgg.aggregations().get("definitionName")).sterms();
            StringTermsAggregate enginesResult = ((Aggregate)keyAndTypeAgg.aggregations().get("engines")).sterms();
            return new DefinitionWithTenantIdsDto(definitionKey, nameResult.buckets().array().stream().findFirst().map(StringTermsBucket::key).orElse(null), this.resolveDefinitionTypeFromIndexAlias(indexAliasName), tenantResult.buckets().array().stream().map(StringTermsBucket::key).map(tenantId -> "null".equalsIgnoreCase((String)tenantId) ? null : tenantId).collect(Collectors.toList()), enginesResult.buckets().array().stream().map(StringTermsBucket::key).collect(Collectors.toSet()));
        }).toList();
    }

    private void addTenantIdFilter(Set<String> tenantIds, BoolQuery.Builder query) {
        if (!CollectionUtils.isEmpty(tenantIds)) {
            Set nonNullValues;
            BoolQuery.Builder tenantFilterQuery = new BoolQuery.Builder().minimumShouldMatch("1");
            if (tenantIds.contains(null)) {
                tenantFilterQuery.should(new BoolQuery.Builder().mustNot(QueryDSL.exists((String)"tenantId"), new Query[0]).build().toQuery(), new Query[0]);
            }
            if (!(nonNullValues = tenantIds.stream().filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty()) {
                tenantFilterQuery.should(QueryDSL.terms((String)"tenantId", nonNullValues, FieldValue::of), new Query[0]);
            }
            query.filter(tenantFilterQuery.build().toQuery(), new Query[0]);
        }
    }

    private <T> List<CompositeBucket> performSearchAndCollectAllKeyAndTypeBuckets(Query filterQuery, String[] definitionIndexNames, Aggregation.Builder keyTypeAggregationBuilder, CompositeAggregation.Builder keyAndTypeCompositeAggregation, Class<T> typeResponse) {
        CompositeAggregation compositeAggregation = keyAndTypeCompositeAggregation.build();
        Aggregation keyTypeAggregation = keyTypeAggregationBuilder.composite(compositeAggregation).build();
        SearchRequest.Builder searchReqBuilder = new SearchRequest.Builder().index(List.of(definitionIndexNames)).aggregations("definitionKeyAndType", keyTypeAggregation).query(filterQuery).size(Integer.valueOf(0));
        ArrayList<CompositeBucket> keyAndTypeAggBuckets = new ArrayList<CompositeBucket>();
        String errorMessage = String.format("Was not able to fetch definitions with composite aggregation for type [%s]", typeResponse);
        SearchResponse searchResponse = this.osClient.search(searchReqBuilder, typeResponse, errorMessage);
        CompositeAggregate keyAndTypeAggregationResult = ((Aggregate)searchResponse.aggregations().get("definitionKeyAndType")).composite();
        while (!keyAndTypeAggregationResult.buckets().array().isEmpty()) {
            keyAndTypeAggBuckets.addAll(keyAndTypeAggregationResult.buckets().array());
            Map<String, String> keysToTypes = keyAndTypeAggregationResult.afterKey().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((JsonData)e.getValue()).to(String.class)));
            Aggregation.Builder keyTypeAggregationTempBuilder = new Aggregation.Builder().aggregations(keyTypeAggregation.aggregations());
            Aggregation compositeWithAfterAggregation = keyTypeAggregationTempBuilder.composite(new CompositeAggregation.Builder().sources(compositeAggregation.sources()).size(compositeAggregation.size()).after(keysToTypes).build()).build();
            searchReqBuilder = new SearchRequest.Builder().index(List.of(definitionIndexNames)).query(filterQuery).aggregations("definitionKeyAndType", compositeWithAfterAggregation).size(Integer.valueOf(0));
            searchResponse = this.osClient.search(searchReqBuilder, typeResponse, errorMessage);
            keyAndTypeAggregationResult = ((Aggregate)searchResponse.aggregations().get("definitionKeyAndType")).composite();
        }
        return keyAndTypeAggBuckets;
    }

    private <T extends DefinitionOptimizeResponseDto> List<T> retrieveResultsFromLatestDefinitionPerTenant(DefinitionType type, SearchResponse<T> searchResponse) {
        Class typeClass = this.resolveDefinitionClassFromType(type);
        ArrayList results = new ArrayList();
        FiltersBucket filteredDefsAgg = (FiltersBucket)((Aggregate)searchResponse.aggregations().get("definitionKeyFilter")).filters().buckets().keyed().get("definitionKeyFilter");
        List tenantsAgg = ((Aggregate)filteredDefsAgg.aggregations().get("tenants")).sterms().buckets().array();
        for (StringTermsBucket tenantBucket : tenantsAgg) {
            List versionsAgg = ((Aggregate)tenantBucket.aggregations().get("versions")).sterms().buckets().array();
            for (StringTermsBucket b : versionsAgg) {
                TopHitsAggregate topHits = ((Aggregate)b.aggregations().get("topHits")).topHits();
                results.addAll(OpensearchReaderUtil.mapHits((HitsMetadata<JsonData>)topHits.hits(), 1, typeClass, this.createMappingFunctionForDefinitionType(typeClass)));
            }
        }
        return results;
    }

    private DefinitionType resolveDefinitionTypeFromIndexAlias(String indexName) {
        if (indexName.equals(this.getOptimizeIndexNameForIndex((DefaultIndexMappingCreator)new ProcessDefinitionIndexOS()))) {
            return DefinitionType.PROCESS;
        }
        if (indexName.equals(this.getOptimizeIndexNameForIndex((DefaultIndexMappingCreator)new DecisionDefinitionIndexOS()))) {
            return DefinitionType.DECISION;
        }
        throw new OptimizeRuntimeException("Unexpected definition index name: " + indexName);
    }

    private String getOptimizeIndexNameForIndex(DefaultIndexMappingCreator index) {
        return this.osClient.getIndexNameService().getOptimizeIndexNameWithVersion((IndexMappingCreator)index);
    }

    private <T extends DefinitionOptimizeResponseDto> Function<Hit<T>, T> createMappingFunctionForDefinitionType(Class<T> type) {
        return hit -> {
            try {
                DefinitionOptimizeResponseDto definitionDto = (DefinitionOptimizeResponseDto)hit.source();
                if (ProcessDefinitionOptimizeDto.class.equals((Object)type)) {
                    ProcessDefinitionOptimizeDto processDefinition = (ProcessDefinitionOptimizeDto)definitionDto;
                    processDefinition.setType(DefinitionType.PROCESS);
                } else {
                    definitionDto.setType(DefinitionType.DECISION);
                }
                return definitionDto;
            }
            catch (Exception e) {
                String reason = "While mapping search results to class {} it was not possible to deserialize a hit from OpenSearch! Hit response from OpenSearch: " + hit.id();
                LOG.error(reason, (Object)type.getSimpleName(), (Object)e);
                throw new OptimizeRuntimeException(reason);
            }
        };
    }
}

