/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os;

import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClientFactory;
import io.camunda.optimize.service.db.os.schema.OpenSearchSchemaManager;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.search.connect.plugin.PluginRepository;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={OpenSearchCondition.class})
public class OptimizeOpenSearchClientConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeOpenSearchClientConfiguration.class);
    private final ConfigurationService configurationService;
    private final OptimizeIndexNameService optimizeIndexNameService;
    private final OpenSearchSchemaManager openSearchSchemaManager;
    private final PluginRepository pluginRepository = new PluginRepository();

    public OptimizeOpenSearchClientConfiguration(ConfigurationService configurationService, OptimizeIndexNameService optimizeIndexNameService, OpenSearchSchemaManager openSearchSchemaManager) {
        this.configurationService = configurationService;
        this.optimizeIndexNameService = optimizeIndexNameService;
        this.openSearchSchemaManager = openSearchSchemaManager;
    }

    @Bean(destroyMethod="close")
    public OptimizeOpenSearchClient optimizeOpenSearchClient(BackoffCalculator backoffCalculator) {
        return this.createOptimizeOpenSearchClient(backoffCalculator);
    }

    public OptimizeOpenSearchClient createOptimizeOpenSearchClient(BackoffCalculator backoffCalculator) {
        try {
            return OptimizeOpenSearchClientFactory.create(this.configurationService, this.optimizeIndexNameService, this.openSearchSchemaManager, backoffCalculator, this.pluginRepository);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }
}

