/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionUpdateDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeDeleteRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateRequestBuilderES;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.db.writer.DatabaseWriterUtil;
import io.camunda.optimize.service.db.writer.ReportWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ReportWriterES
implements ReportWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ReportWriterES.class);
    private final ObjectMapper objectMapper;
    private final OptimizeElasticsearchClient esClient;
    private final TaskRepositoryES taskRepositoryES;

    public ReportWriterES(ObjectMapper objectMapper, OptimizeElasticsearchClient esClient, TaskRepositoryES taskRepositoryES) {
        this.objectMapper = objectMapper;
        this.esClient = esClient;
        this.taskRepositoryES = taskRepositoryES;
    }

    @Override
    public IdResponseDto createNewCombinedReport(String userId, CombinedReportDataDto reportData, String reportName, String description, String collectionId) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (reportData == null) {
            throw new OptimizeRuntimeException("reportData is null");
        }
        if (reportName == null) {
            throw new OptimizeRuntimeException("reportName is null");
        }
        LOG.debug("Writing new combined report to Elasticsearch");
        String id = IdGenerator.getNextId();
        CombinedReportDefinitionRequestDto reportDefinitionDto = new CombinedReportDefinitionRequestDto();
        reportDefinitionDto.setId(id);
        OffsetDateTime now = LocalDateUtil.getCurrentDateTime();
        reportDefinitionDto.setCreated(now);
        reportDefinitionDto.setLastModified(now);
        reportDefinitionDto.setOwner(userId);
        reportDefinitionDto.setLastModifier(userId);
        reportDefinitionDto.setName(reportName);
        reportDefinitionDto.setDescription(description);
        reportDefinitionDto.setData((ReportDataDto)reportData);
        reportDefinitionDto.setCollectionId(collectionId);
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "combined-report").id(id).document((Object)reportDefinitionDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created)) {
                String message = "Could not write report to Elasticsearch. ";
                LOG.error("Could not write report to Elasticsearch. ");
                throw new OptimizeRuntimeException("Could not write report to Elasticsearch. ");
            }
            LOG.debug("Report with id [{}] has successfully been created.", (Object)id);
            return new IdResponseDto(id);
        }
        catch (IOException e) {
            String errorMessage = "Was not able to insert combined report.!";
            LOG.error("Was not able to insert combined report.!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to insert combined report.!", (Throwable)e);
        }
    }

    @Override
    public IdResponseDto createNewSingleProcessReport(String userId, ProcessReportDataDto reportData, String reportName, String description, String collectionId) {
        LOG.debug("Writing new single report to Elasticsearch");
        if (reportData == null) {
            throw new OptimizeRuntimeException("reportData is null");
        }
        if (reportName == null) {
            throw new OptimizeRuntimeException("reportName is null");
        }
        String id = IdGenerator.getNextId();
        SingleProcessReportDefinitionRequestDto reportDefinitionDto = new SingleProcessReportDefinitionRequestDto();
        reportDefinitionDto.setId(id);
        OffsetDateTime now = LocalDateUtil.getCurrentDateTime();
        reportDefinitionDto.setCreated(now);
        reportDefinitionDto.setLastModified(now);
        reportDefinitionDto.setOwner(userId);
        reportDefinitionDto.setLastModifier(userId);
        reportDefinitionDto.setName(reportName);
        reportDefinitionDto.setDescription(description);
        reportDefinitionDto.setData((ReportDataDto)reportData);
        reportDefinitionDto.setCollectionId(collectionId);
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "single-process-report").id(id).document((Object)reportDefinitionDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created)) {
                String message = "Could not write single process report to Elasticsearch.";
                LOG.error("Could not write single process report to Elasticsearch.");
                throw new OptimizeRuntimeException("Could not write single process report to Elasticsearch.");
            }
            LOG.debug("Single process report with id [{}] has successfully been created.", (Object)id);
            return new IdResponseDto(id);
        }
        catch (IOException e) {
            String errorMessage = "Was not able to insert single process report.";
            LOG.error("Was not able to insert single process report.", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to insert single process report.", (Throwable)e);
        }
    }

    @Override
    public IdResponseDto createNewSingleDecisionReport(String userId, DecisionReportDataDto reportData, String reportName, String description, String collectionId) {
        LOG.debug("Writing new single report to Elasticsearch");
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (reportData == null) {
            throw new OptimizeRuntimeException("reportData is null");
        }
        if (reportName == null) {
            throw new OptimizeRuntimeException("reportName is null");
        }
        String id = IdGenerator.getNextId();
        SingleDecisionReportDefinitionRequestDto reportDefinitionDto = new SingleDecisionReportDefinitionRequestDto();
        reportDefinitionDto.setId(id);
        OffsetDateTime now = LocalDateUtil.getCurrentDateTime();
        reportDefinitionDto.setCreated(now);
        reportDefinitionDto.setLastModified(now);
        reportDefinitionDto.setOwner(userId);
        reportDefinitionDto.setLastModifier(userId);
        reportDefinitionDto.setName(reportName);
        reportDefinitionDto.setDescription(description);
        reportDefinitionDto.setData((ReportDataDto)reportData);
        reportDefinitionDto.setCollectionId(collectionId);
        try {
            IndexResponse indexResponse = this.esClient.index(OptimizeIndexRequestBuilderES.of(i -> i.optimizeIndex(this.esClient, "single-decision-report").id(id).document((Object)reportDefinitionDto).refresh(Refresh.True)));
            if (!indexResponse.result().equals((Object)Result.Created)) {
                String message = "Could not write single decision report to Elasticsearch.";
                LOG.error("Could not write single decision report to Elasticsearch.");
                throw new OptimizeRuntimeException("Could not write single decision report to Elasticsearch.");
            }
            LOG.debug("Single decision report with id [{}] has successfully been created.", (Object)id);
            return new IdResponseDto(id);
        }
        catch (IOException e) {
            String errorMessage = "Was not able to insert single decision report.";
            LOG.error("Was not able to insert single decision report.", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to insert single decision report.", (Throwable)e);
        }
    }

    @Override
    public void updateSingleProcessReport(SingleProcessReportDefinitionUpdateDto reportUpdate) {
        this.updateReport((ReportDefinitionUpdateDto)reportUpdate, "single-process-report");
    }

    @Override
    public void updateSingleDecisionReport(SingleDecisionReportDefinitionUpdateDto reportUpdate) {
        this.updateReport((ReportDefinitionUpdateDto)reportUpdate, "single-decision-report");
    }

    @Override
    public void updateCombinedReport(ReportDefinitionUpdateDto updatedReport) {
        this.updateReport(updatedReport, "combined-report");
    }

    @Override
    public void updateProcessDefinitionXmlForProcessReportsWithKey(String definitionKey, String definitionXml) {
        String updateItem = String.format("reports with definitionKey [%s]", definitionKey);
        LOG.debug("Updating definition XML in {} in Elasticsearch", (Object)updateItem);
        Script updateDefinitionXmlScript = Script.of(s -> s.lang(ScriptLanguage.Painless).source("ctx._source.data.configuration.xml = params.newXml;").params(Collections.singletonMap("newXml", JsonData.of((Object)definitionXml))));
        this.taskRepositoryES.tryUpdateByQueryRequest(updateItem, updateDefinitionXmlScript, Query.of(q -> q.term(t -> t.field(PROCESS_DEFINITION_PROPERTY).value(definitionKey))), "single-process-report");
    }

    @Override
    public void deleteAllManagementReports() {
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.term(t -> t.field("data.managementReport").value(true))), "all management reports", true, "single-process-report");
    }

    @Override
    public void deleteSingleReport(String reportId) {
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.ids(i -> i.values(reportId, new String[0]))), String.format("single report with ID [%s]", reportId), true, "single-process-report", "single-decision-report");
    }

    @Override
    public void removeSingleReportFromCombinedReports(String reportId) {
        String updateItemName = String.format("report with ID [%s]", reportId);
        LOG.info("Removing {} from combined report.", (Object)updateItemName);
        Script removeReportIdFromCombinedReportsScript = Script.of(s -> s.lang(ScriptLanguage.Painless).source("def reports = ctx._source.data.reports;if(reports != null) {  reports.removeIf(r -> r.id.equals(params.idToRemove));}").params(Map.of("idToRemove", JsonData.of((Object)reportId))));
        this.taskRepositoryES.tryUpdateByQueryRequest(updateItemName, removeReportIdFromCombinedReportsScript, Query.of(q -> q.nested(n -> n.path("data").scoreMode(ChildScoreMode.None).query(qq -> qq.nested(nn -> nn.path(String.join((CharSequence)".", "data", "reports")).scoreMode(ChildScoreMode.None).query(q2 -> q2.term(t -> t.field(String.join((CharSequence)".", "data", "reports", "id")).value(reportId))))))), "combined-report");
    }

    @Override
    public void deleteCombinedReport(String reportId) {
        DeleteResponse deleteResponse;
        LOG.debug("Deleting combined report with id [{}]", (Object)reportId);
        try {
            deleteResponse = this.esClient.delete(OptimizeDeleteRequestBuilderES.of(d -> d.optimizeIndex(this.esClient, "combined-report").id(reportId).refresh(Refresh.True)));
        }
        catch (IOException e) {
            String reason = String.format("Could not delete combined report with id [%s].", reportId);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete combined process report with id [%s]. Combined process report does not exist.Maybe it was already deleted by someone else?", reportId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void deleteAllReportsOfCollection(String collectionId) {
        this.taskRepositoryES.tryDeleteByQueryRequest(Query.of(q -> q.term(t -> t.field("collectionId").value(collectionId))), String.format("all reports of collection with collectionId [%s]", collectionId), true, "combined-report", "single-process-report", "single-decision-report");
    }

    private void updateReport(ReportDefinitionUpdateDto updatedReport, String indexName) {
        LOG.debug("Updating report with id [{}] in Elasticsearch", (Object)updatedReport.getId());
        try {
            Map<String, JsonData> updateParams = DatabaseWriterUtil.createFieldUpdateScriptParams(UPDATABLE_FIELDS, updatedReport, this.objectMapper).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonData.of(e.getValue())));
            JsonData descriptionJson = updatedReport.getDescription() == null ? JsonData.of((Object)JsonValue.NULL) : JsonData.of((Object)updatedReport.getDescription());
            updateParams.put("description", descriptionJson);
            Script updateScript = ElasticsearchWriterUtil.createDefaultScriptWithJsonParams(DatabaseWriterUtil.createUpdateFieldsScript(updateParams.keySet()), updateParams);
            UpdateResponse updateResponse = this.esClient.update(OptimizeUpdateRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{indexName}).id(updatedReport.getId()).script(updateScript).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5))), ReportDefinitionUpdateDto.class);
            if (updateResponse.shards().failed().intValue() > 0) {
                LOG.error("Was not able to update report with id [{}] and name [{}].", (Object)updatedReport.getId(), (Object)updatedReport.getName());
                throw new OptimizeRuntimeException("Was not able to update collection!");
            }
        }
        catch (IOException e2) {
            String errorMessage = String.format("Was not able to update report with id [%s].", updatedReport.getId());
            LOG.error(errorMessage, (Throwable)e2);
            throw new OptimizeRuntimeException(errorMessage, (Throwable)e2);
        }
    }
}

