/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.db.writer.DatabaseWriterUtil;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticsearchWriterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchWriterUtil.class);

    private ElasticsearchWriterUtil() {
    }

    public static Script createFieldUpdateScript(Set<String> fields, Object entityDto, ObjectMapper objectMapper) {
        Map params = DatabaseWriterUtil.createFieldUpdateScriptParams(fields, entityDto, objectMapper);
        return ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams(DatabaseWriterUtil.createUpdateFieldsScript(params.keySet()), params);
    }

    public static <T> Script createDefaultScriptWithPrimitiveParams(String inlineUpdateScript, Map<String, T> params) {
        return Script.of(b -> b.lang(ScriptLanguage.Painless).source(inlineUpdateScript).params(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonData.of(e.getValue())))));
    }

    public static Script createDefaultScriptWithJsonParams(String inlineUpdateScript, Map<String, JsonData> params) {
        return Script.of(b -> b.lang(ScriptLanguage.Painless).source(inlineUpdateScript).params(params));
    }

    public static Script createDefaultScriptWithSpecificDtoParams(String inlineUpdateScript, Map<String, Object> params) {
        return Script.of(b -> {
            b.lang(ScriptLanguage.Painless).source(inlineUpdateScript);
            if (params != null) {
                b.params(params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonData.of(e.getValue()))));
            }
            return b;
        });
    }

    public static Script createDefaultScript(String inlineUpdateScript) {
        return Script.of(b -> b.lang(ScriptLanguage.Painless).source(inlineUpdateScript));
    }
}

