/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.writer;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeUpdateOperationBuilderES;
import io.camunda.optimize.service.db.repository.es.TaskRepositoryES;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Conditional(value={ElasticSearchCondition.class})
public abstract class AbstractProcessDefinitionWriterES {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper objectMapper;
    protected final OptimizeElasticsearchClient esClient;
    protected final TaskRepositoryES taskRepositoryES;

    public AbstractProcessDefinitionWriterES(ObjectMapper objectMapper, OptimizeElasticsearchClient esClient, TaskRepositoryES taskRepositoryES) {
        this.objectMapper = objectMapper;
        this.esClient = esClient;
        this.taskRepositoryES = taskRepositoryES;
    }

    abstract Script createUpdateScript(ProcessDefinitionOptimizeDto var1);

    public void addImportProcessDefinitionToRequest(BulkRequest.Builder bulkRequestBuilder, ProcessDefinitionOptimizeDto processDefinitionDto) {
        Script updateScript = this.createUpdateScript(processDefinitionDto);
        bulkRequestBuilder.operations(b -> b.update(OptimizeUpdateOperationBuilderES.of(u -> ((UpdateOperation.Builder)u.optimizeIndex(this.esClient, "process-definition").id(processDefinitionDto.getId())).action(a -> a.script(updateScript).upsert((Object)processDefinitionDto)).retryOnConflict(Integer.valueOf(5)))));
    }
}

