/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.service;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramBucket;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.elasticsearch._types.aggregations.ReverseNestedAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.NumberRangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.util.ObjectBuilder;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.es.report.context.DateAggregationContextES;
import io.camunda.optimize.service.db.es.report.context.VariableAggregationContextES;
import io.camunda.optimize.service.db.es.report.service.DateAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.es.report.service.NumberVariableAggregationServiceES;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.time.ZoneId;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class VariableAggregationServiceES {
    public static final String NESTED_VARIABLE_AGGREGATION = "nestedVariables";
    public static final String NESTED_FLOWNODE_AGGREGATION = "nestedFlowNodes";
    public static final String VARIABLES_AGGREGATION = "variables";
    public static final String FILTERED_VARIABLES_AGGREGATION = "filteredVariables";
    public static final String FILTERED_INSTANCE_COUNT_AGGREGATION = "filteredInstCount";
    public static final String VARIABLES_INSTANCE_COUNT_AGGREGATION = "instCount";
    public static final String MISSING_VARIABLES_AGGREGATION = "missingVariables";
    public static final String VARIABLE_HISTOGRAM_AGGREGATION = "numberVariableHistogram";
    private final ConfigurationService configurationService;
    private final NumberVariableAggregationServiceES numberVariableAggregationService;
    private final DateAggregationServiceES dateAggregationService;
    private final MinMaxStatsServiceES minMaxStatsService;

    public VariableAggregationServiceES(ConfigurationService configurationService, NumberVariableAggregationServiceES numberVariableAggregationService, DateAggregationServiceES dateAggregationService, MinMaxStatsServiceES minMaxStatsService) {
        this.configurationService = configurationService;
        this.numberVariableAggregationService = numberVariableAggregationService;
        this.dateAggregationService = dateAggregationService;
        this.minMaxStatsService = minMaxStatsService;
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createVariableSubAggregation(VariableAggregationContextES context) {
        context.setVariableRangeMinMaxStats(this.getVariableMinMaxStats(context));
        switch (context.getVariableType()) {
            case STRING: 
            case BOOLEAN: {
                Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().terms(t -> t.field(context.getNestedVariableValueFieldLabel()).size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()));
                context.getSubAggregations().forEach((k, v) -> builder.aggregations(k, a -> v));
                return Optional.of(Map.of(VARIABLES_AGGREGATION, builder));
            }
            case DATE: {
                return this.createDateVariableAggregation(context);
            }
        }
        if (VariableType.getNumericTypes().contains(context.getVariableType())) {
            return this.numberVariableAggregationService.createNumberVariableAggregation(context);
        }
        return Optional.empty();
    }

    public Optional<Query> createVariableFilterQuery(VariableAggregationContextES context) {
        if (VariableType.getNumericTypes().contains(context.getVariableType())) {
            return this.numberVariableAggregationService.getBaselineForNumberVariableAggregation(context).filter(baseLineValue -> !baseLineValue.isNaN()).map(baseLineValue -> Query.of(q -> q.range(r -> r.number(nf -> (ObjectBuilder)((NumberRangeQuery.Builder)nf.field(context.getNestedVariableValueFieldLabel()).lte((Object)context.getMaxVariableValue())).gte(baseLineValue)))));
        }
        return Optional.empty();
    }

    private Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createDateVariableAggregation(VariableAggregationContextES context) {
        DateAggregationContext dateAggContext = ((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)DateAggregationContextES.builder().aggregateByDateUnit(context.getDateUnit())).dateField(context.getNestedVariableValueFieldLabel())).minMaxStats(context.getVariableRangeMinMaxStats())).timezone(context.getTimezone())).subAggregations(context.getSubAggregations())).dateAggregationName(VARIABLES_AGGREGATION)).filterContext(context.getFilterContext())).build();
        return this.dateAggregationService.createDateVariableAggregation((DateAggregationContextES)dateAggContext);
    }

    public Map<String, Map<String, Aggregate>> retrieveResultBucketMap(FilterAggregate filteredParentAgg, Aggregate variableTermsAgg, VariableType variableType, ZoneId timezone) {
        Map<String, Map<String, Object>> bucketAggregations = VariableType.DATE.equals((Object)variableType) ? this.dateAggregationService.mapDateAggregationsToKeyAggregationMap((MultiBucketAggregateBase<? extends MultiBucketBase>)((MultiBucketAggregateBase)((Aggregate)filteredParentAgg.aggregations().get(VARIABLES_AGGREGATION))._get()), timezone) : (variableTermsAgg.isHistogram() ? variableTermsAgg.histogram().buckets().array().stream().collect(Collectors.toMap(HistogramBucket::keyAsString, MultiBucketBase::aggregations, (bucketAggs1, bucketAggs2) -> bucketAggs1)) : variableTermsAgg.sterms().buckets().array().stream().collect(Collectors.toMap(a -> a.key().stringValue(), MultiBucketBase::aggregations, (bucketAggs1, bucketAggs2) -> bucketAggs1)));
        return bucketAggregations;
    }

    public Map<String, Aggregate> retrieveSubAggregationFromBucketMapEntry(Map.Entry<String, Map<String, Aggregate>> bucketMapEntry) {
        ReverseNestedAggregate reverseNested = bucketMapEntry.getValue().get(VARIABLES_INSTANCE_COUNT_AGGREGATION).reverseNested();
        if (reverseNested == null) {
            return bucketMapEntry.getValue();
        }
        Aggregate nestedFlowNodeAgg = (Aggregate)reverseNested.aggregations().get(NESTED_FLOWNODE_AGGREGATION);
        if (nestedFlowNodeAgg == null) {
            return reverseNested.aggregations();
        }
        Map flowNodeAggs = nestedFlowNodeAgg.nested().aggregations();
        FilterAggregate aggregation = ((Aggregate)flowNodeAggs.get("filteredFlowNodeAggregation")).filter();
        return aggregation.aggregations();
    }

    private MinMaxStatDto getVariableMinMaxStats(VariableAggregationContextES context) {
        return this.getVariableMinMaxStats(context.getVariableType(), context.getVariableName(), context.getVariablePath(), context.getNestedVariableNameField(), context.getNestedVariableValueFieldLabel(), context.getIndexNames(), Query.of(q -> q.bool(context.getBaseQueryForMinMaxStats())));
    }

    public MinMaxStatDto getVariableMinMaxStats(VariableType variableType, String variableName, String variablePath, String nestedVariableNameField, String nestedVariableValueFieldLabel, String[] indexNames, Query baseQuery) {
        Query filterQuery = Query.of(q -> q.bool(b -> b.must(m -> m.term(t -> t.field(nestedVariableNameField).value(variableName)))));
        if (VariableType.getNumericTypes().contains(variableType)) {
            return this.minMaxStatsService.getSingleFieldMinMaxStats(baseQuery, indexNames, nestedVariableValueFieldLabel, variablePath, filterQuery);
        }
        if (VariableType.DATE.equals((Object)variableType)) {
            return this.minMaxStatsService.getSingleFieldMinMaxStats(baseQuery, indexNames, nestedVariableValueFieldLabel, "yyyy-MM-dd'T'HH:mm:ss.SSSZ", variablePath, filterQuery);
        }
        return new MinMaxStatDto(Double.NaN, Double.NaN);
    }
}

