/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.service;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CalendarInterval;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramBucket;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FieldDateMath;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.elasticsearch._types.aggregations.RangeBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.Pair;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.db.es.filter.util.DateHistogramFilterUtilES;
import io.camunda.optimize.service.db.es.report.context.DateAggregationContextES;
import io.camunda.optimize.service.db.es.report.interpreter.util.FilterLimitedAggregationUtilES;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.interpreter.util.AggregateByDateUnitMapper;
import io.camunda.optimize.service.db.report.service.DateAggregationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DateAggregationServiceES
extends DateAggregationService {
    private static final String DATE_AGGREGATION = "dateAggregation";
    private static final String UNSUPPORTED_UNIT_STRING = "Unsupported unit: ";
    private final DateTimeFormatter dateTimeFormatter;

    public DateAggregationServiceES(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createProcessInstanceDateAggregation(DateAggregationContextES context) {
        if (context.getMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit())) {
            return this.createAutomaticIntervalAggregationOrFallbackToMonth(context, this::createFilterLimitedProcessDateHistogramWithSubAggregation);
        }
        return Optional.of(this.createFilterLimitedProcessDateHistogramWithSubAggregation(context));
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createModelElementDateAggregation(DateAggregationContextES context) {
        if (context.getMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit())) {
            return this.createAutomaticIntervalAggregationOrFallbackToMonth(context, this::createFilterLimitedModelElementDateHistogramWithSubAggregation);
        }
        return Optional.of(this.createFilterLimitedModelElementDateHistogramWithSubAggregation(context));
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createDateVariableAggregation(DateAggregationContextES context) {
        if (context.getMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit())) {
            return this.createAutomaticIntervalAggregationOrFallbackToMonth(context, this::createDateHistogramWithSubAggregation);
        }
        return Optional.of(this.createDateHistogramWithSubAggregation(context));
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createDecisionEvaluationDateAggregation(DateAggregationContextES context) {
        if (context.getMinMaxStats().isEmpty()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit())) {
            return this.createAutomaticIntervalAggregationOrFallbackToMonth(context, this::createFilterLimitedDecisionDateHistogramWithSubAggregation);
        }
        return Optional.of(this.createFilterLimitedDecisionDateHistogramWithSubAggregation(context));
    }

    public Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createRunningDateAggregation(DateAggregationContextES context) {
        if (!context.getMinMaxStats().isMinValid()) {
            return Optional.empty();
        }
        if (AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit()) && !context.getMinMaxStats().isValidRange()) {
            context.setAggregateByDateUnit(AggregateByDateUnit.MONTH);
        }
        return Optional.of(this.createRunningDateFilterAggregations(context));
    }

    public static Duration getDateHistogramIntervalDurationFromMinMax(MinMaxStatDto minMaxStats) {
        long intervalFromMinToMax = (long)(minMaxStats.getMax() - minMaxStats.getMin()) / 80L;
        return Duration.of(Math.max(intervalFromMinToMax, 1L), ChronoUnit.MILLIS);
    }

    public Map<String, Map<String, Aggregate>> mapDateAggregationsToKeyAggregationMap(Map<String, Aggregate> aggregations, ZoneId timezone) {
        return this.mapDateAggregationsToKeyAggregationMap((MultiBucketAggregateBase<? extends MultiBucketBase>)((MultiBucketAggregateBase)aggregations.get(DATE_AGGREGATION)._get()), timezone);
    }

    public Map<String, Map<String, Aggregate>> mapDateAggregationsToKeyAggregationMap(MultiBucketAggregateBase<? extends MultiBucketBase> aggr, ZoneId timezone) {
        LinkedHashMap<String, Map<String, Aggregate>> formattedKeyToBucketMap = new LinkedHashMap();
        for (MultiBucketBase entry : aggr.buckets().array()) {
            String formattedDate = TimeZoneUtil.formatToCorrectTimezone(entry instanceof DateHistogramBucket ? ((DateHistogramBucket)entry).keyAsString() : ((RangeBucket)entry).key(), timezone, this.dateTimeFormatter);
            formattedKeyToBucketMap.put(formattedDate, entry.aggregations());
        }
        formattedKeyToBucketMap = formattedKeyToBucketMap.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        return formattedKeyToBucketMap;
    }

    private Pair<String, DateHistogramAggregation.Builder> createDateHistogramAggregation(DateAggregationContextES context) {
        DateHistogramAggregation.Builder builder = new DateHistogramAggregation.Builder();
        builder.field(context.getDateField()).format("yyyy-MM-dd'T'HH:mm:ss.SSSZ").calendarInterval(DateAggregationServiceES.mapToCalendarInterval(context.getAggregateByDateUnit())).timeZone(context.getTimezone().toString()).order(NamedValue.of((String)"_key", (Object)SortOrder.Desc), new NamedValue[0]);
        if (context.isExtendBoundsToMinMaxStats() && context.getMinMaxStats().isMaxValid() && context.getMinMaxStats().isMinValid()) {
            builder.extendedBounds(e -> e.min((Object)FieldDateMath.of(f -> f.value(Double.valueOf(context.getMinMaxStats().getMin())))).max((Object)FieldDateMath.of(f -> f.value(Double.valueOf(context.getMinMaxStats().getMax())))));
        }
        return Pair.of((Object)context.getDateAggregationName().orElse(DATE_AGGREGATION), (Object)builder);
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> createDateHistogramWithSubAggregation(DateAggregationContextES context) {
        DateHistogramAggregation.Builder builder = new DateHistogramAggregation.Builder();
        builder.field(context.getDateField()).format("yyyy-MM-dd'T'HH:mm:ss.SSSZ").calendarInterval(DateAggregationServiceES.mapToCalendarInterval(context.getAggregateByDateUnit())).timeZone(context.getTimezone().toString()).order(NamedValue.of((String)"_key", (Object)SortOrder.Desc), new NamedValue[0]);
        Aggregation.Builder.ContainerBuilder abuilder = new Aggregation.Builder().dateHistogram(builder.build());
        context.getSubAggregations().forEach((k, v) -> abuilder.aggregations(k, v.build()));
        return Map.of(context.getDateAggregationName().orElse(DATE_AGGREGATION), abuilder);
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> createRunningDateFilterAggregations(DateAggregationContextES context) {
        AggregateByDateUnit unit = context.getAggregateByDateUnit();
        ZonedDateTime startOfFirstBucket = this.truncateToUnit(context.getEarliestDate(), unit);
        ZonedDateTime endOfLastBucket = AggregateByDateUnit.AUTOMATIC.equals((Object)context.getAggregateByDateUnit()) ? context.getLatestDate() : this.truncateToUnit(context.getLatestDate(), context.getAggregateByDateUnit()).plus(1L, AggregateByDateUnitMapper.mapToChronoUnit((AggregateByDateUnit)unit));
        Duration automaticIntervalDuration = DateAggregationServiceES.getDateHistogramIntervalDurationFromMinMax(context.getMinMaxStats());
        FiltersAggregation.Builder fbuilder = new FiltersAggregation.Builder();
        HashMap<String, Query> keyedQueryMap = new HashMap<String, Query>();
        ZonedDateTime currentBucketStart = startOfFirstBucket;
        while (currentBucketStart.isBefore(endOfLastBucket)) {
            String startAsString = this.dateTimeFormatter.format(currentBucketStart.toOffsetDateTime());
            String endAsString = this.dateTimeFormatter.format(this.getEndOfBucket(currentBucketStart, unit, automaticIntervalDuration).toOffsetDateTime());
            keyedQueryMap.put(startAsString, Query.of(q -> q.bool(b -> b.must(m -> m.range(r -> r.date(d -> (ObjectBuilder)d.field(context.getDateField()).lt((Object)endAsString)))).must(m -> m.bool(bb -> bb.should(s -> s.range(r -> r.date(d -> (ObjectBuilder)d.field(context.getRunningDateReportEndDateField()).gte((Object)startAsString)))).should(s -> s.bool(bbb -> bbb.mustNot(mm -> mm.exists(e -> e.field(context.getRunningDateReportEndDateField()))))))))));
            currentBucketStart = this.getEndOfBucket(currentBucketStart, unit, automaticIntervalDuration);
        }
        fbuilder.filters(f -> f.keyed(keyedQueryMap));
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().filters(fbuilder.build());
        context.getSubAggregations().forEach((k, v) -> builder.aggregations(k, v.build()));
        return Map.of("filterLimitedAggregation", builder);
    }

    private Optional<Map<String, Aggregation.Builder.ContainerBuilder>> createAutomaticIntervalAggregationOrFallbackToMonth(DateAggregationContextES context, Function<DateAggregationContextES, Map<String, Aggregation.Builder.ContainerBuilder>> defaultAggregationCreator) {
        Optional<Pair<String, Aggregation.Builder.ContainerBuilder>> automaticIntervalAggregation = this.createAutomaticIntervalAggregationWithSubAggregation(context);
        if (automaticIntervalAggregation.isPresent()) {
            Pair<String, Aggregation.Builder.ContainerBuilder> automaticIntervalAggregationValue = automaticIntervalAggregation.get();
            context.getSubAggregations().forEach((k, v) -> ((Aggregation.Builder.ContainerBuilder)automaticIntervalAggregationValue.value()).aggregations(k, v.build()));
            return Optional.of(FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation(Query.of(q -> q.bool(b -> b.filter(f -> f.matchAll(m -> m)))), Map.of((String)automaticIntervalAggregationValue.key(), (Aggregation.Builder.ContainerBuilder)automaticIntervalAggregationValue.value())));
        }
        context.setAggregateByDateUnit(AggregateByDateUnit.MONTH);
        return Optional.of(defaultAggregationCreator.apply(context));
    }

    private Optional<Pair<String, Aggregation.Builder.ContainerBuilder>> createAutomaticIntervalAggregationWithSubAggregation(DateAggregationContextES context) {
        ZonedDateTime nextStart;
        if (!context.getMinMaxStats().isValidRange()) {
            return Optional.empty();
        }
        ZonedDateTime min = context.getEarliestDate();
        ZonedDateTime max = context.getLatestDate();
        Duration intervalDuration = DateAggregationServiceES.getDateHistogramIntervalDurationFromMinMax(context.getMinMaxStats());
        DateRangeAggregation.Builder rangeAgg = new DateRangeAggregation.Builder();
        rangeAgg.timeZone(min.getZone().toString()).field(context.getDateField());
        ZonedDateTime start = min;
        do {
            boolean isLast = (nextStart = start.plus(intervalDuration)).isAfter(max) || nextStart.isEqual(max);
            ZonedDateTime end = isLast ? nextStart.plus(1L, ChronoUnit.MILLIS) : nextStart;
            ZonedDateTime finalStart = start;
            rangeAgg.ranges(r -> r.from(f -> f.expr(this.dateTimeFormatter.format(finalStart))).key(this.dateTimeFormatter.format(finalStart)).to(f -> f.expr(this.dateTimeFormatter.format(end))));
        } while ((start = nextStart).isBefore(max));
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().dateRange(rangeAgg.build());
        return Optional.of(Pair.of((Object)context.getDateAggregationName().orElse(DATE_AGGREGATION), (Object)builder));
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> createFilterLimitedDecisionDateHistogramWithSubAggregation(DateAggregationContextES context) {
        Pair<String, DateHistogramAggregation.Builder> dateHistogramAggregation = this.createDateHistogramAggregation(context);
        BoolQuery.Builder limitFilterQuery = DateHistogramFilterUtilES.extendBoundsAndCreateDecisionDateHistogramLimitingFilterFor((DateHistogramAggregation.Builder)dateHistogramAggregation.value(), context, this.dateTimeFormatter);
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().dateHistogram(((DateHistogramAggregation.Builder)dateHistogramAggregation.value()).build());
        context.getSubAggregations().forEach((k, v) -> builder.aggregations(k, v.build()));
        return FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation(Query.of(q -> q.bool(limitFilterQuery.build())), Map.of((String)dateHistogramAggregation.key(), builder));
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> createFilterLimitedProcessDateHistogramWithSubAggregation(DateAggregationContextES context) {
        Pair<String, DateHistogramAggregation.Builder> dateHistogramAggregation = this.createDateHistogramAggregation(context);
        BoolQuery.Builder limitFilterQuery = DateHistogramFilterUtilES.extendBoundsAndCreateProcessDateHistogramLimitingFilterFor((DateHistogramAggregation.Builder)dateHistogramAggregation.value(), context, this.dateTimeFormatter);
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().dateHistogram(((DateHistogramAggregation.Builder)dateHistogramAggregation.value()).build());
        context.getSubAggregations().forEach((k, v) -> builder.aggregations(k, v.build()));
        return FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation(Query.of(q -> q.bool(limitFilterQuery.build())), Map.of((String)dateHistogramAggregation.key(), builder));
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> createFilterLimitedModelElementDateHistogramWithSubAggregation(DateAggregationContextES context) {
        Pair<String, DateHistogramAggregation.Builder> dateHistogramAggregation = this.createDateHistogramAggregation(context);
        BoolQuery.Builder limitFilterQueryBuilder = DateHistogramFilterUtilES.createModelElementDateHistogramLimitingFilterFor(context, this.dateTimeFormatter);
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().dateHistogram(((DateHistogramAggregation.Builder)dateHistogramAggregation.value()).build());
        context.getSubAggregations().forEach((k, v) -> builder.aggregations(k, v.build()));
        return FilterLimitedAggregationUtilES.wrapWithFilterLimitedParentAggregation(Query.of(q -> q.bool(limitFilterQueryBuilder.build())), Map.of((String)dateHistogramAggregation.key(), builder));
    }

    private static CalendarInterval mapToCalendarInterval(AggregateByDateUnit unit) {
        switch (unit) {
            case YEAR: {
                return CalendarInterval.Year;
            }
            case MONTH: {
                return CalendarInterval.Month;
            }
            case WEEK: {
                return CalendarInterval.Week;
            }
            case DAY: {
                return CalendarInterval.Day;
            }
            case HOUR: {
                return CalendarInterval.Hour;
            }
            case MINUTE: {
                return CalendarInterval.Minute;
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_UNIT_STRING + String.valueOf(unit));
    }
}

