/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.service;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.report.interpreter.plan.process.ProcessExecutionPlanInterpreterFacadeES;
import io.camunda.optimize.service.db.report.CombinedReportInstanceCounter;
import io.camunda.optimize.service.db.report.ExecutionContextFactory;
import io.camunda.optimize.service.db.report.ExecutionPlanExtractor;
import io.camunda.optimize.service.db.report.ReportEvaluationContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class CombinedReportInstanceCounterES
extends CombinedReportInstanceCounter<BoolQuery.Builder> {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedReportInstanceCounterES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ExecutionPlanExtractor executionPlanExtractor;
    private final ProcessExecutionPlanInterpreterFacadeES interpreter;

    public CombinedReportInstanceCounterES(OptimizeElasticsearchClient esClient, ExecutionPlanExtractor executionPlanExtractor, ProcessExecutionPlanInterpreterFacadeES interpreter) {
        this.esClient = esClient;
        this.executionPlanExtractor = executionPlanExtractor;
        this.interpreter = interpreter;
    }

    @Override
    public long count(List<SingleProcessReportDefinitionRequestDto> singleReportDefinitions) {
        List<BoolQuery.Builder> baseQueries = this.getAllBaseQueries(singleReportDefinitions);
        BoolQuery.Builder instanceCountRequestQuery = this.createInstanceCountRequestQueries(baseQueries);
        try {
            return this.esClient.count(new String[]{"process-instance"}, instanceCountRequestQuery);
        }
        catch (IOException e) {
            String message = String.format("Could not count instances in combined report with single report IDs: [%s]", singleReportDefinitions.stream().map(ReportDefinitionDto::getId));
            LOG.error(message, (Throwable)e);
            throw new OptimizeRuntimeException(message, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((RuntimeException)e)) {
                LOG.info("Could not evaluate combined instance count because no instance indices exist. Returning a count of 0 instead.");
                return 0L;
            }
            throw e;
        }
    }

    @Override
    protected ExecutionPlanExtractor getExecutionPlanExtractor() {
        return this.executionPlanExtractor;
    }

    @Override
    protected BoolQuery.Builder getBaseQuery(ProcessExecutionPlan plan, ReportEvaluationContext<SingleProcessReportDefinitionRequestDto> context) {
        return this.interpreter.getBaseQueryBuilder(ExecutionContextFactory.buildExecutionContext(plan, context));
    }

    private BoolQuery.Builder createInstanceCountRequestQueries(List<BoolQuery.Builder> baseQueriesBuilders) {
        BoolQuery.Builder baseQuery = new BoolQuery.Builder();
        baseQueriesBuilders.forEach(q -> baseQuery.should(s -> s.bool(q.build())));
        return baseQuery;
    }
}

