/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.view.process;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessViewInstancePercentageInterpreterES
implements ProcessViewInterpreterES {
    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_INSTANCE_PERCENTAGE);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregation.Builder builder = new Aggregation.Builder();
        return Map.of("_frequency", builder.filter(f -> f.matchAll(m -> m)));
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        long unfilteredTotalInstanceCount = context.getUnfilteredTotalInstanceCount();
        if (unfilteredTotalInstanceCount == 0L) {
            return this.createViewResult(null);
        }
        FilterAggregate frequency = aggs.get("_frequency").filter();
        return this.createViewResult((double)frequency.docCount() / (double)unfilteredTotalInstanceCount * 100.0);
    }

    public CompositeCommandResult.ViewResult createViewResult(Double value) {
        return CompositeCommandResult.ViewResult.builder().viewMeasure(CompositeCommandResult.ViewMeasure.builder().value(value).build()).build();
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.createViewResult(0.0);
    }
}

