/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.view.decision;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.service.db.es.report.interpreter.view.decision.DecisionViewInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class DecisionViewInstanceFrequencyInterpreterES
implements DecisionViewInterpreterES {
    @Override
    public Set<DecisionView> getSupportedViews() {
        return Set.of(DecisionView.DECISION_VIEW_INSTANCE_FREQUENCY);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        Aggregation.Builder builder = new Aggregation.Builder();
        return Map.of("_frequency", builder.filter(f -> f.matchAll(m -> m)));
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggs, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        FilterAggregate count = aggs.get("_frequency").filter();
        return this.createViewResult(count.docCount());
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return this.createViewResult(0.0);
    }

    private CompositeCommandResult.ViewResult createViewResult(double value) {
        return CompositeCommandResult.ViewResult.builder().viewMeasure(CompositeCommandResult.ViewMeasure.builder().value(value).build()).build();
    }
}

