/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.util;

import co.elastic.clients.elasticsearch._types.Script;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.DurationFilterDataDto;
import io.camunda.optimize.service.db.es.writer.ElasticsearchWriterUtil;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;

public final class DurationScriptUtilES {
    private DurationScriptUtilES() {
    }

    public static Script getDurationScript(long currRequestDateInMs, String durationFieldName, String referenceDateFieldName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams(DurationScriptUtilES.getDurationCalculationScriptPart(params, currRequestDateInMs, durationFieldName, referenceDateFieldName) + " return result;", params);
    }

    public static Script getUserTaskDurationScript(long currRequestDateInMs, String durationFieldName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams(DurationScriptUtilES.getUserTaskDurationCalculationScriptPart(params, currRequestDateInMs, durationFieldName) + " return result;", params);
    }

    public static Script getDurationFilterScript(long currRequestDateInMs, String durationFieldName, String referenceDateFieldName, DurationFilterDataDto durationFilterDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("filterDuration", DurationScriptUtilES.getFilterDuration(durationFilterDto));
        return ElasticsearchWriterUtil.createDefaultScriptWithPrimitiveParams(DurationScriptUtilES.getDurationCalculationScriptPart(params, currRequestDateInMs, durationFieldName, referenceDateFieldName) + " return (result != null && result " + durationFilterDto.getOperator().getId() + " params['filterDuration']) || (" + durationFilterDto.isIncludeNull() + " && result == null)", params);
    }

    private static long getFilterDuration(DurationFilterDataDto durationFilterDto) {
        return ChronoUnit.valueOf(durationFilterDto.getUnit().name()).getDuration().toMillis() * durationFilterDto.getValue();
    }

    private static String getDurationCalculationScriptPart(Map<String, Object> params, long currRequestDateInMs, String durationFieldName, String referenceDateFieldName) {
        params.put("currRequestDateInMs", currRequestDateInMs);
        params.put("durFieldName", durationFieldName);
        params.put("refDateFieldName", referenceDateFieldName);
        return "Long result; if (doc[params.durFieldName].empty && !doc[params.refDateFieldName].empty) {result = params.currRequestDateInMs - doc[params.refDateFieldName].value.toInstant().toEpochMilli()} else { result = !doc[params.durFieldName].empty ? doc[params.durFieldName].value : null } ";
    }

    private static String getUserTaskDurationCalculationScriptPart(Map<String, Object> params, long currRequestDateInMs, String durationFieldName) {
        params.put("currRequestDateInMs", currRequestDateInMs);
        params.put("startDateFieldName", "flowNodeInstances.startDate");
        params.put("endDateFieldName", "flowNodeInstances.endDate");
        params.put("assigneeFieldName", "flowNodeInstances.assignee");
        params.put("totalDurationFieldName", "flowNodeInstances.totalDurationInMs");
        params.put("idleDurationFieldName", "flowNodeInstances.idleDurationInMs");
        params.put("workDurationFieldName", "flowNodeInstances.workDurationInMs");
        String variableDefinitionScript = DurationScriptUtilES.getUserTaskDurationCalculationVariableDefinitionScriptPart();
        if (durationFieldName.contains("totalDurationInMs")) {
            return DurationScriptUtilES.getUserTaskTotalDurationCalculationScriptPart(variableDefinitionScript);
        }
        if (durationFieldName.contains("idleDurationInMs")) {
            return DurationScriptUtilES.getUserTaskIdleDurationCalculationScriptPart(variableDefinitionScript);
        }
        return DurationScriptUtilES.getUserTaskWorkDurationCalculationScriptPart(variableDefinitionScript);
    }

    private static String getUserTaskDurationCalculationVariableDefinitionScriptPart() {
        return "def result = 0;\ndef hasStarted = !doc[params.startDateFieldName].empty && doc[params.startDateFieldName].value != null;\ndef hasEnded = !doc[params.endDateFieldName].empty && doc[params.endDateFieldName].value != null;\ndef isRunning = hasStarted && !hasEnded;\ndef isCurrentlyIdle = doc[params.assigneeFieldName].empty || doc[params.assigneeFieldName].value == null;\ndef hasTotalDuration = !doc[params.totalDurationFieldName].empty && doc[params.totalDurationFieldName].value != null;\ndef hasIdleDuration = !doc[params.idleDurationFieldName].empty && doc[params.idleDurationFieldName].value != null;\ndef hasWorkDuration = !doc[params.workDurationFieldName].empty && doc[params.workDurationFieldName].value != null;\ndef startTimeInMs = hasStarted ? doc[params.startDateFieldName].value.toInstant().toEpochMilli(): 0;\ndef endTimeInMs = hasEnded ? doc[params.endDateFieldName].value.toInstant().toEpochMilli(): 0;\ndef currTotalDuration = 0;\nif(hasEnded) {\nif(hasTotalDuration) {\ncurrTotalDuration = doc[params.totalDurationFieldName].value;\n} else {\ncurrTotalDuration = endTimeInMs - startTimeInMs;\n}\n} else if(isRunning) {\ncurrTotalDuration = params.currRequestDateInMs - startTimeInMs;\n}\n";
    }

    private static String getUserTaskTotalDurationCalculationScriptPart(String variableDefinitionScript) {
        return variableDefinitionScript + "result = currTotalDuration;";
    }

    private static String getUserTaskIdleDurationCalculationScriptPart(String variableDefinitionScript) {
        return variableDefinitionScript + "if(hasIdleDuration && (hasEnded || !isCurrentlyIdle)){\nresult = doc[params.idleDurationFieldName].value;}\nelse {\ndef durationToAdd = 0;\ndef currentIdleDuration = hasIdleDuration ? doc[params.idleDurationFieldName].value : 0;\ndef workDuration = hasWorkDuration ? doc[params.workDurationFieldName].value : 0;\ndurationToAdd = currTotalDuration - workDuration;\nresult = currentIdleDuration + durationToAdd;\n}\n";
    }

    private static String getUserTaskWorkDurationCalculationScriptPart(String variableDefinitionScript) {
        return variableDefinitionScript + "if(hasWorkDuration && hasEnded){\nresult = doc[params.workDurationFieldName].value;}\nelse if (isCurrentlyIdle) {\nif (hasWorkDuration) {\nresult = doc[params.workDurationFieldName].value;\n} else {\nresult = null ;\n}\n} else {\ndef durationToAdd = 0;\ndef currentWorkDuration = hasWorkDuration ? doc[params.workDurationFieldName].value : 0;\ndef idleDuration = hasIdleDuration ? doc[params.idleDurationFieldName].value : 0;\ndurationToAdd = currTotalDuration - idleDuration;\nresult = currentWorkDuration + durationToAdd;\n}\n";
    }
}

