/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process.date;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.db.es.report.context.DateAggregationContextES;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.service.DateAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.DateAggregationContext;
import io.camunda.optimize.service.db.report.interpreter.groupby.process.date.ProcessGroupByProcessInstanceRunningDateInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessGroupByProcessInstanceRunningDateInterpreterES
extends AbstractProcessGroupByInterpreterES {
    private final DateTimeFormatter formatter;
    private final DateAggregationServiceES dateAggregationService;
    private final MinMaxStatsServiceES minMaxStatsService;
    private final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    private final ProcessViewInterpreterFacadeES viewInterpreter;

    public ProcessGroupByProcessInstanceRunningDateInterpreterES(DateTimeFormatter formatter, DateAggregationServiceES dateAggregationService, MinMaxStatsServiceES minMaxStatsService, ProcessDistributedByInterpreterFacadeES distributedByInterpreter, ProcessViewInterpreterFacadeES viewInterpreter) {
        this.formatter = formatter;
        this.dateAggregationService = dateAggregationService;
        this.minMaxStatsService = minMaxStatsService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_PROCESS_INSTANCE_RUNNING_DATE);
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return ProcessGroupByProcessInstanceRunningDateInterpreter.getMinMaxStats(context, () -> this.minMaxStatsService.getMinMaxDateRangeForCrossField(context, baseQuery, this.getIndexNames(context), "startDate", "endDate"));
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        MinMaxStatDto minMaxStats = this.minMaxStatsService.getMinMaxDateRangeForCrossField(context, Query.of(q -> q.bool(boolQuery)), this.getIndexNames(context), "startDate", "endDate");
        DateAggregationContext dateAggContext = ((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContext.DateAggregationContextBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)((DateAggregationContextES.DateAggregationContextESBuilder)DateAggregationContextES.builder().aggregateByDateUnit(ProcessGroupByProcessInstanceRunningDateInterpreter.getGroupByDateUnit(context.getReportData()))).minMaxStats(minMaxStats)).dateField("startDate")).runningDateReportEndDateField("endDate")).timezone(context.getTimezone())).subAggregations(this.getDistributedByInterpreter().createAggregations(context, boolQuery))).filterContext(context.getFilterContext())).build();
        return this.dateAggregationService.createRunningDateAggregation((DateAggregationContextES)dateAggContext).orElse(Map.of());
    }

    @Override
    protected void addQueryResult(CompositeCommandResult result, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        if (response.aggregations() != null && !response.aggregations().isEmpty()) {
            ProcessGroupByProcessInstanceRunningDateInterpreter.addQueryResult(result, this.processAggregations(response, response.aggregations(), context), context);
        }
    }

    private List<CompositeCommandResult.GroupByResult> processAggregations(ResponseBody<?> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        FiltersAggregate agg = aggregations.get("filterLimitedAggregation").filters();
        ArrayList<CompositeCommandResult.GroupByResult> results = new ArrayList<CompositeCommandResult.GroupByResult>();
        for (Map.Entry entry : agg.buckets().keyed().entrySet()) {
            String key = TimeZoneUtil.formatToCorrectTimezone((String)entry.getKey(), context.getTimezone(), this.formatter);
            List<CompositeCommandResult.DistributedByResult> distributions = this.getDistributedByInterpreter().retrieveResult(response, (Map<String, Aggregate>)((FiltersBucket)entry.getValue()).aggregations(), context);
            results.add(CompositeCommandResult.GroupByResult.createGroupByResult(key, distributions));
        }
        return results;
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }
}

