/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby.process;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.util.DurationScriptUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.service.DurationAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.MinMaxStatsServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessGroupByDurationInterpreterES
extends AbstractProcessGroupByInterpreterES {
    private final DurationAggregationServiceES durationAggregationService;
    private final MinMaxStatsServiceES minMaxStatsService;
    private final ProcessDistributedByInterpreterFacadeES distributedByInterpreter;
    private final ProcessViewInterpreterFacadeES viewInterpreter;

    public ProcessGroupByDurationInterpreterES(DurationAggregationServiceES durationAggregationService, MinMaxStatsServiceES minMaxStatsService, ProcessDistributedByInterpreterFacadeES distributedByInterpreter, ProcessViewInterpreterFacadeES viewInterpreter) {
        this.durationAggregationService = durationAggregationService;
        this.minMaxStatsService = minMaxStatsService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_DURATION);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Script durationScript = this.getDurationScript();
        return this.durationAggregationService.createLimitedGroupByScriptedDurationAggregation(boolQuery, context, durationScript).orElse(Collections.emptyMap());
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        List<CompositeCommandResult.GroupByResult> durationHistogramData = this.durationAggregationService.mapGroupByDurationResults(response, response.aggregations(), context);
        compositeCommandResult.setGroups(durationHistogramData);
        compositeCommandResult.setGroupByKeyOfNumericType(true);
        compositeCommandResult.setDistributedByKeyOfNumericType(this.distributedByInterpreter.isKeyOfNumericType(context));
    }

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return Optional.of(this.retrieveMinMaxDurationStats(context, baseQuery));
    }

    private MinMaxStatDto retrieveMinMaxDurationStats(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        return this.minMaxStatsService.getScriptedMinMaxStats(baseQuery, this.getIndexNames(context), null, this.getDurationScript());
    }

    private Script getDurationScript() {
        return DurationScriptUtilES.getDurationScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), "duration", "startDate");
    }

    public ProcessDistributedByInterpreterFacadeES getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }
}

