/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.groupby;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.ReverseNestedAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.ModelElementFilterQueryUtilES;
import io.camunda.optimize.service.db.es.report.context.VariableAggregationContextES;
import io.camunda.optimize.service.db.es.report.interpreter.groupby.AbstractGroupByInterpreterES;
import io.camunda.optimize.service.db.es.report.service.VariableAggregationServiceES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.VariableAggregationContext;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractGroupByVariableInterpreterES<DATA extends SingleReportDataDto, PLAN extends ExecutionPlan>
extends AbstractGroupByInterpreterES<DATA, PLAN> {
    public static final String FILTERED_FLOW_NODE_AGGREGATION = "filteredFlowNodeAggregation";

    protected abstract VariableAggregationServiceES getVariableAggregationService();

    protected abstract DefinitionService getDefinitionService();

    protected abstract String getVariableName(ExecutionContext<DATA, PLAN> var1);

    protected abstract VariableType getVariableType(ExecutionContext<DATA, PLAN> var1);

    protected abstract String getNestedVariableNameFieldLabel();

    protected abstract String getNestedVariableTypeField();

    protected abstract String getNestedVariableValueFieldLabel(VariableType var1);

    protected abstract String getVariablePath();

    protected abstract BoolQuery.Builder getVariableUndefinedOrNullQuery(ExecutionContext<DATA, PLAN> var1);

    @Override
    public Optional<MinMaxStatDto> getMinMaxStats(ExecutionContext<DATA, PLAN> context, Query baseQuery) {
        if (this.isGroupedByNumberVariable(this.getVariableType(context)) || VariableType.DATE.equals((Object)this.getVariableType(context))) {
            return Optional.of(this.getVariableAggregationService().getVariableMinMaxStats(this.getVariableType(context), this.getVariableName(context), this.getVariablePath(), this.getNestedVariableNameFieldLabel(), this.getNestedVariableValueFieldLabel(this.getVariableType(context)), this.getIndexNames(context), baseQuery));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregation(BoolQuery boolQuery, ExecutionContext<DATA, PLAN> context) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().reverseNested(r -> r);
        this.createDistributedBySubAggregations(context, boolQuery).forEach((arg_0, arg_1) -> ((Aggregation.Builder.ContainerBuilder)builder).aggregations(arg_0, arg_1));
        VariableAggregationContext varAggContext = ((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContext.VariableAggregationContextBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)VariableAggregationContextES.builder().variableName(this.getVariableName(context))).variableType(this.getVariableType(context))).variablePath(this.getVariablePath())).nestedVariableNameField(this.getNestedVariableNameFieldLabel())).nestedVariableValueFieldLabel(this.getNestedVariableValueFieldLabel(this.getVariableType(context)))).indexNames(this.getIndexNames(context))).timezone(context.getTimezone())).customBucketDto(context.getReportData().getConfiguration().getCustomBucket())).dateUnit(this.getGroupByDateUnit(context))).baseQueryForMinMaxStats(boolQuery)).subAggregations(Map.of("instCount", builder))).combinedRangeMinMaxStats(context.getCombinedRangeMinMaxStats().orElse(null))).filterContext(context.getFilterContext())).build();
        Optional<Map<String, Aggregation.Builder.ContainerBuilder>> variableSubAggregation = this.getVariableAggregationService().createVariableSubAggregation((VariableAggregationContextES)varAggContext);
        Optional<Query> variableFilterQuery = this.getVariableAggregationService().createVariableFilterQuery((VariableAggregationContextES)varAggContext);
        if (variableSubAggregation.isEmpty()) {
            return Map.of();
        }
        Aggregation.Builder.ContainerBuilder variableAggregation = new Aggregation.Builder().nested(n -> n.path(this.getVariablePath())).aggregations("filteredVariables", Aggregation.of(a -> a.filter(f -> f.bool(b -> b.must(mm -> mm.term(t -> t.field(this.getNestedVariableNameFieldLabel()).value(this.getVariableName(context)))).must(mm -> mm.term(t -> t.field(this.getNestedVariableTypeField()).value(this.getVariableType(context).getId()))).must(mm -> mm.exists(t -> t.field(this.getNestedVariableValueFieldLabel(VariableType.STRING)))).must(variableFilterQuery.orElseGet(() -> Query.of(q -> q.matchAll(m -> m))), new Query[0]))).aggregations(((Map)variableSubAggregation.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build()))).aggregations("filteredInstCount", Aggregation.of(aa -> aa.reverseNested(n -> n)))));
        Aggregation.Builder.ContainerBuilder undefinedOrNullVariableAggregation = this.createUndefinedOrNullVariableAggregation(context, boolQuery);
        return Map.of("missingVariables", undefinedOrNullVariableAggregation, "nestedVariables", variableAggregation);
    }

    private Map<String, Aggregation> createDistributedBySubAggregations(ExecutionContext<DATA, PLAN> context, BoolQuery baseQuery) {
        if (this.isFlownodeReport(context.getPlan())) {
            Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().nested(n -> n.path("flowNodeInstances"));
            builder.aggregations(FILTERED_FLOW_NODE_AGGREGATION, Aggregation.of(a -> {
                Aggregation.Builder.ContainerBuilder filter = a.filter(f -> f.bool(ModelElementFilterQueryUtilES.createModelElementAggregationFilter((ProcessReportDataDto)context.getReportData(), context.getFilterContext(), this.getDefinitionService()).build()));
                this.getDistributedByInterpreter().createAggregations(context, baseQuery).forEach((k, v) -> a.aggregations(k, v.build()));
                return filter;
            }));
            return Map.of("nestedFlowNodes", builder.build());
        }
        return this.getDistributedByInterpreter().createAggregations(context, baseQuery).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build()));
    }

    private Aggregation.Builder.ContainerBuilder createUndefinedOrNullVariableAggregation(ExecutionContext<DATA, PLAN> context, BoolQuery baseQuery) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().filter(f -> f.bool(this.getVariableUndefinedOrNullQuery(context).build()));
        this.createDistributedBySubAggregations(context, baseQuery).forEach((arg_0, arg_1) -> ((Aggregation.Builder.ContainerBuilder)builder).aggregations(arg_0, arg_1));
        return builder;
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, ResponseBody<?> response, ExecutionContext<DATA, PLAN> context) {
        Aggregate variableTerms;
        if (response.aggregations() == null || response.aggregations().isEmpty()) {
            return;
        }
        NestedAggregate nested = ((Aggregate)response.aggregations().get("nestedVariables")).nested();
        Aggregate filteredVariables = (Aggregate)nested.aggregations().get("filteredVariables");
        Aggregate filteredParentAgg = (Aggregate)filteredVariables.filter().aggregations().get("filterLimitedAggregation");
        if (filteredParentAgg == null) {
            filteredParentAgg = filteredVariables;
        }
        if ((variableTerms = (Aggregate)filteredParentAgg.filter().aggregations().get("variables")) == null) {
            variableTerms = (Aggregate)filteredParentAgg.filter().aggregations().get("numberVariableHistogram");
        }
        Map<String, Map<String, Aggregate>> bucketAggregations = this.getVariableAggregationService().retrieveResultBucketMap(filteredParentAgg.filter(), variableTerms, this.getVariableType(context), context.getTimezone());
        this.getDistributedByInterpreter().enrichContextWithAllExpectedDistributedByKeys(context, filteredParentAgg.filter().aggregations());
        ArrayList<CompositeCommandResult.GroupByResult> groupedData = new ArrayList<CompositeCommandResult.GroupByResult>();
        for (Map.Entry<String, Map<String, Aggregate>> keyToAggregationEntry : bucketAggregations.entrySet()) {
            List<CompositeCommandResult.DistributedByResult> distribution = this.getDistributedByInterpreter().retrieveResult(response, this.getVariableAggregationService().retrieveSubAggregationFromBucketMapEntry(keyToAggregationEntry), context);
            groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult(keyToAggregationEntry.getKey(), distribution));
        }
        this.addMissingVariableBuckets(groupedData, response, context);
        compositeCommandResult.setGroups(groupedData);
        if (VariableType.DATE.equals((Object)this.getVariableType(context))) {
            compositeCommandResult.setGroupBySorting(new ReportSortingDto("key", SortOrder.ASC));
        }
        compositeCommandResult.setGroupByKeyOfNumericType(this.getSortByKeyIsOfNumericType(context));
        compositeCommandResult.setDistributedByKeyOfNumericType(this.getDistributedByInterpreter().isKeyOfNumericType(context));
    }

    private boolean isFlownodeReport(PLAN plan) {
        if (plan instanceof ProcessExecutionPlan) {
            ProcessExecutionPlan processExecutionPlan = (ProcessExecutionPlan)plan;
            return Set.of(ProcessView.PROCESS_VIEW_FLOW_NODE_DURATION, ProcessView.PROCESS_VIEW_FLOW_NODE_FREQUENCY).contains((Object)processExecutionPlan.getView());
        }
        return false;
    }

    private void addMissingVariableBuckets(List<CompositeCommandResult.GroupByResult> groupedData, ResponseBody<?> response, ExecutionContext<DATA, PLAN> context) {
        NestedAggregate nested = ((Aggregate)response.aggregations().get("nestedVariables")).nested();
        FilterAggregate filteredVariables = ((Aggregate)nested.aggregations().get("filteredVariables")).filter();
        ReverseNestedAggregate filteredInstAggr = ((Aggregate)filteredVariables.aggregations().get("filteredInstCount")).reverseNested();
        if (response.hits().total().value() > filteredInstAggr.docCount()) {
            List<CompositeCommandResult.DistributedByResult> missingVarsOperationResult = this.getDistributedByInterpreter().retrieveResult(response, this.retrieveAggregationsForMissingVariables(response), context);
            groupedData.add(CompositeCommandResult.GroupByResult.createGroupByResult("missing", missingVarsOperationResult));
        }
    }

    private Map<String, Aggregate> retrieveAggregationsForMissingVariables(ResponseBody<?> response) {
        FilterAggregate aggregation = ((Aggregate)response.aggregations().get("missingVariables")).filter();
        Aggregate nestedFlowNodeAgg = (Aggregate)aggregation.aggregations().get("nestedFlowNodes");
        if (nestedFlowNodeAgg == null) {
            return aggregation.aggregations();
        }
        Map flowNodeAggs = nestedFlowNodeAgg.nested().aggregations();
        FilterAggregate filteredAgg = ((Aggregate)flowNodeAggs.get(FILTERED_FLOW_NODE_AGGREGATION)).filter();
        return filteredAgg.aggregations();
    }

    private boolean getSortByKeyIsOfNumericType(ExecutionContext<DATA, PLAN> context) {
        return VariableType.getNumericTypes().contains(this.getVariableType(context));
    }

    private AggregateByDateUnit getGroupByDateUnit(ExecutionContext<DATA, PLAN> context) {
        return context.getReportData().getConfiguration().getGroupByDateVariableUnit();
    }

    private boolean isGroupedByNumberVariable(VariableType varType) {
        return VariableType.getNumericTypes().contains(varType);
    }
}

