/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.identity;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.util.NamedValue;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.filter.util.ModelElementFilterQueryUtilES;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.AbstractProcessDistributedByInterpreterES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.distributedby.process.identity.ProcessDistributedByIdentityInterpreterHelper;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractProcessDistributedByIdentityInterpreterES
extends AbstractProcessDistributedByInterpreterES {
    private static final String DISTRIBUTE_BY_IDENTITY_TERMS_AGGREGATION = "identity";
    private static final String FILTERED_USER_TASKS_AGGREGATION = "userTasksFilterAggregation";

    protected abstract ConfigurationService getConfigurationService();

    protected abstract ProcessDistributedByIdentityInterpreterHelper getHelper();

    protected abstract DefinitionService getDefinitionService();

    protected abstract String getIdentityField();

    protected abstract IdentityType getIdentityType();

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, BoolQuery baseQuery) {
        TermsAggregation.Builder builder = new TermsAggregation.Builder();
        builder.size(this.getConfigurationService().getElasticSearchConfiguration().getAggregationBucketLimit()).order(NamedValue.of((String)"_key", (Object)SortOrder.Asc), new NamedValue[0]).field("flowNodeInstances." + this.getIdentityField()).missing("unassignedUserTasks___");
        Aggregation.Builder.ContainerBuilder identityTermsAggregation = new Aggregation.Builder().terms(builder.build());
        this.getViewInterpreter().createAggregations(context).forEach((k, v) -> identityTermsAggregation.aggregations(k, v.build()));
        Aggregation.Builder.ContainerBuilder ag = new Aggregation.Builder().filter(f -> f.bool(ModelElementFilterQueryUtilES.createInclusiveFlowNodeIdFilterQuery((ProcessReportDataDto)context.getReportData(), this.getHelper().getUserTaskIds((ProcessReportDataDto)context.getReportData()), context.getFilterContext(), this.getDefinitionService()).build())).aggregations(DISTRIBUTE_BY_IDENTITY_TERMS_AGGREGATION, identityTermsAggregation.build());
        return Map.of(FILTERED_USER_TASKS_AGGREGATION, ag);
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        FilterAggregate onlyIdentitiesRelatedToTheLatestDefinitionVersion = aggregations.get(FILTERED_USER_TASKS_AGGREGATION).filter();
        StringTermsAggregate byIdentityAggregations = ((Aggregate)onlyIdentitiesRelatedToTheLatestDefinitionVersion.aggregations().get(DISTRIBUTE_BY_IDENTITY_TERMS_AGGREGATION)).sterms();
        ArrayList<CompositeCommandResult.DistributedByResult> distributedByIdentity = new ArrayList<CompositeCommandResult.DistributedByResult>();
        for (StringTermsBucket identityBucket : byIdentityAggregations.buckets().array()) {
            CompositeCommandResult.ViewResult viewResult = this.getViewInterpreter().retrieveResult(response, identityBucket.aggregations(), context);
            String key = identityBucket.key().stringValue();
            if ("unassignedUserTasks___".equals(key)) {
                for (CompositeCommandResult.ViewMeasure viewMeasure : viewResult.getViewMeasures()) {
                    AggregationDto aggTypeDto = viewMeasure.getAggregationType();
                    if (aggTypeDto == null || aggTypeDto.getType() != AggregationType.SUM || viewMeasure.getValue() == null || viewMeasure.getValue() != 0.0) continue;
                    viewMeasure.setValue(null);
                }
            }
            distributedByIdentity.add(CompositeCommandResult.DistributedByResult.createDistributedByResult(key, this.getHelper().resolveIdentityName(key, this::getIdentityType), viewResult));
        }
        this.getHelper().addEmptyMissingDistributedByResults(distributedByIdentity, context, () -> this.getViewInterpreter().createEmptyResult(context));
        return distributedByIdentity;
    }

    @Override
    public void enrichContextWithAllExpectedDistributedByKeys(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Map<String, Aggregate> aggregations) {
        FilterAggregate onlyIdentitiesRelatedToTheLatestDefinitionVersion = aggregations.get(FILTERED_USER_TASKS_AGGREGATION).filter();
        StringTermsAggregate allIdentityAggregation = ((Aggregate)onlyIdentitiesRelatedToTheLatestDefinitionVersion.aggregations().get(DISTRIBUTE_BY_IDENTITY_TERMS_AGGREGATION)).sterms();
        Map<String, String> allDistributedByIdentityKeys = allIdentityAggregation.buckets().array().stream().map(v -> v.key().stringValue()).collect(Collectors.toMap(Function.identity(), key -> this.getHelper().resolveIdentityName((String)key, this::getIdentityType)));
        context.setAllDistributedByKeysAndLabels(allDistributedByIdentityKeys);
    }
}

