/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.distributedby.process;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import io.camunda.optimize.dto.optimize.query.report.single.group.AggregateByDateUnit;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.distributed.VariableDistributedByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.distributed.value.VariableDistributedByValueDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.es.report.context.VariableAggregationContextES;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.AbstractProcessDistributedByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.es.report.service.DateAggregationServiceES;
import io.camunda.optimize.service.db.es.report.service.VariableAggregationServiceES;
import io.camunda.optimize.service.db.es.util.ProcessVariableHelperES;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.context.VariableAggregationContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessDistributedByVariableInterpreterES
extends AbstractProcessDistributedByInterpreterES {
    private static final String PARENT_FILTER_AGGREGATION = "matchAllFilter";
    private final ProcessViewInterpreterFacadeES viewInterpreter;
    private final DateAggregationServiceES dateAggregationService;
    private final VariableAggregationServiceES variableAggregationService;

    public ProcessDistributedByVariableInterpreterES(ProcessViewInterpreterFacadeES viewInterpreter, DateAggregationServiceES dateAggregationService, VariableAggregationServiceES variableAggregationService) {
        this.viewInterpreter = viewInterpreter;
        this.dateAggregationService = dateAggregationService;
        this.variableAggregationService = variableAggregationService;
    }

    @Override
    public Set<ProcessDistributedBy> getSupportedDistributedBys() {
        return Set.of(ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_VARIABLE);
    }

    @Override
    public boolean isKeyOfNumericType(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return VariableType.getNumericTypes().contains(this.getVariableType(context));
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, BoolQuery baseQueryBuilder) {
        Aggregation.Builder.ContainerBuilder rnBuilder = new Aggregation.Builder().reverseNested(r -> r);
        this.getViewInterpreter().createAggregations(context).forEach((k, v) -> rnBuilder.aggregations(k, v.build()));
        VariableAggregationContext varAggContext = ((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContext.VariableAggregationContextBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)((VariableAggregationContextES.VariableAggregationContextESBuilder)VariableAggregationContextES.builder().variableName(this.getVariableName(context))).variableType(this.getVariableType(context))).variablePath("variables")).nestedVariableNameField(ProcessVariableHelper.getNestedVariableNameField())).nestedVariableValueFieldLabel(this.getNestedVariableValueFieldLabel(this.getVariableType(context)))).indexNames(InstanceIndexUtil.getProcessInstanceIndexAliasNames((ProcessReportDataDto)context.getReportData()))).timezone(context.getTimezone())).customBucketDto(context.getReportData().getConfiguration().getDistributeByCustomBucket())).dateUnit(this.getDistributeByDateUnit(context))).baseQueryForMinMaxStats(baseQueryBuilder)).subAggregations(Map.of("instCount", rnBuilder))).combinedRangeMinMaxStats(context.getCombinedRangeMinMaxStats().orElse(null))).filterContext(context.getFilterContext())).build();
        Optional<Map<String, Aggregation.Builder.ContainerBuilder>> variableSubAggregation = this.variableAggregationService.createVariableSubAggregation((VariableAggregationContextES)varAggContext);
        if (variableSubAggregation.isEmpty()) {
            return this.getViewInterpreter().createAggregations(context);
        }
        Map<String, Aggregation.Builder.ContainerBuilder> undefinedOrNullVariableAggregation = this.createUndefinedOrNullVariableAggregation(context);
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().filter(f -> f.matchAll(m -> m));
        undefinedOrNullVariableAggregation.forEach((k, v) -> builder.aggregations(k, v.build()));
        builder.aggregations("nestedVariables", Aggregation.of(a -> a.nested(n -> n.path("variables")).aggregations("filteredVariables", Aggregation.of(aa -> aa.filter(f -> f.bool(b -> b.must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableNameField()).value(this.getVariableName(context)))).must(m -> m.term(t -> t.field(ProcessVariableHelper.getNestedVariableTypeField()).value(this.getVariableType(context).getId()))).must(m -> m.exists(e -> e.field(this.getNestedVariableValueFieldLabel(VariableType.STRING)))))).aggregations(((Map)variableSubAggregation.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Aggregation.Builder.ContainerBuilder)e.getValue()).build()))).aggregations("filteredInstCount", Aggregation.of(aaa -> aaa.reverseNested(r -> r)))))));
        return Map.of(PARENT_FILTER_AGGREGATION, builder);
    }

    private Map<String, Aggregation.Builder.ContainerBuilder> createUndefinedOrNullVariableAggregation(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().filter(f -> f.bool(ProcessVariableHelperES.createFilterForUndefinedOrNullQueryBuilder(this.getVariableName(context), this.getVariableType(context)).build()));
        this.getViewInterpreter().createAggregations(context).forEach((k, v) -> builder.aggregations(k, v.build()));
        return Map.of("missingVariables", builder);
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Aggregate variableTerms;
        Aggregate parentFilterAgg = aggregations.get(PARENT_FILTER_AGGREGATION);
        if (parentFilterAgg == null) {
            return Collections.emptyList();
        }
        NestedAggregate nested = ((Aggregate)parentFilterAgg.filter().aggregations().get("nestedVariables")).nested();
        FilterAggregate filteredVariables = ((Aggregate)nested.aggregations().get("filteredVariables")).filter();
        Aggregate filteredParentAgg = (Aggregate)filteredVariables.aggregations().get("filterLimitedAggregation");
        if (filteredParentAgg == null) {
            filteredParentAgg = (Aggregate)nested.aggregations().get("filteredVariables");
        }
        if ((variableTerms = (Aggregate)filteredParentAgg.filter().aggregations().get("variables")) == null) {
            variableTerms = (Aggregate)filteredParentAgg.filter().aggregations().get("numberVariableHistogram");
        }
        Map<String, Map<String, Aggregate>> bucketAggregations = this.variableAggregationService.retrieveResultBucketMap(filteredParentAgg.filter(), variableTerms, this.getVariableType(context), context.getTimezone());
        ArrayList<CompositeCommandResult.DistributedByResult> distributedByResults = new ArrayList<CompositeCommandResult.DistributedByResult>();
        for (Map.Entry<String, Map<String, Aggregate>> keyToAggregationEntry : bucketAggregations.entrySet()) {
            CompositeCommandResult.ViewResult viewResult = this.getViewInterpreter().retrieveResult(response, this.variableAggregationService.retrieveSubAggregationFromBucketMapEntry(keyToAggregationEntry), context);
            distributedByResults.add(CompositeCommandResult.DistributedByResult.createDistributedByResult(keyToAggregationEntry.getKey(), null, viewResult));
        }
        this.addMissingVariableBuckets(distributedByResults, response, aggregations, context);
        this.addEmptyMissingDistributedByResults(distributedByResults, context);
        return distributedByResults;
    }

    @Override
    public void enrichContextWithAllExpectedDistributedByKeys(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Map<String, Aggregate> aggregations) {
        FilterAggregate missingVarAgg;
        Aggregate parentFilterAgg = aggregations.get(PARENT_FILTER_AGGREGATION);
        if (parentFilterAgg == null) {
            context.setAllDistributedByKeysAndLabels(new HashMap<String, String>());
            return;
        }
        Set<String> allDistributedByKeys = new HashSet<String>();
        VariableType type = this.getVariableType(context);
        if (!VariableType.getNumericTypes().contains(type)) {
            NestedAggregate nestedAgg = ((Aggregate)parentFilterAgg.filter().aggregations().get("nestedVariables")).nested();
            FilterAggregate filteredVarAgg = ((Aggregate)nestedAgg.aggregations().get("filteredVariables")).filter();
            if (VariableType.DATE.equals((Object)type)) {
                Aggregate filterLimitedAgg = (Aggregate)filteredVarAgg.aggregations().get("filterLimitedAggregation");
                allDistributedByKeys = this.dateAggregationService.mapDateAggregationsToKeyAggregationMap((MultiBucketAggregateBase<? extends MultiBucketBase>)((MultiBucketAggregateBase)(filterLimitedAgg == null ? ((Aggregate)filteredVarAgg.aggregations().get("variables"))._get() : ((Aggregate)filterLimitedAgg.filter().aggregations().get("variables"))._get())), context.getTimezone()).keySet();
            } else {
                StringTermsAggregate varNamesAgg = ((Aggregate)filteredVarAgg.aggregations().get("variables")).sterms();
                allDistributedByKeys = varNamesAgg.buckets().array().stream().map(b -> b.key().stringValue()).collect(Collectors.toSet());
            }
        }
        if ((missingVarAgg = ((Aggregate)parentFilterAgg.filter().aggregations().get("missingVariables")).filter()).docCount() > 0L) {
            allDistributedByKeys.add("missing");
        }
        context.setAllDistributedByKeys(allDistributedByKeys);
    }

    private void addEmptyMissingDistributedByResults(List<CompositeCommandResult.DistributedByResult> distributedByResults, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        context.getAllDistributedByKeysAndLabels().entrySet().stream().filter(entry -> distributedByResults.stream().noneMatch(distributedByResult -> distributedByResult.getKey().equals(entry.getKey()))).map(entry -> CompositeCommandResult.DistributedByResult.createDistributedByResult((String)entry.getKey(), (String)entry.getValue(), this.getViewInterpreter().createEmptyResult(context))).forEach(distributedByResults::add);
    }

    private void addMissingVariableBuckets(List<CompositeCommandResult.DistributedByResult> distributedByResults, ResponseBody<?> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        FilterAggregate parentFilterAgg = aggregations.get(PARENT_FILTER_AGGREGATION).filter();
        FilterAggregate missingVarAgg = ((Aggregate)parentFilterAgg.aggregations().get("missingVariables")).filter();
        if (missingVarAgg.docCount() > 0L) {
            CompositeCommandResult.ViewResult viewResult = this.getViewInterpreter().retrieveResult(response, (Map<String, Aggregate>)missingVarAgg.aggregations(), context);
            distributedByResults.add(CompositeCommandResult.DistributedByResult.createDistributedByResult("missing", null, viewResult));
        }
    }

    private String getVariableName(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.getVariableDistributedByValueDto(context).getName();
    }

    private VariableType getVariableType(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.getVariableDistributedByValueDto(context).getType();
    }

    private String getNestedVariableValueFieldLabel(VariableType type) {
        return ProcessVariableHelper.getNestedVariableValueFieldForType(type);
    }

    private VariableDistributedByValueDto getVariableDistributedByValueDto(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return (VariableDistributedByValueDto)((VariableDistributedByDto)context.getReportData().getDistributedBy()).getValue();
    }

    private AggregateByDateUnit getDistributeByDateUnit(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return context.getReportData().getConfiguration().getDistributeByDateVariableUnit();
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }
}

