/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.interpreter.distributedby.process;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsBucket;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.util.NamedValue;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.es.report.interpreter.distributedby.process.AbstractProcessDistributedByInterpreterES;
import io.camunda.optimize.service.db.es.report.interpreter.view.process.ProcessViewInterpreterFacadeES;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.distributedby.process.ProcessDistributedByProcessInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessDistributedByProcessInterpreterES
extends AbstractProcessDistributedByInterpreterES
implements ProcessDistributedByProcessInterpreter {
    private final ProcessViewInterpreterFacadeES viewInterpreter;
    private final ConfigurationService configurationService;
    private final ProcessDefinitionReader processDefinitionReader;

    public ProcessDistributedByProcessInterpreterES(ProcessViewInterpreterFacadeES viewInterpreter, ConfigurationService configurationService, ProcessDefinitionReader processDefinitionReader) {
        this.viewInterpreter = viewInterpreter;
        this.configurationService = configurationService;
        this.processDefinitionReader = processDefinitionReader;
    }

    @Override
    public Set<ProcessDistributedBy> getSupportedDistributedBys() {
        return Set.of(ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_PROCESS);
    }

    @Override
    public Map<String, Aggregation.Builder.ContainerBuilder> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, BoolQuery baseQueryBuilder) {
        Aggregation.Builder.ContainerBuilder builder = new Aggregation.Builder().terms(t -> t.size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()).order(NamedValue.of((String)"_key", (Object)SortOrder.Asc), new NamedValue[0]).missing("noTenant____").field(this.tenantField(context)));
        this.viewInterpreter.createAggregations(context).forEach((k, v) -> builder.aggregations(k, v.build()));
        Aggregation.Builder aggBuilder = new Aggregation.Builder();
        return Map.of("processDefKeyAgg", aggBuilder.terms(t -> t.size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()).order(NamedValue.of((String)"_key", (Object)SortOrder.Asc), new NamedValue[0]).field(this.definitionKeyField(context))).aggregations("processDefVersionAgg", Aggregation.of(a -> a.terms(t -> t.size(this.configurationService.getElasticSearchConfiguration().getAggregationBucketLimit()).order(NamedValue.of((String)"_key", (Object)SortOrder.Asc), new NamedValue[0]).field(this.definitionVersionField(context))).aggregations("tenantAgg", builder.build()))));
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> retrieveResult(ResponseBody<?> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        ArrayList results = new ArrayList();
        Map<String, List<ProcessDistributedByProcessInterpreter.ProcessBucket>> bucketsByDefKey = this.extractBucketsByDefKey(response, aggregations, context);
        return this.retrieveResult(bucketsByDefKey, context);
    }

    @Override
    public CompositeCommandResult.ViewResult emptyViewResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.viewInterpreter.createEmptyResult(context);
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.emptyResult(context);
    }

    private Map<String, List<ProcessDistributedByProcessInterpreter.ProcessBucket>> extractBucketsByDefKey(ResponseBody<?> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        HashMap<String, List<ProcessDistributedByProcessInterpreter.ProcessBucket>> bucketsByDefKey = new HashMap<String, List<ProcessDistributedByProcessInterpreter.ProcessBucket>>();
        StringTermsAggregate procDefKeyAgg = aggregations.get("processDefKeyAgg").sterms();
        if (procDefKeyAgg != null) {
            for (StringTermsBucket keyBucket : procDefKeyAgg.buckets().array()) {
                Aggregate procDefVersionAgg = (Aggregate)keyBucket.aggregations().get("processDefVersionAgg");
                if (procDefVersionAgg == null) continue;
                for (StringTermsBucket versionBucket : procDefVersionAgg.sterms().buckets().array()) {
                    Aggregate tenantTermsAgg = (Aggregate)versionBucket.aggregations().get("tenantAgg");
                    if (tenantTermsAgg == null) continue;
                    List bucketsForKey = tenantTermsAgg.sterms().buckets().array().stream().map(tenantBucket -> new ProcessDistributedByProcessInterpreter.ProcessBucket(keyBucket.key().stringValue(), versionBucket.key().stringValue(), tenantBucket.key().stringValue(), tenantBucket.docCount(), this.viewInterpreter.retrieveResult(response, (Map<String, Aggregate>)tenantBucket.aggregations(), context))).collect(Collectors.toList());
                    bucketsByDefKey.computeIfAbsent(keyBucket.key().stringValue(), key -> new ArrayList()).addAll(bucketsForKey);
                }
            }
        }
        return bucketsByDefKey;
    }

    public ProcessViewInterpreterFacadeES getViewInterpreter() {
        return this.viewInterpreter;
    }

    @Override
    public ProcessDefinitionReader getProcessDefinitionReader() {
        return this.processDefinitionReader;
    }
}

