/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.report.aggregations;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.PercentilesAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TDigestPercentilesAggregate;
import co.elastic.clients.util.Pair;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationType;
import io.camunda.optimize.service.db.es.report.aggregations.AggregationStrategyES;
import java.util.Map;
import java.util.Optional;

public class PercentileAggregationES
extends AggregationStrategyES<PercentilesAggregation.Builder> {
    private static final String PERCENTILE_AGGREGATION = "percentileAggregation";
    private final Double percentileValue;

    public PercentileAggregationES(Double percentileValue) {
        this.percentileValue = percentileValue;
    }

    @Override
    public Pair<String, Aggregation.Builder.ContainerBuilder> createAggregationBuilderForAggregation(String customIdentifier, Script script, String ... field) {
        Aggregation.Builder builder = new Aggregation.Builder();
        return Pair.of((Object)this.createAggregationName(customIdentifier, String.valueOf(this.percentileValue), PERCENTILE_AGGREGATION), (Object)builder.percentiles(a -> {
            ((PercentilesAggregation.Builder)a.script(script)).percents(this.percentileValue, new Double[0]);
            if (field != null && field.length != 0) {
                a.field(field[0]);
            }
            return a;
        }));
    }

    @Override
    public Double getValueForAggregation(String customIdentifier, Map<String, Aggregate> aggs) {
        TDigestPercentilesAggregate percentiles = aggs.get(this.createAggregationName(customIdentifier, String.valueOf(this.percentileValue), PERCENTILE_AGGREGATION)).tdigestPercentiles();
        return this.mapToDoubleOrNull(percentiles, this.percentileValue);
    }

    @Override
    public AggregationDto getAggregationType() {
        return new AggregationDto(AggregationType.PERCENTILE, this.percentileValue);
    }

    private Double mapToDoubleOrNull(TDigestPercentilesAggregate aggregation, double percentileValue) {
        Double percentile = Optional.ofNullable(aggregation.values()).filter(h -> h.keyed().get(Double.toString(percentileValue)) != null).map(h -> Double.parseDouble((String)h.keyed().get(Double.toString(percentileValue)))).orElse(null);
        if (percentile == null || Double.isNaN(percentile) || Double.isInfinite(percentile)) {
            return null;
        }
        return percentile;
    }
}

