/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.TenantDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.reader.TenantReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class TenantReaderES
implements TenantReader {
    private static final Logger LOG = LoggerFactory.getLogger(TenantReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;

    public TenantReaderES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public Set<TenantDto> getTenants() {
        SearchResponse scrollResp;
        LOG.debug("Fetching all available tenants");
        try {
            scrollResp = this.esClient.search(OptimizeSearchRequestBuilderES.of(s -> s.optimizeIndex(this.esClient, new String[]{"tenant"}).query(q -> q.matchAll(m -> m)).size(Integer.valueOf(1000)).scroll(ss -> ss.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s"))), TenantDto.class);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Was not able to retrieve tenants!", (Throwable)e);
        }
        return new HashSet<TenantDto>(ElasticsearchReaderUtil.retrieveAllScrollResults(scrollResp, TenantDto.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds()));
    }
}

