/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FilterAggregate;
import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.elasticsearch._types.aggregations.StringTermsAggregate;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.MgetResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.get.GetResult;
import co.elastic.clients.elasticsearch.core.mget.MultiGetResponseItem;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.camunda.optimize.dto.optimize.query.collection.BaseCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionEntity;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameRequestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityNameResponseDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityType;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeMultiGetOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.es.schema.index.DashboardIndexES;
import io.camunda.optimize.service.db.es.schema.index.report.CombinedReportIndexES;
import io.camunda.optimize.service.db.es.schema.index.report.SingleDecisionReportIndexES;
import io.camunda.optimize.service.db.es.schema.index.report.SingleProcessReportIndexES;
import io.camunda.optimize.service.db.reader.EntitiesReader;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class EntitiesReaderES
implements EntitiesReader {
    private static final Logger LOG = LoggerFactory.getLogger(EntitiesReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ConfigurationService configurationService;
    private final OptimizeIndexNameService optimizeIndexNameService;
    private final LocalizationService localizationService;
    private final ObjectMapper objectMapper;

    public EntitiesReaderES(OptimizeElasticsearchClient esClient, ConfigurationService configurationService, OptimizeIndexNameService optimizeIndexNameService, LocalizationService localizationService, ObjectMapper objectMapper) {
        this.esClient = esClient;
        this.configurationService = configurationService;
        this.optimizeIndexNameService = optimizeIndexNameService;
        this.localizationService = localizationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public List<CollectionEntity> getAllPrivateEntities() {
        return this.getAllPrivateEntitiesForOwnerId(null);
    }

    @Override
    public List<CollectionEntity> getAllPrivateEntitiesForOwnerId(String ownerId) {
        SearchResponse scrollResp;
        LOG.debug("Fetching all available entities for user [{}]", (Object)ownerId);
        Query query = Query.of(q -> q.bool(b -> {
            b.mustNot(m -> m.exists(e -> e.field("collectionId"))).must(m -> m.bool(bb -> bb.minimumShouldMatch("1").should(s -> s.term(t -> t.field("managementDashboard").value(false))).should(s -> s.term(t -> t.field("data.managementReport").value(false))).should(s -> s.bool(bbb -> bbb.mustNot(mm -> mm.exists(e -> e.field("managementDashboard"))).mustNot(mm -> mm.exists(e -> e.field("data.managementReport"))))))).must(m -> m.bool(bb -> bb.minimumShouldMatch("1").should(s -> s.term(t -> t.field("instantPreviewDashboard").value(false))).should(s -> s.term(t -> t.field("data.instantPreviewReport").value(false))).should(s -> s.bool(bbb -> bbb.mustNot(mm -> mm.exists(e -> e.field("instantPreviewDashboard"))).mustNot(mm -> mm.exists(e -> e.field("data.instantPreviewReport")))))));
            if (ownerId != null) {
                b.must(m -> m.term(t -> t.field("owner").value(ownerId)));
            }
            return b;
        }));
        SearchRequest searchRequest = this.createReportAndDashboardSearchRequest().query(query).size(Integer.valueOf(1000)).source(s -> s.filter(f -> f.excludes(List.of(ENTITY_LIST_EXCLUDES)))).scroll(t -> t.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s")).build();
        try {
            scrollResp = this.esClient.search(searchRequest, CollectionEntity.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve private entities!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve private entities!", (Throwable)e);
        }
        return ElasticsearchReaderUtil.retrieveAllScrollResults(scrollResp, CollectionEntity.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }

    @Override
    public Map<String, Map<EntityType, Long>> countEntitiesForCollections(List<? extends BaseCollectionDefinitionDto<?>> collections) {
        LOG.debug("Counting all available entities for collection ids [{}]", collections.stream().map(BaseCollectionDefinitionDto::getId).toList());
        if (collections.isEmpty()) {
            return new HashMap<String, Map<EntityType, Long>>();
        }
        SearchRequest.Builder searchRequestBuilder = this.createReportAndDashboardSearchRequest().query(q -> q.terms(t -> t.field("collectionId").terms(tt -> tt.value(collections.stream().map(BaseCollectionDefinitionDto::getId).map(FieldValue::of).toList())))).size(Integer.valueOf(0));
        collections.forEach(collection -> {
            String collectionId = collection.getId();
            Aggregation aggregation = Aggregation.of(a -> a.filter(f -> f.bool(b -> b.filter(ff -> ff.term(t -> t.field("collectionId").value(collectionId))))).aggregations("byIndexCount", Aggregation.of(aa -> aa.terms(t -> t.field("_index")))));
            searchRequestBuilder.aggregations(collectionId, aggregation);
        });
        try {
            SearchResponse searchResponse = this.esClient.search(searchRequestBuilder.build(), Object.class);
            return searchResponse.aggregations().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, Map<EntityType, Long>>((String)entry.getKey(), this.extractEntityIndexCounts(((Aggregate)entry.getValue()).filter()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Was not able to count collection entities!", (Throwable)e);
        }
    }

    @Override
    public List<CollectionEntity> getAllEntitiesForCollection(String collectionId) {
        SearchResponse scrollResp;
        LOG.debug("Fetching all available entities for collection [{}]", (Object)collectionId);
        SearchRequest searchRequest = this.createReportAndDashboardSearchRequest().query(q -> q.term(t -> t.field("collectionId").value(collectionId))).size(Integer.valueOf(1000)).scroll(t -> t.time(this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds() + "s")).build();
        try {
            scrollResp = this.esClient.search(searchRequest, CollectionEntity.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to retrieve collection entities!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to retrieve entities!", (Throwable)e);
        }
        return ElasticsearchReaderUtil.retrieveAllScrollResults(scrollResp, CollectionEntity.class, this.objectMapper, this.esClient, (Integer)this.configurationService.getElasticSearchConfiguration().getScrollTimeoutInSeconds());
    }

    @Override
    public Optional<EntityNameResponseDto> getEntityNames(EntityNameRequestDto requestDto, String locale) {
        LOG.debug(String.format("Performing get entity names search request %s", requestDto.toString()));
        MgetResponse<CollectionEntity> multiGetItemResponse = this.runGetEntityNamesRequest(requestDto, CollectionEntity.class);
        if (!ElasticsearchReaderUtil.atLeastOneResponseExistsForMultiGet(multiGetItemResponse)) {
            return Optional.empty();
        }
        EntityNameResponseDto result = new EntityNameResponseDto();
        for (MultiGetResponseItem itemResponse : multiGetItemResponse.docs()) {
            GetResult response = itemResponse.result();
            if (!response.found()) continue;
            String entityId = response.id();
            CollectionEntity entity = (CollectionEntity)response.source();
            if (entityId.equals(requestDto.getCollectionId())) {
                result.setCollectionName(entity.getName());
            }
            if (entityId.equals(requestDto.getDashboardId())) {
                result.setDashboardName(this.getLocalizedDashboardName((DashboardDefinitionRestDto)entity, locale));
                continue;
            }
            if (!entityId.equals(requestDto.getReportId())) continue;
            result.setReportName(this.getLocalizedReportName(this.localizationService, entity, locale));
        }
        return Optional.of(result);
    }

    private Map<EntityType, Long> extractEntityIndexCounts(FilterAggregate collectionFilterAggregation) {
        StringTermsAggregate byIndexNameTerms = ((Aggregate)collectionFilterAggregation.aggregations().get("byIndexCount")).sterms();
        long singleProcessReportCount = this.getDocCountForIndex(byIndexNameTerms, (IndexMappingCreator<?>)new SingleProcessReportIndexES());
        long combinedProcessReportCount = this.getDocCountForIndex(byIndexNameTerms, (IndexMappingCreator<?>)new CombinedReportIndexES());
        long singleDecisionReportCount = this.getDocCountForIndex(byIndexNameTerms, (IndexMappingCreator<?>)new SingleDecisionReportIndexES());
        long dashboardCount = this.getDocCountForIndex(byIndexNameTerms, (IndexMappingCreator<?>)new DashboardIndexES());
        return ImmutableMap.of((Object)EntityType.DASHBOARD, (Object)dashboardCount, (Object)EntityType.REPORT, (Object)(singleProcessReportCount + singleDecisionReportCount + combinedProcessReportCount));
    }

    private long getDocCountForIndex(StringTermsAggregate byIndexNameTerms, IndexMappingCreator<?> indexMapper) {
        return byIndexNameTerms.buckets().array().stream().filter(s -> this.optimizeIndexNameService.getOptimizeIndexNameWithVersionWithoutSuffix(indexMapper).equals(s.key().stringValue())).findFirst().map(MultiBucketBase::docCount).orElse(0L);
    }

    private <T> MgetResponse<T> runGetEntityNamesRequest(EntityNameRequestDto requestDto, Class<T> clazz) {
        MgetResponse multiGetItemResponses;
        MgetRequest.Builder builder = new MgetRequest.Builder();
        this.addGetEntityToRequest(builder, requestDto.getReportId(), "single-process-report");
        this.addGetEntityToRequest(builder, requestDto.getReportId(), "single-decision-report");
        this.addGetEntityToRequest(builder, requestDto.getReportId(), "combined-report");
        this.addGetEntityToRequest(builder, requestDto.getDashboardId(), "dashboard");
        this.addGetEntityToRequest(builder, requestDto.getCollectionId(), "collection");
        MgetRequest request = builder.build();
        if (request.docs().isEmpty()) {
            throw new BadRequestException("No ids for entity name request provided");
        }
        try {
            multiGetItemResponses = this.esClient.mget(request, clazz);
        }
        catch (IOException e) {
            String reason = String.format("Could not get entity names search request %s", requestDto);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        return multiGetItemResponses;
    }

    private void addGetEntityToRequest(MgetRequest.Builder request, String entityId, String entityIndexName) {
        if (entityId != null) {
            OptimizeMultiGetOperationBuilderES builder = new OptimizeMultiGetOperationBuilderES();
            request.docs(d -> builder.optimizeIndex(this.esClient, entityIndexName).id(entityId));
        }
    }

    private SearchRequest.Builder createReportAndDashboardSearchRequest() {
        OptimizeSearchRequestBuilderES searchRequest = new OptimizeSearchRequestBuilderES();
        searchRequest.optimizeIndex(this.esClient, new String[]{"single-process-report", "single-decision-report", "combined-report", "dashboard"});
        return searchRequest;
    }

    private String getLocalizedDashboardName(DashboardDefinitionRestDto dashboardEntity, String locale) {
        if (dashboardEntity.isInstantPreviewDashboard()) {
            return this.localizationService.getLocalizationForInstantPreviewDashboardCode(locale, dashboardEntity.getName());
        }
        if (dashboardEntity.isManagementDashboard()) {
            return this.localizationService.getLocalizationForManagementDashboardCode(locale, dashboardEntity.getName());
        }
        return dashboardEntity.getName();
    }
}

