/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.reader;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.NestedQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.core.CountRequest;
import co.elastic.clients.elasticsearch.core.CountResponse;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.query.analysis.BranchAnalysisRequestDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeCountRequestBuilderES;
import io.camunda.optimize.service.db.es.filter.ProcessQueryFilterEnhancerES;
import io.camunda.optimize.service.db.es.schema.index.ProcessInstanceIndexES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.db.reader.BranchAnalysisReader;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DefinitionQueryUtilES;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class BranchAnalysisReaderES
extends BranchAnalysisReader {
    private static final Logger LOG = LoggerFactory.getLogger(BranchAnalysisReaderES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ProcessQueryFilterEnhancerES queryFilterEnhancer;
    private final ProcessDefinitionReader processDefinitionReader;

    public BranchAnalysisReaderES(DefinitionService definitionService, OptimizeElasticsearchClient esClient, ProcessQueryFilterEnhancerES queryFilterEnhancer, ProcessDefinitionReader processDefinitionReader) {
        super(definitionService);
        this.esClient = esClient;
        this.queryFilterEnhancer = queryFilterEnhancer;
        this.processDefinitionReader = processDefinitionReader;
    }

    @Override
    protected long calculateReachedEndEventFlowNodeCount(String flowNodeId, BranchAnalysisRequestDto request, Set<String> activitiesToExclude, ZoneId timezone) {
        BoolQuery.Builder builder = this.buildBaseQuery(request, activitiesToExclude).must(this.createMustMatchFlowNodeIdQuery(request.getGateway()), new Query[0]).must(this.createMustMatchFlowNodeIdQuery(flowNodeId), new Query[0]).must(this.createMustMatchFlowNodeIdQuery(request.getEnd()), new Query[0]);
        return this.executeQuery(request, builder, timezone);
    }

    @Override
    protected long calculateFlowNodeCount(String flowNodeId, BranchAnalysisRequestDto request, Set<String> activitiesToExclude, ZoneId timezone) {
        BoolQuery.Builder builder = this.buildBaseQuery(request, activitiesToExclude).must(this.createMustMatchFlowNodeIdQuery(request.getGateway()), new Query[0]).must(this.createMustMatchFlowNodeIdQuery(flowNodeId), new Query[0]);
        return this.executeQuery(request, builder, timezone);
    }

    private BoolQuery.Builder buildBaseQuery(BranchAnalysisRequestDto request, Set<String> activitiesToExclude) {
        BoolQuery.Builder query = DefinitionQueryUtilES.createDefinitionQuery(request.getProcessDefinitionKey(), request.getProcessDefinitionVersions(), request.getTenantIds(), new ProcessInstanceIndexES(request.getProcessDefinitionKey()), this.processDefinitionReader::getLatestVersionToKey);
        this.excludeFlowNodes(activitiesToExclude, query);
        return query;
    }

    private void excludeFlowNodes(Set<String> flowNodeIdsToExclude, BoolQuery.Builder query) {
        for (String excludeFlowNodeId : flowNodeIdsToExclude) {
            query.mustNot(this.createMustMatchFlowNodeIdQuery(excludeFlowNodeId), new Query[0]);
        }
    }

    private Query createMustMatchFlowNodeIdQuery(String flowNodeId) {
        return Query.of(qu -> qu.nested(NestedQuery.of(b -> b.path("flowNodeInstances").query(q -> q.term(t -> t.field("flowNodeInstances.flowNodeId").value(FieldValue.of((String)flowNodeId)))).scoreMode(ChildScoreMode.None))));
    }

    private long executeQuery(BranchAnalysisRequestDto request, BoolQuery.Builder bool, ZoneId timezone) {
        this.queryFilterEnhancer.addFilterToQuery(bool, request.getFilter(), FilterContext.builder().timezone(timezone).build());
        CountRequest countRequest = OptimizeCountRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, InstanceIndexUtil.getProcessInstanceIndexAliasName((String)request.getProcessDefinitionKey())).query(q -> q.bool(bool.build())));
        try {
            CountResponse countResponse = this.esClient.count(countRequest);
            return countResponse.count();
        }
        catch (IOException e) {
            String reason = String.format("Was not able to perform branch analysis on process definition with key [%s] and versions [%s}]", request.getProcessDefinitionKey(), request.getProcessDefinitionVersions());
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (ElasticsearchException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((DefinitionType)DefinitionType.PROCESS, (RuntimeException)((Object)e))) {
                LOG.info("Was not able to perform branch analysis because the required instance index {} does not exist. Returning 0 instead.", (Object)InstanceIndexUtil.getProcessInstanceIndexAliasName((String)request.getProcessDefinitionKey()));
                return 0L;
            }
            throw e;
        }
    }
}

