/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.es.filter;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.data.ExecutingFlowNodeFilterDataDto;
import io.camunda.optimize.service.db.es.filter.QueryFilterES;
import io.camunda.optimize.service.db.filter.FilterContext;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.List;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ExecutingFlowNodeQueryFilterES
implements QueryFilterES<ExecutingFlowNodeFilterDataDto> {
    @Override
    public void addFilters(BoolQuery.Builder query, List<ExecutingFlowNodeFilterDataDto> flowNodeFilter, FilterContext filterContext) {
        if (!flowNodeFilter.isEmpty()) {
            flowNodeFilter.forEach(filter -> query.filter(f -> f.bool(this.createFilterQueryBuilder((ExecutingFlowNodeFilterDataDto)filter).build())));
        }
    }

    private BoolQuery.Builder createFilterQueryBuilder(ExecutingFlowNodeFilterDataDto flowNodeFilter) {
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        flowNodeFilter.getValues().forEach(flowNodeId -> boolQueryBuilder.should(s -> s.nested(n -> n.path("flowNodeInstances").query(q -> q.bool(b -> b.must(m -> m.term(t -> t.field(this.nestedActivityIdFieldLabel()).value(flowNodeId))).mustNot(m -> m.exists(e -> e.field(this.nestedEndDateFieldLabel()))))).scoreMode(ChildScoreMode.None))));
        return boolQueryBuilder;
    }

    private String nestedActivityIdFieldLabel() {
        return "flowNodeInstances.flowNodeId";
    }

    private String nestedEndDateFieldLabel() {
        return "flowNodeInstances.endDate";
    }
}

