/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.dashboard;

import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardAssigneeFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardCandidateGroupFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardInstanceEndDateFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardInstanceStartDateFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardStateFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardVariableFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.data.DashboardIdentityFilterDataDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.data.DashboardVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardReportTileDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardTileType;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.operator.MembershipFilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.dto.optimize.rest.AuthorizationType;
import io.camunda.optimize.dto.optimize.rest.AuthorizedDashboardDefinitionResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemDto;
import io.camunda.optimize.dto.optimize.rest.ConflictedItemType;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.reader.DashboardReader;
import io.camunda.optimize.service.db.reader.ReportReader;
import io.camunda.optimize.service.db.writer.DashboardWriter;
import io.camunda.optimize.service.exceptions.InvalidDashboardVariableFilterException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.relations.CollectionReferencingService;
import io.camunda.optimize.service.relations.DashboardRelationService;
import io.camunda.optimize.service.relations.ReportReferencingService;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.variable.ProcessVariableService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DashboardService
implements ReportReferencingService,
CollectionReferencingService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardService.class);
    private final DashboardWriter dashboardWriter;
    private final DashboardReader dashboardReader;
    private final ProcessVariableService processVariableService;
    private final ReportService reportService;
    private final AuthorizedCollectionService collectionService;
    private final AbstractIdentityService identityService;
    private final ReportReader reportReader;
    private final DashboardRelationService dashboardRelationService;

    public DashboardService(DashboardWriter dashboardWriter, DashboardReader dashboardReader, ProcessVariableService processVariableService, ReportService reportService, AuthorizedCollectionService collectionService, AbstractIdentityService identityService, ReportReader reportReader, DashboardRelationService dashboardRelationService) {
        this.dashboardWriter = dashboardWriter;
        this.dashboardReader = dashboardReader;
        this.processVariableService = processVariableService;
        this.reportService = reportService;
        this.collectionService = collectionService;
        this.identityService = identityService;
        this.reportReader = reportReader;
        this.dashboardRelationService = dashboardRelationService;
    }

    @Override
    public Set<ConflictedItemDto> getConflictedItemsForReportDelete(ReportDefinitionDto reportDefinition) {
        return this.getDashboardsForReport(reportDefinition.getId()).stream().map(dashboardDefinitionDto -> new ConflictedItemDto(dashboardDefinitionDto.getId(), ConflictedItemType.DASHBOARD, dashboardDefinitionDto.getName())).collect(Collectors.toSet());
    }

    @Override
    public void handleReportDeleted(ReportDefinitionDto reportDefinition) {
        if (reportDefinition instanceof SingleProcessReportDefinitionRequestDto) {
            SingleProcessReportDefinitionRequestDto typeCheckedReportDefinition = (SingleProcessReportDefinitionRequestDto)reportDefinition;
            List<ProcessVariableNameResponseDto> varNamesForReportToRemove = this.processVariableService.getVariableNamesForReportDefinitions(Collections.singletonList(typeCheckedReportDefinition));
            this.removeVariableFiltersFromDashboardsIfUnavailable(varNamesForReportToRemove, typeCheckedReportDefinition.getId());
        }
        this.removeReportFromDashboards(reportDefinition.getId());
    }

    @Override
    public Set<ConflictedItemDto> getConflictedItemsForReportUpdate(ReportDefinitionDto currentDefinition, ReportDefinitionDto updateDefinition) {
        return Collections.emptySet();
    }

    @Override
    public void handleReportUpdated(String reportId, ReportDefinitionDto updateDefinition) {
        ReportDefinitionDto existingReport = this.reportReader.getReport(reportId).orElseThrow(() -> new NotFoundException("Report with id [" + reportId + "] does not exist"));
        if (existingReport instanceof SingleProcessReportDefinitionRequestDto) {
            SingleProcessReportDefinitionRequestDto existingReportDefinition = (SingleProcessReportDefinitionRequestDto)existingReport;
            SingleProcessReportDefinitionRequestDto updateReportDefinition = (SingleProcessReportDefinitionRequestDto)updateDefinition;
            List<ProcessVariableNameResponseDto> availableVariableNamesForExistingReport = this.processVariableService.getVariableNamesForReportDefinitions(Collections.singletonList(existingReportDefinition));
            List<ProcessVariableNameResponseDto> availableVariableNamesForUpdatedReport = this.processVariableService.getVariableNamesForReportDefinitions(Collections.singletonList(updateReportDefinition));
            availableVariableNamesForExistingReport.removeAll(availableVariableNamesForUpdatedReport);
            this.removeVariableFiltersFromDashboardsIfUnavailable(availableVariableNamesForExistingReport, reportId);
        }
    }

    @Override
    public Set<ConflictedItemDto> getConflictedItemsForCollectionDelete(CollectionDefinitionDto definition) {
        return this.dashboardReader.getDashboardsForCollection(definition.getId()).stream().map(dashboardDefinitionDto -> new ConflictedItemDto(dashboardDefinitionDto.getId(), ConflictedItemType.COLLECTION, dashboardDefinitionDto.getName())).collect(Collectors.toSet());
    }

    @Override
    public void handleCollectionDeleted(CollectionDefinitionDto definition) {
        this.dashboardWriter.deleteDashboardsOfCollection(definition.getId());
    }

    public IdResponseDto createNewDashboardAndReturnId(String userId, DashboardDefinitionRestDto dashboardDefinitionDto) {
        this.collectionService.verifyUserAuthorizedToEditCollectionResources(userId, dashboardDefinitionDto.getCollectionId());
        this.validateEntityEditorAuthorization(dashboardDefinitionDto.getCollectionId());
        this.validateDashboardFilters(userId, dashboardDefinitionDto);
        return this.dashboardWriter.createNewDashboard(userId, dashboardDefinitionDto);
    }

    public IdResponseDto copyDashboard(String dashboardId, String userId, String name) {
        AuthorizedDashboardDefinitionResponseDto authorizedDashboard = this.getDashboardDefinition(dashboardId, userId);
        DashboardDefinitionRestDto dashboardDefinition = authorizedDashboard.getDefinitionDto();
        String newDashboardName = name != null ? name : dashboardDefinition.getName() + " \u2013 Copy";
        return this.copyAndMoveDashboard(dashboardId, userId, dashboardDefinition.getCollectionId(), newDashboardName);
    }

    public IdResponseDto copyAndMoveDashboard(String dashboardId, String userId, String collectionId, String name) {
        return this.copyAndMoveDashboard(dashboardId, userId, collectionId, name, new HashMap<String, String>(), false);
    }

    public IdResponseDto copyAndMoveDashboard(String dashboardId, String userId, String collectionId, String name, Map<String, String> uniqueReportCopies, boolean keepReportNames) {
        AuthorizedDashboardDefinitionResponseDto authorizedDashboard = this.getDashboardDefinition(dashboardId, userId);
        DashboardDefinitionRestDto dashboardDefinition = authorizedDashboard.getDefinitionDto();
        if (dashboardDefinition.isManagementDashboard() || dashboardDefinition.isInstantPreviewDashboard()) {
            throw new OptimizeValidationException("Management and Instant preview dashboards cannot be copied");
        }
        this.collectionService.verifyUserAuthorizedToEditCollectionResources(userId, collectionId);
        this.validateEntityEditorAuthorization(dashboardDefinition.getCollectionId());
        ArrayList newDashboardReports = new ArrayList(dashboardDefinition.getTiles());
        if (!this.isSameCollection(collectionId, dashboardDefinition.getCollectionId())) {
            newDashboardReports.clear();
            this.containingReportsComplyWithNewCollectionScope(userId, collectionId, dashboardDefinition);
            dashboardDefinition.getTiles().forEach(reportLocationDto -> {
                String originalReportId = reportLocationDto.getId();
                if (IdGenerator.isValidId((String)originalReportId)) {
                    String reportCopyId = (String)uniqueReportCopies.get(originalReportId);
                    if (reportCopyId == null) {
                        ReportDefinitionDto report = this.reportReader.getReport(originalReportId).orElseThrow(() -> new NotFoundException("Was not able to retrieve report with id [" + originalReportId + "]from Database. Report does not exist."));
                        String newReportName = keepReportNames ? report.getName() : null;
                        reportCopyId = this.reportService.copyAndMoveReport(originalReportId, userId, collectionId, newReportName, uniqueReportCopies, keepReportNames).getId();
                        uniqueReportCopies.put(originalReportId, reportCopyId);
                    }
                    newDashboardReports.add(reportLocationDto.toBuilder().id(reportCopyId).configuration(reportLocationDto.getConfiguration()).build());
                } else {
                    newDashboardReports.add(reportLocationDto);
                }
            });
        }
        String newDashboardName = name != null ? name : dashboardDefinition.getName() + " \u2013 Copy";
        DashboardDefinitionRestDto newDashboardDefinitionDto = new DashboardDefinitionRestDto();
        newDashboardDefinitionDto.setCollectionId(collectionId);
        newDashboardDefinitionDto.setName(newDashboardName);
        newDashboardDefinitionDto.setDescription(dashboardDefinition.getDescription());
        newDashboardDefinitionDto.setTiles(newDashboardReports);
        newDashboardDefinitionDto.setAvailableFilters(dashboardDefinition.getAvailableFilters());
        return this.dashboardWriter.createNewDashboard(userId, newDashboardDefinitionDto);
    }

    public void validateDashboardDescription(String dashboardDescription) {
        if (dashboardDescription != null) {
            if (dashboardDescription.length() > 400) {
                throw new OptimizeValidationException("Dashboard descriptions cannot be greater than 400 characters");
            }
            if (dashboardDescription.isEmpty()) {
                throw new OptimizeValidationException("Dashboard descriptions cannot be non-null and empty");
            }
        }
    }

    private void removeVariableFiltersFromDashboardsIfUnavailable(List<ProcessVariableNameResponseDto> filters, String reportId) {
        List<DashboardDefinitionRestDto> dashboardsForReport = this.dashboardReader.getDashboardsForReport(reportId);
        dashboardsForReport.stream().filter(dashboard -> !this.extractDashboardVariableFilters(dashboard.getAvailableFilters()).isEmpty()).forEach(dashboard -> {
            List<String> otherReportIdsInDashboard = dashboard.getTiles().stream().filter(tile -> tile.getType() == DashboardTileType.OPTIMIZE_REPORT).map(DashboardReportTileDto::getId).filter(reportInDashboardId -> !reportId.equals(reportInDashboardId)).toList();
            List<SingleProcessReportDefinitionRequestDto> allReportsForIdsOmitXml = this.reportReader.getAllReportsForIdsOmitXml(otherReportIdsInDashboard).stream().filter(SingleProcessReportDefinitionRequestDto.class::isInstance).map(SingleProcessReportDefinitionRequestDto.class::cast).toList();
            List<ProcessVariableNameResponseDto> varNamesForReportsToRemain = this.processVariableService.getVariableNamesForReportDefinitions(allReportsForIdsOmitXml).stream().peek(variableName -> variableName.setLabel(null)).toList();
            List<DashboardVariableFilterDto> filtersToRemove = this.extractDashboardVariableFilters(dashboard.getAvailableFilters()).stream().filter(variableFilter -> {
                DashboardVariableFilterDataDto filterData = (DashboardVariableFilterDataDto)variableFilter.getData();
                ProcessVariableNameResponseDto processVariableForFilter = new ProcessVariableNameResponseDto(filterData.getName(), filterData.getType(), null);
                return !varNamesForReportsToRemain.contains(processVariableForFilter) && filters.contains(processVariableForFilter);
            }).toList();
            if (!filtersToRemove.isEmpty()) {
                dashboard.getAvailableFilters().removeAll(filtersToRemove);
                this.dashboardWriter.updateDashboard(this.convertToUpdateDto((DashboardDefinitionRestDto)dashboard), dashboard.getId());
            }
        });
    }

    private void containingReportsComplyWithNewCollectionScope(String userId, String collectionId, DashboardDefinitionRestDto dashboardDefinition) {
        dashboardDefinition.getTiles().stream().map(DashboardReportTileDto::getId).filter(IdGenerator::isValidId).forEach(reportId -> this.reportService.ensureCompliesWithCollectionScope(userId, collectionId, (String)reportId));
    }

    public AuthorizedDashboardDefinitionResponseDto getDashboardDefinition(String dashboardId, String userId) {
        DashboardDefinitionRestDto dashboard = this.getDashboardDefinitionAsService(dashboardId);
        RoleType currentUserRole = this.getUserRoleType(userId, dashboard);
        return new AuthorizedDashboardDefinitionResponseDto(currentUserRole, dashboard);
    }

    public AuthorizedDashboardDefinitionResponseDto getManagementDashboard() {
        DashboardDefinitionRestDto dashboard = this.getDashboardDefinitionAsService("management-dashboard");
        return new AuthorizedDashboardDefinitionResponseDto(RoleType.VIEWER, dashboard);
    }

    public void verifyUserHasAccessToDashboardCollection(String userId, DashboardDefinitionRestDto dashboard) {
        this.getUserRoleType(userId, dashboard);
    }

    private RoleType getUserRoleType(String userId, DashboardDefinitionRestDto dashboard) {
        RoleType currentUserRole = null;
        if (dashboard.isManagementDashboard() || dashboard.isInstantPreviewDashboard()) {
            currentUserRole = RoleType.VIEWER;
        } else if (dashboard.getCollectionId() != null) {
            currentUserRole = this.collectionService.getUsersCollectionResourceRole(userId, dashboard.getCollectionId()).orElse(null);
        } else if (dashboard.getOwner().equals(userId)) {
            currentUserRole = RoleType.EDITOR;
        }
        if (currentUserRole == null) {
            throw new ForbiddenException(String.format("User [%s] is not authorized to access dashboard [%s].", userId, dashboard.getId()));
        }
        return currentUserRole;
    }

    public List<IdResponseDto> getAllDashboardIdsInCollection(String collectionId) {
        return this.getDashboardDefinitionsInCollectionAsService(collectionId).stream().map(dashboard -> new IdResponseDto(dashboard.getId())).toList();
    }

    public DashboardDefinitionRestDto getDashboardDefinitionAsService(String dashboardId) {
        Optional<DashboardDefinitionRestDto> dashboard = this.dashboardReader.getDashboard(dashboardId);
        if (dashboard.isEmpty()) {
            LOG.error("Was not able to retrieve dashboard with id [{}] from Database.", (Object)dashboardId);
            throw new NotFoundException("Dashboard does not exist! Tried to retrieve dashboard with id " + dashboardId);
        }
        return dashboard.get();
    }

    public List<DashboardDefinitionRestDto> getDashboardDefinitionsAsService(Set<String> dashboardIds) {
        return this.dashboardReader.getDashboards(dashboardIds);
    }

    public void updateDashboard(DashboardDefinitionRestDto updatedDashboard, String userId) {
        String dashboardId = updatedDashboard.getId();
        AuthorizedDashboardDefinitionResponseDto dashboardWithEditAuthorization = this.getDashboardWithEditAuthorization(dashboardId, userId);
        if (dashboardWithEditAuthorization.getDefinitionDto() != null) {
            if (dashboardWithEditAuthorization.getDefinitionDto().isManagementDashboard() || dashboardWithEditAuthorization.getDefinitionDto().isInstantPreviewDashboard()) {
                throw new OptimizeValidationException("Management and Instant preview dashboards cannot be edited");
            }
            this.validateEntityEditorAuthorization(dashboardWithEditAuthorization.getDefinitionDto().getCollectionId());
        }
        DashboardDefinitionUpdateDto updateDto = this.convertToUpdateDtoWithModifier(updatedDashboard, userId);
        String dashboardCollectionId = dashboardWithEditAuthorization.getDefinitionDto().getCollectionId();
        this.validateDashboardFilters(userId, updatedDashboard);
        updateDto.getTiles().forEach(tileDto -> {
            ReportDefinitionDto reportDefinition;
            if (IdGenerator.isValidId((String)tileDto.getId()) && !Objects.equals(dashboardCollectionId, (reportDefinition = this.reportService.getReportDefinition(tileDto.getId(), userId).getDefinitionDto()).getCollectionId())) {
                throw new BadRequestException(String.format("Report %s does not reside in the same collection as the dashboard %s or are both not private entities", reportDefinition.getId(), dashboardId));
            }
        });
        this.dashboardRelationService.handleUpdated(updatedDashboard);
        this.dashboardWriter.updateDashboard(updateDto, dashboardId);
    }

    public void deleteDashboard(String dashboardId) {
        DashboardDefinitionRestDto dashboardDefinitionDto = this.getDashboardDefinitionAsService(dashboardId);
        this.deleteDashboard(dashboardId, dashboardDefinitionDto);
    }

    public void deleteDashboardAsUser(String dashboardId, String userId) {
        DashboardDefinitionRestDto dashboardDefinitionDto = this.getDashboardWithEditAuthorization(dashboardId, userId).getDefinitionDto();
        this.validateEntityCanBeDeletedByUser(dashboardDefinitionDto);
        this.validateEntityEditorAuthorization(dashboardDefinitionDto.getCollectionId());
        this.deleteDashboard(dashboardId, dashboardDefinitionDto);
    }

    public void validateDashboardFilters(String userId, List<DashboardFilterDto<?>> availableFilters, List<DashboardReportTileDto> reportsInDashboard) {
        if (!CollectionUtils.isEmpty(availableFilters)) {
            Map<String, List<DashboardFilterDto<?>>> filtersByClass = availableFilters.stream().collect(Collectors.groupingBy(filter -> filter.getClass().getSimpleName()));
            this.validateFiltersHaveData(availableFilters);
            this.validateDateAndStateFilters(filtersByClass);
            this.validateIdentityFilters(filtersByClass);
            this.validateVariableFilters(filtersByClass);
            this.validateVariableFiltersExistInReports(userId, reportsInDashboard, filtersByClass);
        }
    }

    private List<DashboardDefinitionRestDto> getDashboardDefinitionsInCollectionAsService(String collectionId) {
        return this.dashboardReader.getDashboardsForCollection(collectionId);
    }

    private void deleteDashboard(String dashboardId, DashboardDefinitionRestDto dashboardDefinitionDto) {
        this.dashboardRelationService.handleDeleted(dashboardDefinitionDto);
        this.dashboardWriter.deleteDashboard(dashboardId);
    }

    private AuthorizedDashboardDefinitionResponseDto getDashboardWithEditAuthorization(String dashboardId, String userId) {
        AuthorizedDashboardDefinitionResponseDto authorizedDashboardDefinition = this.getDashboardDefinition(dashboardId, userId);
        if (authorizedDashboardDefinition.getCurrentUserRole().ordinal() < RoleType.EDITOR.ordinal()) {
            throw new ForbiddenException(String.format("User [%s] is not authorized to edit dashboard [%s].", userId, dashboardId));
        }
        return authorizedDashboardDefinition;
    }

    private void validateDashboardFilters(String userId, DashboardDefinitionRestDto dashboardDefinitionDto) {
        this.validateDashboardFilters(userId, dashboardDefinitionDto.getAvailableFilters(), dashboardDefinitionDto.getTiles());
    }

    private void validateFiltersHaveData(List<DashboardFilterDto<?>> availableFilters) {
        List<DashboardFilterDto> filtersWithoutData = availableFilters.stream().filter(filter -> filter.getData() == null).toList();
        if (!filtersWithoutData.isEmpty()) {
            throw new BadRequestException(String.format("All filters need to supply Filter data, but Filters %s supplied no data field.", filtersWithoutData));
        }
    }

    private void validateVariableFiltersExistInReports(String userId, List<DashboardReportTileDto> reportsInDashboard, Map<String, List<DashboardFilterDto<?>>> filtersByClass) {
        List<DashboardFilterDto<?>> variableFilters = filtersByClass.get(DashboardVariableFilterDto.class.getSimpleName());
        if (CollectionUtils.isEmpty(variableFilters)) {
            return;
        }
        List<String> reportIdsInDashboard = reportsInDashboard.stream().map(DashboardReportTileDto::getId).filter(IdGenerator::isValidId).toList();
        Map<String, List<VariableType>> possibleVarTypesByName = this.processVariableService.getVariableNamesForAuthorizedReports(userId, reportIdsInDashboard).stream().collect(Collectors.groupingBy(ProcessVariableNameResponseDto::getName, Collectors.mapping(ProcessVariableNameResponseDto::getType, Collectors.toList())));
        List<DashboardFilterDto<?>> invalidFilters = variableFilters.stream().filter(this.isInvalidVariableFilter(possibleVarTypesByName)).toList();
        if (!invalidFilters.isEmpty()) {
            throw new InvalidDashboardVariableFilterException(String.format("The following variable filter names/types do not exist in any report in dashboard: [%s]", invalidFilters));
        }
    }

    private Predicate<DashboardFilterDto<?>> isInvalidVariableFilter(Map<String, List<VariableType>> possibleVarTypesByName) {
        return filter -> {
            DashboardVariableFilterDataDto filterData = (DashboardVariableFilterDataDto)((DashboardVariableFilterDto)filter).getData();
            List typesByName = (List)possibleVarTypesByName.get(filterData.getName());
            return typesByName == null || !typesByName.contains(filterData.getType());
        };
    }

    private void validateVariableFilters(Map<String, List<DashboardFilterDto<?>>> filtersByClass) {
        List<DashboardFilterDto<?>> variableFilters = filtersByClass.get(DashboardVariableFilterDto.class.getSimpleName());
        if (variableFilters != null) {
            variableFilters.forEach(variableFilter -> {
                DashboardVariableFilterDataDto filterData = (DashboardVariableFilterDataDto)variableFilter.getData();
                if (filterData == null) {
                    throw new BadRequestException("Variable dashboard filters require additional data");
                }
                VariableType variableType = filterData.getType();
                if ((variableType.equals((Object)VariableType.DATE) || variableType.equals((Object)VariableType.BOOLEAN)) && filterData.getData() != null) {
                    throw new BadRequestException(String.format("Filter subdata cannot be supplied for %s variable filters", variableType));
                }
            });
        }
    }

    private void validateDateAndStateFilters(Map<String, List<DashboardFilterDto<?>>> filtersByClass) {
        filtersByClass.entrySet().stream().filter(byClass -> DashboardInstanceStartDateFilterDto.class.getSimpleName().equals(byClass.getKey()) || DashboardInstanceEndDateFilterDto.class.getSimpleName().equals(byClass.getKey()) || DashboardStateFilterDto.class.getSimpleName().equals(byClass.getKey())).forEach(byClass -> {
            if (((List)byClass.getValue()).size() > 1) {
                throw new BadRequestException(String.format("There can only be one %s. %s supplied: %s", byClass.getKey(), byClass.getKey(), byClass.getValue()));
            }
        });
    }

    private void validateIdentityFilters(Map<String, List<DashboardFilterDto<?>>> filtersByClass) {
        filtersByClass.entrySet().stream().filter(byClass -> DashboardAssigneeFilterDto.class.getSimpleName().equals(byClass.getKey()) || DashboardCandidateGroupFilterDto.class.getSimpleName().equals(byClass.getKey())).forEach(byClass -> {
            boolean hasNullData = ((List)byClass.getValue()).stream().anyMatch(filter -> filter.getData() == null);
            if (hasNullData) {
                throw new BadRequestException("Identity Dashboard filters require additional data");
            }
            long inCount = ((List)byClass.getValue()).stream().filter(filter -> MembershipFilterOperator.IN.equals((Object)((DashboardIdentityFilterDataDto)filter.getData()).getOperator())).count();
            if (inCount > 1L) {
                throw new BadRequestException(String.format("Duplicate identity filter: %s including %s present. There can only be one including %s.", inCount, byClass.getKey(), byClass.getKey()));
            }
            long notInCount = ((List)byClass.getValue()).stream().filter(filter -> MembershipFilterOperator.NOT_IN.equals((Object)((DashboardIdentityFilterDataDto)filter.getData()).getOperator())).count();
            if (notInCount > 1L) {
                throw new BadRequestException(String.format("Duplicate identity filter: %s excluding %s present. There can only be one excluding %s.", notInCount, byClass.getKey(), byClass.getKey()));
            }
        });
    }

    private void validateEntityEditorAuthorization(String collectionId) {
        if (collectionId == null && !this.identityService.getEnabledAuthorizations().contains((Object)AuthorizationType.ENTITY_EDITOR)) {
            throw new ForbiddenException("User is not an authorized entity editor");
        }
    }

    private void validateEntityCanBeDeletedByUser(DashboardDefinitionRestDto dashboardDefinitionDto) {
        if (dashboardDefinitionDto.isManagementDashboard() || dashboardDefinitionDto.isInstantPreviewDashboard()) {
            throw new OptimizeValidationException("Management Dashboards and Instant preview dashboards cannot be deleted");
        }
    }

    private void removeReportFromDashboards(String reportId) {
        this.dashboardWriter.removeReportFromDashboards(reportId);
    }

    private List<DashboardDefinitionRestDto> getDashboardsForReport(String reportId) {
        return this.dashboardReader.getDashboardsForReport(reportId);
    }

    private boolean isSameCollection(String newCollectionId, String oldCollectionId) {
        return StringUtils.equals((CharSequence)newCollectionId, (CharSequence)oldCollectionId);
    }

    private DashboardDefinitionUpdateDto convertToUpdateDtoWithModifier(DashboardDefinitionRestDto updatedDashboard, String userId) {
        DashboardDefinitionUpdateDto dashboardUpdate = this.convertToUpdateDto(updatedDashboard);
        dashboardUpdate.setLastModifier(userId);
        dashboardUpdate.setLastModified(LocalDateUtil.getCurrentDateTime());
        return dashboardUpdate;
    }

    private DashboardDefinitionUpdateDto convertToUpdateDto(DashboardDefinitionRestDto updatedDashboard) {
        DashboardDefinitionUpdateDto updateDto = new DashboardDefinitionUpdateDto();
        updateDto.setName(updatedDashboard.getName());
        updateDto.setDescription(updatedDashboard.getDescription());
        updateDto.setTiles(updatedDashboard.getTiles());
        updateDto.setAvailableFilters(updatedDashboard.getAvailableFilters());
        updateDto.setRefreshRateSeconds(updatedDashboard.getRefreshRateSeconds());
        return updateDto;
    }

    public List<DashboardVariableFilterDto> extractDashboardVariableFilters(List<DashboardFilterDto<?>> availableFilters) {
        return availableFilters.stream().filter(DashboardVariableFilterDto.class::isInstance).map(DashboardVariableFilterDto.class::cast).toList();
    }
}

