/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.cleanup;

import io.camunda.optimize.dto.optimize.DefinitionOptimizeResponseDto;
import io.camunda.optimize.dto.optimize.query.PageResultDto;
import io.camunda.optimize.service.cleanup.CleanupService;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.reader.ProcessInstanceReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.db.writer.variable.ProcessVariableWriter;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.cleanup.CleanupConfiguration;
import io.camunda.optimize.service.util.configuration.cleanup.ProcessDefinitionCleanupConfiguration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EngineDataProcessCleanupService
extends CleanupService {
    private static final Logger LOG = LoggerFactory.getLogger(EngineDataProcessCleanupService.class);
    private final ConfigurationService configurationService;
    private final ProcessDefinitionReader processDefinitionReader;
    private final ProcessInstanceReader processInstanceReader;
    private final ProcessInstanceWriter processInstanceWriter;
    private final ProcessVariableWriter processVariableWriter;

    public EngineDataProcessCleanupService(ConfigurationService configurationService, ProcessDefinitionReader processDefinitionReader, ProcessInstanceReader processInstanceReader, ProcessInstanceWriter processInstanceWriter, ProcessVariableWriter processVariableWriter) {
        this.configurationService = configurationService;
        this.processDefinitionReader = processDefinitionReader;
        this.processInstanceReader = processInstanceReader;
        this.processInstanceWriter = processInstanceWriter;
        this.processVariableWriter = processVariableWriter;
    }

    @Override
    public boolean isEnabled() {
        return this.getCleanupConfiguration().getProcessDataCleanupConfiguration().isEnabled();
    }

    @Override
    public void doCleanup(OffsetDateTime startTime) {
        Set<String> allOptimizeProcessDefinitionKeys = this.getAllCamundaEngineProcessDefinitionKeys();
        this.verifyConfiguredKeysAreKnownDefinitionKeys(allOptimizeProcessDefinitionKeys, this.getCleanupConfiguration().getProcessDataCleanupConfiguration().getAllProcessSpecificConfigurationKeys());
        int i = 1;
        for (String currentProcessDefinitionKey : allOptimizeProcessDefinitionKeys) {
            LOG.info("Process History Cleanup step {}/{}", (Object)i, (Object)allOptimizeProcessDefinitionKeys.size());
            this.performCleanupForProcessKey(startTime, currentProcessDefinitionKey);
            ++i;
        }
    }

    private void performCleanupForProcessKey(OffsetDateTime startTime, String currentProcessDefinitionKey) {
        ProcessDefinitionCleanupConfiguration cleanupConfigurationForKey = this.getCleanupConfiguration().getProcessDefinitionCleanupConfigurationForKey(currentProcessDefinitionKey);
        LOG.info("Performing cleanup on process instances for processDefinitionKey: {}, with ttl: {} and mode:{}", new Object[]{currentProcessDefinitionKey, cleanupConfigurationForKey.getTtl(), cleanupConfigurationForKey.getCleanupMode()});
        OffsetDateTime endDate = startTime.minus(cleanupConfigurationForKey.getTtl());
        switch (cleanupConfigurationForKey.getCleanupMode()) {
            case ALL: {
                this.performInstanceDataCleanup(currentProcessDefinitionKey, endDate, this.getBatchSize());
                break;
            }
            case VARIABLES: {
                this.performVariableDataCleanup(currentProcessDefinitionKey, endDate, this.getBatchSize());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported cleanup mode " + String.valueOf(cleanupConfigurationForKey.getCleanupMode()));
            }
        }
        LOG.info("Finished cleanup on process instances for processDefinitionKey: {}, with ttl: {} and mode:{}", new Object[]{currentProcessDefinitionKey, cleanupConfigurationForKey.getTtl(), cleanupConfigurationForKey.getCleanupMode()});
    }

    private void performInstanceDataCleanup(String definitionKey, OffsetDateTime endDate, int batchSize) {
        PageResultDto<String> currentPageOfProcessInstanceIds = this.processInstanceReader.getFirstPageOfProcessInstanceIdsThatEndedBefore(definitionKey, endDate, batchSize);
        while (!currentPageOfProcessInstanceIds.isEmpty()) {
            List<String> currentInstanceIds = currentPageOfProcessInstanceIds.getEntities();
            this.processInstanceWriter.deleteByIds(definitionKey, currentInstanceIds);
            currentPageOfProcessInstanceIds = this.processInstanceReader.getNextPageOfProcessInstanceIdsThatEndedBefore(definitionKey, endDate, batchSize, currentPageOfProcessInstanceIds);
        }
    }

    private void performVariableDataCleanup(String definitionKey, OffsetDateTime endDate, int batchSize) {
        PageResultDto<String> currentPageOfProcessInstanceIds = this.processInstanceReader.getFirstPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(definitionKey, endDate, batchSize);
        while (!currentPageOfProcessInstanceIds.isEmpty()) {
            List<String> currentInstanceIds = currentPageOfProcessInstanceIds.getEntities();
            this.processVariableWriter.deleteVariableDataByProcessInstanceIds(definitionKey, currentInstanceIds);
            currentPageOfProcessInstanceIds = this.processInstanceReader.getNextPageOfProcessInstanceIdsThatHaveVariablesAndEndedBefore(definitionKey, endDate, batchSize, currentPageOfProcessInstanceIds);
        }
    }

    private Set<String> getAllCamundaEngineProcessDefinitionKeys() {
        return this.processDefinitionReader.getAllProcessDefinitions().stream().map(DefinitionOptimizeResponseDto::getKey).collect(Collectors.toSet());
    }

    private CleanupConfiguration getCleanupConfiguration() {
        return this.configurationService.getCleanupServiceConfiguration();
    }

    private int getBatchSize() {
        return this.getCleanupConfiguration().getProcessDataCleanupConfiguration().getBatchSize();
    }
}

