/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import io.camunda.identity.sdk.Identity;
import io.camunda.optimize.dto.optimize.query.ui_configuration.MixpanelConfigResponseDto;
import io.camunda.optimize.dto.optimize.query.ui_configuration.OnboardingResponseDto;
import io.camunda.optimize.dto.optimize.query.ui_configuration.UIConfigurationResponseDto;
import io.camunda.optimize.license.LicenseType;
import io.camunda.optimize.rest.cloud.CloudSaasMetaInfoService;
import io.camunda.optimize.service.CamundaLicenseService;
import io.camunda.optimize.service.SettingsService;
import io.camunda.optimize.service.exceptions.OptimizeConfigurationException;
import io.camunda.optimize.service.metadata.OptimizeVersionService;
import io.camunda.optimize.service.tenant.TenantService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.OptimizeProfile;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class UIConfigurationService {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);
    private final ConfigurationService configurationService;
    private final OptimizeVersionService versionService;
    private final TenantService tenantService;
    private final SettingsService settingService;
    private final CamundaLicenseService camundaLicenseService;
    private final Environment environment;
    private final Optional<CloudSaasMetaInfoService> cloudSaasMetaInfoService;
    private final Identity identity;

    public UIConfigurationService(ConfigurationService configurationService, OptimizeVersionService versionService, TenantService tenantService, SettingsService settingService, CamundaLicenseService camundaLicenseService, Environment environment, Optional<CloudSaasMetaInfoService> cloudSaasMetaInfoService, Identity identity) {
        this.configurationService = configurationService;
        this.versionService = versionService;
        this.tenantService = tenantService;
        this.settingService = settingService;
        this.camundaLicenseService = camundaLicenseService;
        this.environment = environment;
        this.cloudSaasMetaInfoService = cloudSaasMetaInfoService;
        this.identity = identity;
    }

    public UIConfigurationResponseDto getUIConfiguration() {
        UIConfigurationResponseDto uiConfigurationDto = new UIConfigurationResponseDto();
        uiConfigurationDto.setLogoutHidden(this.configurationService.getUiConfiguration().isLogoutHidden());
        uiConfigurationDto.setEmailEnabled(this.configurationService.getEmailEnabled());
        uiConfigurationDto.setSharingEnabled(this.settingService.getSettings().getSharingEnabled().orElse(false).booleanValue());
        uiConfigurationDto.setTenantsAvailable(this.tenantService.isMultiTenantEnvironment());
        uiConfigurationDto.setOptimizeVersion(this.versionService.getRawVersion());
        uiConfigurationDto.setOptimizeDocsVersion(this.versionService.getDocsVersion());
        OptimizeProfile optimizeProfile = ConfigurationService.getOptimizeProfile((Environment)this.environment);
        uiConfigurationDto.setEnterpriseMode(this.isEnterpriseMode(optimizeProfile));
        uiConfigurationDto.setUserSearchAvailable(this.isUserSearchAvailable(optimizeProfile));
        uiConfigurationDto.setUserTaskAssigneeAnalyticsEnabled(this.configurationService.getUiConfiguration().isUserTaskAssigneeAnalyticsEnabled());
        uiConfigurationDto.setOptimizeProfile(optimizeProfile);
        uiConfigurationDto.setExportCsvLimit(this.configurationService.getCsvConfiguration().getExportCsvLimit());
        uiConfigurationDto.setMaxNumDataSourcesForReport(this.configurationService.getUiConfiguration().getMaxNumDataSourcesForReport());
        uiConfigurationDto.setOptimizeDatabase(ConfigurationService.getDatabaseType((Environment)this.environment));
        uiConfigurationDto.setValidLicense(this.isCamundaLicenseValid());
        uiConfigurationDto.setLicenseType(this.getLicenseType().getName());
        uiConfigurationDto.setCommercial(this.isCommercialCamundaLicense());
        OffsetDateTime expirationDate = this.getCamundaLicenseExpiresAt();
        uiConfigurationDto.setExpiresAt(expirationDate == null ? null : DATE_TIME_FORMATTER.format(this.getCamundaLicenseExpiresAt()));
        MixpanelConfigResponseDto mixpanel = uiConfigurationDto.getMixpanel();
        mixpanel.setEnabled(this.configurationService.getAnalytics().isEnabled());
        mixpanel.setApiHost(this.configurationService.getAnalytics().getMixpanel().getApiHost());
        mixpanel.setToken(this.configurationService.getAnalytics().getMixpanel().getToken());
        mixpanel.setOrganizationId(this.configurationService.getAnalytics().getMixpanel().getProperties().getOrganizationId());
        mixpanel.setOsanoScriptUrl((String)this.configurationService.getAnalytics().getOsano().getScriptUrl().orElse(null));
        mixpanel.setStage(this.configurationService.getAnalytics().getMixpanel().getProperties().getStage());
        mixpanel.setClusterId(this.configurationService.getAnalytics().getMixpanel().getProperties().getClusterId());
        OnboardingResponseDto onboarding = uiConfigurationDto.getOnboarding();
        onboarding.setEnabled(this.configurationService.getOnboarding().isEnabled());
        onboarding.setAppCuesScriptUrl(this.configurationService.getOnboarding().getAppCuesScriptUrl());
        onboarding.setOrgId(this.configurationService.getOnboarding().getProperties().getOrganizationId());
        onboarding.setClusterId(this.configurationService.getOnboarding().getProperties().getClusterId());
        this.cloudSaasMetaInfoService.flatMap(CloudSaasMetaInfoService::getSalesPlanType).ifPresent(arg_0 -> ((OnboardingResponseDto)onboarding).setSalesPlanType(arg_0));
        this.cloudSaasMetaInfoService.ifPresent(service -> {
            uiConfigurationDto.setWebappsLinks(service.getWebappsLinks());
            uiConfigurationDto.setNotificationsUrl(this.configurationService.getPanelNotificationConfiguration().getUrl());
        });
        return uiConfigurationDto;
    }

    private boolean isCamundaLicenseValid() {
        return this.camundaLicenseService.isCamundaLicenseValid();
    }

    private LicenseType getLicenseType() {
        return this.camundaLicenseService.getCamundaLicenseType();
    }

    private boolean isCommercialCamundaLicense() {
        return this.camundaLicenseService.isCommercialCamundaLicense();
    }

    private OffsetDateTime getCamundaLicenseExpiresAt() {
        return this.camundaLicenseService.getCamundaLicenseExpiresAt();
    }

    private boolean isEnterpriseMode(OptimizeProfile optimizeProfile) {
        if (optimizeProfile.equals((Object)OptimizeProfile.CLOUD)) {
            return true;
        }
        if (optimizeProfile.equals((Object)OptimizeProfile.CCSM)) {
            return this.configurationService.getSecurityConfiguration().getLicense().isEnterprise();
        }
        throw new OptimizeConfigurationException("Could not determine whether Optimize is running in enterprise mode");
    }

    private boolean isUserSearchAvailable(OptimizeProfile optimizeProfile) {
        return !OptimizeProfile.CCSM.equals((Object)optimizeProfile) || this.identity.users().isAvailable();
    }
}

