/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service;

import com.google.common.collect.Sets;
import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.GroupDto;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.dto.optimize.query.definition.AssigneeCandidateGroupDefinitionSearchRequestDto;
import io.camunda.optimize.dto.optimize.query.definition.AssigneeCandidateGroupReportSearchRequestDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.rest.exceptions.ForbiddenException;
import io.camunda.optimize.service.db.reader.AssigneeAndCandidateGroupsReader;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.identity.UserTaskIdentityService;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.util.definition.DataSourceDefinitionAuthorizationService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AssigneeCandidateGroupService {
    public static final IdentityType ASSIGNEE_IDENTITY_TYPE = IdentityType.USER;
    private static final IdentityType CANDIDATE_GROUP_IDENTITY_TYPE = IdentityType.GROUP;
    private static final Logger LOG = LoggerFactory.getLogger(AssigneeCandidateGroupService.class);
    private final DataSourceDefinitionAuthorizationService definitionAuthorizationService;
    private final AssigneeAndCandidateGroupsReader assigneeAndCandidateGroupsReader;
    private final UserTaskIdentityService userTaskIdentityService;
    private final ReportService reportService;

    public AssigneeCandidateGroupService(DataSourceDefinitionAuthorizationService definitionAuthorizationService, AssigneeAndCandidateGroupsReader assigneeAndCandidateGroupsReader, UserTaskIdentityService userTaskIdentityService, ReportService reportService) {
        this.definitionAuthorizationService = definitionAuthorizationService;
        this.assigneeAndCandidateGroupsReader = assigneeAndCandidateGroupsReader;
        this.userTaskIdentityService = userTaskIdentityService;
        this.reportService = reportService;
    }

    public Optional<IdentityWithMetadataResponseDto> getIdentityByIdAndType(String id, IdentityType type) {
        return this.userTaskIdentityService.getIdentityByIdAndType(id, type);
    }

    public List<UserDto> getAssigneesByIds(Collection<String> assigneeIds) {
        Map assigneesById = this.userTaskIdentityService.getAssigneesByIds(assigneeIds).stream().collect(Collectors.toMap(IdentityDto::getId, Function.identity()));
        return assigneeIds.stream().map(id -> assigneesById.getOrDefault(id, new UserDto(id))).toList();
    }

    public IdentitySearchResultResponseDto searchForAssigneesAsUser(String userId, AssigneeCandidateGroupDefinitionSearchRequestDto requestDto) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (requestDto == null) {
            throw new OptimizeRuntimeException("requestDto is null");
        }
        return this.searchForAssignees(requestDto.getLimit(), requestDto.getTerms().orElse(""), this.validateAccessAndCreateDefinitionTenantMap(userId, requestDto.getProcessDefinitionKey(), requestDto.getTenantIds()));
    }

    public IdentitySearchResultResponseDto searchForAssigneesAsUser(String userId, AssigneeCandidateGroupReportSearchRequestDto requestDto) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (requestDto == null) {
            throw new OptimizeRuntimeException("requestDto is null");
        }
        return this.searchForAssignees(requestDto.getLimit(), requestDto.getTerms().orElse(""), this.retrieveAuthorizedDefinitionTenantMap(userId, requestDto.getReportIds()));
    }

    public List<GroupDto> getCandidateGroupsByIds(Collection<String> candidateGroupIds) {
        Map candidateGroupsById = this.userTaskIdentityService.getCandidateGroupIdentitiesById(candidateGroupIds).stream().collect(Collectors.toMap(IdentityDto::getId, Function.identity()));
        return candidateGroupIds.stream().map(id -> candidateGroupsById.getOrDefault(id, new GroupDto(id))).toList();
    }

    public IdentitySearchResultResponseDto searchForCandidateGroupsAsUser(String userId, AssigneeCandidateGroupDefinitionSearchRequestDto requestDto) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (requestDto == null) {
            throw new OptimizeRuntimeException("requestDto is null");
        }
        return this.searchForCandidateGroups(requestDto.getLimit(), requestDto.getTerms().orElse(""), this.validateAccessAndCreateDefinitionTenantMap(userId, requestDto.getProcessDefinitionKey(), requestDto.getTenantIds()));
    }

    public IdentitySearchResultResponseDto searchForCandidateGroupsAsUser(String userId, AssigneeCandidateGroupReportSearchRequestDto requestDto) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (requestDto == null) {
            throw new OptimizeRuntimeException("requestDto is null");
        }
        return this.searchForCandidateGroups(requestDto.getLimit(), requestDto.getTerms().orElse(""), this.retrieveAuthorizedDefinitionTenantMap(userId, requestDto.getReportIds()));
    }

    private IdentitySearchResultResponseDto searchForAssignees(int limit, String terms, Map<String, Set<String>> definitionKeyToTenantsMap) {
        if (terms == null) {
            throw new OptimizeRuntimeException("terms is null");
        }
        if (definitionKeyToTenantsMap == null) {
            throw new OptimizeRuntimeException("definitionKeyToTenantsMap is null");
        }
        Set<String> assigneeIdsForProcess = this.assigneeAndCandidateGroupsReader.getAssigneeIdsForProcess(definitionKeyToTenantsMap);
        return this.userTaskIdentityService.searchAmongIdentitiesWithIds(terms, assigneeIdsForProcess, ASSIGNEE_IDENTITY_TYPE, limit);
    }

    private IdentitySearchResultResponseDto searchForCandidateGroups(int limit, String terms, Map<String, Set<String>> definitionKeyToTenantsMap) {
        if (terms == null) {
            throw new OptimizeRuntimeException("terms is null");
        }
        if (definitionKeyToTenantsMap == null) {
            throw new OptimizeRuntimeException("definitionKeyToTenantsMap is null");
        }
        Set<String> candidateGroupIdsForProcess = this.assigneeAndCandidateGroupsReader.getCandidateGroupIdsForProcess(definitionKeyToTenantsMap);
        return this.userTaskIdentityService.searchAmongIdentitiesWithIds(terms, candidateGroupIdsForProcess, CANDIDATE_GROUP_IDENTITY_TYPE, limit);
    }

    private Map<String, Set<String>> retrieveAuthorizedDefinitionTenantMap(String userId, List<String> reportIds) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (reportIds == null) {
            throw new OptimizeRuntimeException("reportIds is null");
        }
        List<ReportDefinitionDto> reports = this.reportService.getAllAuthorizedReportsForIds(userId, reportIds);
        reports.addAll(reports.stream().filter(CombinedReportDefinitionRequestDto.class::isInstance).map(CombinedReportDefinitionRequestDto.class::cast).flatMap(report -> this.reportService.getAllAuthorizedReportsForIds(userId, ((CombinedReportDataDto)report.getData()).getReportIds()).stream()).collect(Collectors.toList()));
        return reports.stream().filter(SingleProcessReportDefinitionRequestDto.class::isInstance).map(SingleProcessReportDefinitionRequestDto.class::cast).map(ReportDefinitionDto::getData).map(SingleReportDataDto::getDefinitions).flatMap(Collection::stream).collect(Collectors.toMap(ReportDataDefinitionDto::getKey, definition -> new HashSet(definition.getTenantIds()), (u, v) -> {
            u.addAll(v);
            return u;
        }));
    }

    private Map<String, Set<String>> validateAccessAndCreateDefinitionTenantMap(String userId, String definitionKey, List<String> tenantIds) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (definitionKey == null) {
            throw new OptimizeRuntimeException("definitionKey is null");
        }
        if (tenantIds == null) {
            throw new OptimizeRuntimeException("tenantIds is null");
        }
        this.validateDefinitionAccess(userId, definitionKey, tenantIds);
        HashMap<String, Set<String>> definitionKeyToTenantsMap = new HashMap<String, Set<String>>();
        definitionKeyToTenantsMap.put(definitionKey, Sets.newHashSet(tenantIds));
        return definitionKeyToTenantsMap;
    }

    private void validateDefinitionAccess(String userId, String processDefinitionKey, List<String> tenantIds) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (!this.definitionAuthorizationService.isAuthorizedToAccessDefinition(userId, DefinitionType.PROCESS, processDefinitionKey, tenantIds)) {
            throw new ForbiddenException("Current user is not authorized to access data of the provided definition or tenants");
        }
    }
}

