/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.oauth;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;

public class RoleValidator
implements OAuth2TokenValidator<Jwt> {
    static final String ORGANIZATION_CLAIM_KEY = "https://camunda.com/orgs";
    private static final Logger LOG = LoggerFactory.getLogger(RoleValidator.class);
    private final List<String> allowedRoles;

    public RoleValidator(List<String> allowedRoles) {
        this.allowedRoles = Objects.requireNonNull(allowedRoles, "allowedRoles must not be null");
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        Collection claimedOrgs;
        Object claimValue = token.getClaims().get(ORGANIZATION_CLAIM_KEY);
        if (claimValue == null) {
            LOG.debug("Rejected token: missing organization claim '{}'", (Object)ORGANIZATION_CLAIM_KEY);
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "Token does not contain required organization claim for Optimize access.", null)});
        }
        if (claimValue instanceof Collection && this.hasAllowedRole(claimedOrgs = (Collection)claimValue)) {
            return OAuth2TokenValidatorResult.success();
        }
        LOG.debug("Rejected token with organizations '{}', required roles: {}", claimValue, this.allowedRoles);
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "Token does not contain required organization role for Optimize access. Required roles: %s".formatted(this.allowedRoles), null)});
    }

    private boolean hasAllowedRole(Collection<?> claimedOrgs) {
        for (Object claimedOrg : claimedOrgs) {
            Map orgDetails;
            Object rolesObj;
            if (!(claimedOrg instanceof Map) || !((rolesObj = (orgDetails = (Map)claimedOrg).get("roles")) instanceof Collection)) continue;
            Collection userRoles = (Collection)rolesObj;
            for (Object userRole : userRoles) {
                if (!(userRole instanceof String) || !this.allowedRoles.contains(userRole)) continue;
                LOG.debug("User has allowed role '{}' for Optimize access", userRole);
                return true;
            }
        }
        return false;
    }
}

