/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.oauth;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class CustomClaimValidator
implements OAuth2TokenValidator<Jwt> {
    private final String claimName;
    private final String expectedClaimValue;
    private final JwtAuthenticationConverter delegate = new JwtAuthenticationConverter();

    public CustomClaimValidator(String claimName, String expectedClaimValue) {
        this.claimName = claimName;
        this.expectedClaimValue = expectedClaimValue;
    }

    public OAuth2TokenValidatorResult validate(Jwt jwt) {
        JwtAuthenticationToken auth = (JwtAuthenticationToken)this.delegate.convert(jwt);
        Map payload = auth.getTokenAttributes();
        return this.isClaimValid(payload);
    }

    private OAuth2TokenValidatorResult isClaimValid(Map<String, Object> payload) {
        String claimValue = this.getClaimValue(payload);
        if (!StringUtils.isBlank((CharSequence)claimValue)) {
            if (claimValue.equals(this.expectedClaimValue)) {
                return OAuth2TokenValidatorResult.success();
            }
            return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("invalid_token", "The claim provided in the token does not match the expected claim", null)});
        }
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{new OAuth2Error("missing_token", "The required claim" + this.claimName + " is missing", null)});
    }

    private String getClaimValue(Map<String, Object> payload) {
        return (String)payload.get(this.claimName);
    }
}

