/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.cloud;

import io.camunda.optimize.rest.security.AbstractSecurityConfigurerAdapter;
import io.camunda.optimize.rest.security.AuthenticationCookieFilter;
import io.camunda.optimize.rest.security.CustomPreAuthenticatedAuthenticationProvider;
import io.camunda.optimize.rest.security.cloud.AuthorizationRequestCookieValueMapper;
import io.camunda.optimize.rest.security.cloud.HttpCookieOAuth2AuthorizationRequestRepository;
import io.camunda.optimize.rest.security.oauth.AudienceValidator;
import io.camunda.optimize.rest.security.oauth.CustomClaimValidator;
import io.camunda.optimize.rest.security.oauth.RoleValidator;
import io.camunda.optimize.rest.security.oauth.ScopeValidator;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import io.camunda.optimize.service.util.configuration.security.CloudAuthConfiguration;
import io.camunda.optimize.tomcat.CCSaasRequestAdjustmentFilter;
import io.camunda.optimize.tomcat.OptimizeResourceConstants;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
@EnableWebSecurity
@Conditional(value={CCSaaSCondition.class})
public class CCSaaSSecurityConfigurerAdapter
extends AbstractSecurityConfigurerAdapter {
    public static final String CAMUNDA_CLUSTER_ID_CLAIM_NAME = "https://camunda.com/clusterId";
    private static final Logger LOG = LoggerFactory.getLogger(CCSaaSSecurityConfigurerAdapter.class);
    private static final List<String> ALLOWED_ORG_ROLES = Arrays.asList("admin", "analyst", "owner");
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final OAuth2AuthorizedClientService oAuth2AuthorizedClientService;

    public CCSaaSSecurityConfigurerAdapter(ConfigurationService configurationService, CustomPreAuthenticatedAuthenticationProvider preAuthenticatedAuthenticationProvider, SessionService sessionService, AuthCookieService authCookieService, ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        super(configurationService, preAuthenticatedAuthenticationProvider, sessionService, authCookieService);
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.oAuth2AuthorizedClientService = oAuth2AuthorizedClientService;
    }

    @Bean
    public AuthenticationCookieFilter authenticationCookieFilter(HttpSecurity http) throws Exception {
        return new AuthenticationCookieFilter(this.sessionService, (AuthenticationManager)((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)).authenticationProvider((AuthenticationProvider)this.preAuthenticatedAuthenticationProvider).build());
    }

    @Bean
    @Order(value=-2147483648)
    FilterRegistrationBean<CCSaasRequestAdjustmentFilter> requestAdjuster() {
        LOG.debug("Registering filter 'requestAdjuster' (SaaS)...");
        CCSaasRequestAdjustmentFilter ccsaasRequestAdjustmentFilter = new CCSaasRequestAdjustmentFilter(this.configurationService.getAuthConfiguration().getCloudAuthConfiguration().getClusterId());
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setOrder(Integer.MIN_VALUE);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setFilter((Filter)ccsaasRequestAdjustmentFilter);
        return registration;
    }

    @Bean
    @Order(value=1)
    protected SecurityFilterChain configurePublicApi(HttpSecurity http) {
        HttpSecurity httpSecurityBuilder = http.securityMatchers(securityMatchers -> securityMatchers.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(PUBLIC_API_PATH), new AntPathRequestMatcher(CCSaaSSecurityConfigurerAdapter.createApiPath("/ingestion", "/variable"))}));
        return this.applyPublicApiOptions(httpSecurityBuilder);
    }

    @Bean
    @Order(value=2)
    protected SecurityFilterChain configureWebSecurity(HttpSecurity http) {
        try {
            return (SecurityFilterChain)super.configureGenericSecurityOptions(http).authorizeHttpRequests(httpRequests -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)httpRequests.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(CCSaaSSecurityConfigurerAdapter.createApiPath("/readyz"))})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/external/"), new AntPathRequestMatcher("/index*"), new AntPathRequestMatcher("/external/index*"), new AntPathRequestMatcher("/static/**"), new AntPathRequestMatcher("/external/static/**"), new AntPathRequestMatcher("/external/*.js"), new AntPathRequestMatcher("/external/*.ico")})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(CCSaaSSecurityConfigurerAdapter.createApiPath("/external/**")), new AntPathRequestMatcher("/external/api/**")})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(CCSaaSSecurityConfigurerAdapter.createApiPath("/ui-configuration")), new AntPathRequestMatcher(CCSaaSSecurityConfigurerAdapter.createApiPath("/localization"))})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(OptimizeResourceConstants.ACTUATOR_ENDPOINT + "/**")})).permitAll().anyRequest()).authenticated()).oauth2Login(oauth2 -> oauth2.clientRegistrationRepository(this.clientRegistrationRepository).authorizedClientService(this.oAuth2AuthorizedClientService).authorizationEndpoint(authorizationEndpointConfig -> authorizationEndpointConfig.baseUri("/sso").authorizationRequestRepository((AuthorizationRequestRepository)this.cookieOAuth2AuthorizationRequestRepository())).redirectionEndpoint(redirectionEndpointConfig -> redirectionEndpointConfig.baseUri("/sso-callback")).successHandler(this.getAuthenticationSuccessHandler())).addFilterBefore((Filter)this.authenticationCookieFilter(http), OAuth2AuthorizationRequestRedirectFilter.class).exceptionHandling(exceptionHandling -> exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new AntPathRequestMatcher("/api/**")).defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new AddClusterIdSubPathToRedirectAuthenticationEntryPoint("/sso/auth0"), (RequestMatcher)new AntPathRequestMatcher("/**"))).oauth2ResourceServer(oauth2resourceServer -> oauth2resourceServer.jwt(jwtConfigurer -> jwtConfigurer.decoder(this.jwtDecoder()))).build();
        }
        catch (Exception e) {
            throw new OptimizeRuntimeException((Throwable)e);
        }
    }

    @Bean
    public HttpCookieOAuth2AuthorizationRequestRepository cookieOAuth2AuthorizationRequestRepository() {
        return new HttpCookieOAuth2AuthorizationRequestRepository(this.configurationService, new AuthorizationRequestCookieValueMapper());
    }

    @Bean
    public JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory() {
        OidcIdTokenDecoderFactory decoderFactory = new OidcIdTokenDecoderFactory();
        decoderFactory.setJwtValidatorFactory(clientRegistration -> this.createIdTokenValidators());
        return decoderFactory;
    }

    private OAuth2TokenValidator<Jwt> createIdTokenValidators() {
        RoleValidator roleValidator = new RoleValidator(ALLOWED_ORG_ROLES);
        return JwtValidators.createDefaultWithValidators((OAuth2TokenValidator[])new OAuth2TokenValidator[]{roleValidator});
    }

    private JwtDecoder jwtDecoder() {
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)this.configurationService.getOptimizeApiConfiguration().getJwtSetUri()).build();
        AudienceValidator audienceValidator = new AudienceValidator(this.configurationService.getAuthConfiguration().getCloudAuthConfiguration().getUserAccessTokenAudience().orElse(""));
        ScopeValidator profileValidator = new ScopeValidator("profile");
        RoleValidator roleValidator = new RoleValidator(ALLOWED_ORG_ROLES);
        OAuth2TokenValidator combinedValidatorWithDefaults = JwtValidators.createDefaultWithValidators((OAuth2TokenValidator[])new OAuth2TokenValidator[]{audienceValidator, profileValidator, roleValidator});
        jwtDecoder.setJwtValidator(combinedValidatorWithDefaults);
        return jwtDecoder;
    }

    @Override
    protected JwtDecoder publicApiJwtDecoder() {
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)this.configurationService.getOptimizeApiConfiguration().getJwtSetUri()).build();
        AudienceValidator audienceValidator = new AudienceValidator(this.getAuth0Configuration().getAudience());
        CustomClaimValidator clusterIdValidator = new CustomClaimValidator(CAMUNDA_CLUSTER_ID_CLAIM_NAME, this.getAuth0Configuration().getClusterId());
        OAuth2TokenValidator combinedValidatorWithDefaults = JwtValidators.createDefaultWithValidators((OAuth2TokenValidator[])new OAuth2TokenValidator[]{audienceValidator, clusterIdValidator});
        jwtDecoder.setJwtValidator(combinedValidatorWithDefaults);
        return jwtDecoder;
    }

    private AuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        return (request, response, authentication) -> {
            DefaultOidcUser user = (DefaultOidcUser)authentication.getPrincipal();
            String userId = user.getIdToken().getSubject();
            String sessionToken = this.sessionService.createAuthToken(userId);
            if (this.hasAccess(user)) {
                OAuth2AccessToken serviceAccessToken = this.oAuth2AuthorizedClientService.loadAuthorizedClient("auth0", userId).getAccessToken();
                Instant cookieExpiryDate = this.determineCookieExpiryDate(sessionToken, serviceAccessToken).orElseThrow(() -> new OptimizeRuntimeException("Could not determine a cookie expiry date. This is likely a bug, please report."));
                this.authCookieService.createOptimizeServiceTokenCookies(serviceAccessToken, cookieExpiryDate, request.getScheme()).forEach(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
                this.authCookieService.createOptimizeAuthCookies(sessionToken, cookieExpiryDate, request.getScheme()).forEach(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
                response.setContentType("text/html");
                response.getWriter().print(String.format("<html>\n  <head><meta http-equiv=\"refresh\" content=\"1; URL='%s/'\"/></head>\n  <body>\n    <script>\n      var path = '%s/';\n      if (location.hash) {\n        path += location.hash;\n      }\n      location = path;\n    </script>\n    <p align=\"center\">Successfully authenticated!</p>\n    <p align=\"center\">Click <a href=\"%s/\">here</a> if you don't get redirected automatically.</p>\n  </body>\n</html>\n", this.getClusterIdPath(), this.getClusterIdPath(), this.getClusterIdPath()));
            } else {
                response.setStatus(HttpStatus.FORBIDDEN.value());
            }
        };
    }

    private Optional<Instant> determineCookieExpiryDate(String sessionToken, OAuth2AccessToken serviceAccessToken) {
        Instant serviceTokenExpiry = serviceAccessToken.getExpiresAt();
        Instant sessionTokenExpiry = this.authCookieService.getOptimizeAuthCookieTokenExpiryDate(sessionToken).orElse(null);
        return Stream.of(serviceTokenExpiry, sessionTokenExpiry).filter(Objects::nonNull).min(Instant::compareTo);
    }

    private boolean hasAccess(DefaultOidcUser user) {
        String organizationClaimName;
        boolean accessGranted = false;
        OidcUserInfo userInfo = user.getUserInfo();
        if (userInfo.getClaim(organizationClaimName = this.getAuth0Configuration().getOrganizationClaimName()) instanceof List) {
            List organisations = (List)userInfo.getClaim(organizationClaimName);
            accessGranted = organisations.stream().map(orgEntry -> (String)orgEntry.get("id")).anyMatch(organisationId -> this.getAuth0Configuration().getOrganizationId().equals(organisationId));
        }
        return accessGranted;
    }

    private String getClusterIdPath() {
        return Optional.ofNullable(this.getAuth0Configuration().getClusterId()).filter(StringUtils::isNotBlank).map(id -> "/" + id).orElse("");
    }

    private CloudAuthConfiguration getAuth0Configuration() {
        return this.configurationService.getAuthConfiguration().getCloudAuthConfiguration();
    }

    public class AddClusterIdSubPathToRedirectAuthenticationEntryPoint
    extends LoginUrlAuthenticationEntryPoint {
        public AddClusterIdSubPathToRedirectAuthenticationEntryPoint(String loginFormUrl) {
            super(loginFormUrl);
        }

        protected String determineUrlToUseForThisRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
            String redirect = super.determineUrlToUseForThisRequest(request, response, exception);
            return UriComponentsBuilder.fromPath((String)(CCSaaSSecurityConfigurerAdapter.this.getClusterIdPath() + redirect)).toUriString();
        }
    }
}

