/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.security.ccsm;

import com.auth0.jwt.exceptions.TokenExpiredException;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.exception.IdentityException;
import io.camunda.optimize.rest.exceptions.NotAuthorizedException;
import io.camunda.optimize.service.security.AuthCookieService;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

@Conditional(value={CCSMCondition.class})
public class CCSMAuthenticationCookieFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private final ConfigurationService configurationService;
    private final CCSMTokenService ccsmTokenService;

    public CCSMAuthenticationCookieFilter(ConfigurationService configurationService, CCSMTokenService ccsmTokenService, AuthenticationManager authenticationManager) {
        this.configurationService = configurationService;
        this.ccsmTokenService = ccsmTokenService;
        this.setAuthenticationManager(authenticationManager);
    }

    public CCSMAuthenticationCookieFilter(ConfigurationService configurationService, CCSMTokenService ccsmTokenService) {
        this.configurationService = configurationService;
        this.ccsmTokenService = ccsmTokenService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Cookie[] cookies = ((HttpServletRequest)request).getCookies();
        if (cookies != null) {
            Map<String, Cookie> cookiesByName = Arrays.stream(cookies).collect(Collectors.toMap(Cookie::getName, Function.identity()));
            try {
                AuthCookieService.extractJoinedCookieValueFromCookies(cookiesByName.values().stream().toList()).ifPresentOrElse(this.ccsmTokenService::verifyToken, () -> this.tryCookieRenewal(request, response, cookiesByName));
            }
            catch (TokenExpiredException expiredException) {
                this.tryCookieRenewal(request, response, cookiesByName);
            }
            catch (IdentityException verificationException) {
                try {
                    Optional.ofNullable((Cookie)cookiesByName.get("X-Optimize-Refresh-Token")).ifPresent(refreshTokenCookie -> this.ccsmTokenService.revokeToken(refreshTokenCookie.getValue()));
                }
                catch (IdentityException identityException) {
                }
                finally {
                    this.deleteCookies(response);
                }
            }
            catch (NotAuthorizedException notAuthorizedException) {
                this.deleteCookies(response);
            }
        }
        super.doFilter(request, response, chain);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        return Optional.ofNullable(request.getCookies()).flatMap(cookies -> AuthCookieService.extractJoinedCookieValueFromCookies(Arrays.asList(cookies)).flatMap(this::validToken).map(this.ccsmTokenService::getSubjectFromToken)).orElseGet(() -> AuthCookieService.getAuthCookieToken(request).flatMap(this::validToken).map(this.ccsmTokenService::getSubjectFromToken).orElse(null));
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return Optional.ofNullable(request.getCookies()).flatMap(cookies -> AuthCookieService.extractJoinedCookieValueFromCookies(Arrays.asList(cookies))).orElseGet(() -> AuthCookieService.getAuthCookieToken(request).orElse(null));
    }

    private Optional<String> validToken(String token) {
        try {
            this.ccsmTokenService.verifyToken(token);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.ofNullable(token);
    }

    private void tryCookieRenewal(ServletRequest request, ServletResponse response, Map<String, Cookie> cookiesByName) {
        Optional.ofNullable(cookiesByName.get("X-Optimize-Refresh-Token")).ifPresent(refreshTokenCookie -> {
            Tokens tokens = this.ccsmTokenService.renewToken(refreshTokenCookie.getValue());
            AccessToken accessToken = this.ccsmTokenService.verifyToken(tokens.getAccessToken());
            int maxCookieLength = this.configurationService.getAuthConfiguration().getCookieConfiguration().getMaxSize();
            String tokenValue = accessToken.getToken().getToken();
            int numberOfCookies = (int)Math.ceil((double)tokenValue.length() / (double)maxCookieLength);
            for (int i = 0; i < numberOfCookies; ++i) {
                request.setAttribute(AuthCookieService.getAuthorizationCookieNameWithSuffix(i), (Object)(i == numberOfCookies - 1 ? tokenValue.substring(i * maxCookieLength) : tokenValue.substring(i * maxCookieLength, i * maxCookieLength + maxCookieLength)));
            }
            this.ccsmTokenService.createOptimizeAuthNewCookies(tokens, accessToken, request.getScheme()).forEach(arg_0 -> ((HttpServletResponse)((HttpServletResponse)response)).addCookie(arg_0));
        });
    }

    private void deleteCookies(ServletResponse response) {
        this.ccsmTokenService.createOptimizeDeleteAuthCookies().forEach(arg_0 -> ((HttpServletResponse)((HttpServletResponse)response)).addCookie(arg_0));
    }
}

