/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.providers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@Order(value=-2147483648)
public class JsonExceptionMapper {
    private static final Logger LOG = LoggerFactory.getLogger(JsonExceptionMapper.class);

    @ExceptionHandler(value={JsonMappingException.class})
    public ResponseEntity<String> handleJsonMappingException(JsonMappingException exception) {
        LOG.debug("Mapping handleJsonMappingException");
        return this.badRequestResponse();
    }

    @ExceptionHandler(value={JsonParseException.class})
    public ResponseEntity<String> handleJsonParseException(JsonParseException exception) {
        LOG.debug("Mapping handleJsonParseException");
        return this.badRequestResponse();
    }

    private ResponseEntity<String> badRequestResponse() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.TEXT_PLAIN).build();
    }
}

