/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.providers;

import io.camunda.optimize.dto.optimize.rest.ErrorResponseDto;
import io.camunda.optimize.service.LocalizationService;
import io.camunda.optimize.service.security.AuthCookieService;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.ResponseStatusException;

@ControllerAdvice
@Order(value=0x7FFFFFFF)
public class GenericExceptionMapper {
    public static final String GENERIC_ERROR_CODE = "serverError";
    public static final String NOT_FOUND_ERROR_CODE = "notFoundError";
    public static final String BAD_REQUEST_ERROR_CODE = "badRequestError";
    private static final String FORBIDDEN_ERROR_CODE = "forbiddenError";
    private static final String NOT_AUTHORIZED_ERROR_CODE = "notAuthorizedError";
    private static final Logger LOG = LoggerFactory.getLogger(GenericExceptionMapper.class);
    private static final Map<HttpStatus, String> HTTP_STATUS_TO_ERROR_CODE = Map.of(HttpStatus.NOT_FOUND, "notFoundError", HttpStatus.BAD_REQUEST, "badRequestError", HttpStatus.FORBIDDEN, "forbiddenError", HttpStatus.UNAUTHORIZED, "notAuthorizedError");
    @Autowired
    private LocalizationService localizationService;
    @Autowired
    private AuthCookieService cookieService;

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<ErrorResponseDto> handleThrowable(Throwable throwable, HttpServletResponse response) {
        ResponseStatusException responseStatusException;
        HttpStatusCode httpStatusCode;
        LOG.error("Mapping generic REST error", throwable);
        HttpStatus status = HttpStatus.INTERNAL_SERVER_ERROR;
        if (throwable instanceof ResponseStatusException && (httpStatusCode = (responseStatusException = (ResponseStatusException)throwable).getStatusCode()) instanceof HttpStatus) {
            HttpStatus httpStatus;
            status = httpStatus = (HttpStatus)httpStatusCode;
        }
        if (status == HttpStatus.UNAUTHORIZED) {
            this.cookieService.createDeleteOptimizeAuthNewCookie(true).forEach(arg_0 -> ((HttpServletResponse)response).addCookie(arg_0));
        }
        String errorCode = HTTP_STATUS_TO_ERROR_CODE.getOrDefault(status, GENERIC_ERROR_CODE);
        String localizedMessage = this.localizationService.getDefaultLocaleMessageForApiErrorCode(errorCode);
        ErrorResponseDto errorResponseDto = new ErrorResponseDto(errorCode, localizedMessage, throwable.getMessage());
        return ResponseEntity.status((HttpStatusCode)status).contentType(MediaType.APPLICATION_JSON).body((Object)errorResponseDto);
    }
}

