/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.providers;

import com.google.common.collect.Iterables;
import io.camunda.optimize.dto.optimize.rest.ValidationErrorResponseDto;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class BeanConstraintViolationExceptionMapper {
    public static final String THE_REQUEST_BODY_WAS_INVALID = "The request body was invalid.";
    private static final Pattern ARG_PATTERN = Pattern.compile("arg\\d");

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<ValidationErrorResponseDto> handleConstraintViolationException(ConstraintViolationException throwable) {
        List<ValidationErrorResponseDto.ValidationError> validationErrors = throwable.getConstraintViolations().stream().map(constraintViolation -> new ValidationErrorResponseDto.ValidationError(this.extractPropertyName((ConstraintViolation<?>)constraintViolation), constraintViolation.getMessage())).collect(Collectors.toList());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)new ValidationErrorResponseDto(THE_REQUEST_BODY_WAS_INVALID, validationErrors));
    }

    private String extractPropertyName(ConstraintViolation<?> constraintViolation) {
        String propertyName = null;
        int pathLength = Iterables.size((Iterable)constraintViolation.getPropertyPath());
        if (pathLength > 2) {
            List propertyNodePath = StreamSupport.stream(Iterables.skip((Iterable)constraintViolation.getPropertyPath(), (int)1).spliterator(), false).filter(node -> node != null && node.getName() != null && !ARG_PATTERN.matcher(node.getName()).matches()).collect(Collectors.toList());
            propertyName = propertyNodePath.stream().map(node -> {
                if (node.isInIterable()) {
                    return String.format("element[%d].%s", node.getIndex(), node);
                }
                return node.toString();
            }).collect(Collectors.joining("."));
        }
        return Optional.ofNullable(propertyName).orElseGet(() -> constraintViolation.getPropertyPath().toString());
    }
}

