/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest.mapper;

import io.camunda.optimize.dto.optimize.query.collection.BaseCollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedCollectionDefinitionRestDto;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CollectionRestMapper {
    private final AbstractIdentityService identityService;

    public CollectionRestMapper(AbstractIdentityService identityService) {
        this.identityService = identityService;
    }

    public void prepareRestResponse(AuthorizedCollectionDefinitionRestDto collectionDefinitionRestDto) {
        this.resolveOwnerAndModifierNames((BaseCollectionDefinitionDto)collectionDefinitionRestDto.getDefinitionDto());
    }

    private void resolveOwnerAndModifierNames(BaseCollectionDefinitionDto collectionDefinitionDto) {
        Optional.ofNullable(collectionDefinitionDto.getOwner()).flatMap(this.identityService::getIdentityNameById).ifPresent(arg_0 -> ((BaseCollectionDefinitionDto)collectionDefinitionDto).setOwner(arg_0));
        Optional.ofNullable(collectionDefinitionDto.getLastModifier()).flatMap(this.identityService::getIdentityNameById).ifPresent(arg_0 -> ((BaseCollectionDefinitionDto)collectionDefinitionDto).setLastModifier(arg_0));
    }
}

