/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.SettingsDto;
import io.camunda.optimize.service.SettingsService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/settings"})
public class SettingsRestService {
    public static final String SETTINGS_PATH = "/settings";
    private final SessionService sessionService;
    private final SettingsService settingsService;

    public SettingsRestService(SessionService sessionService, SettingsService settingsService) {
        this.sessionService = sessionService;
        this.settingsService = settingsService;
    }

    @GetMapping
    public SettingsDto getSettings() {
        return this.settingsService.getSettings();
    }

    @PutMapping
    public void setSettings(@NotNull @RequestBody SettingsDto settingsDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.settingsService.setSettings(userId, settingsDto);
    }
}

