/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.report.AdditionalProcessReportEvaluationFilterDto;
import io.camunda.optimize.dto.optimize.query.report.AuthorizedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictResponseDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationRequestDto;
import io.camunda.optimize.dto.optimize.rest.report.AuthorizedReportEvaluationResponseDto;
import io.camunda.optimize.rest.mapper.ReportRestMapper;
import io.camunda.optimize.rest.queryparam.QueryParamUtil;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.report.ReportEvaluationService;
import io.camunda.optimize.service.report.ReportService;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/report"})
public class ReportRestService {
    public static final String REPORT_PATH = "/report";
    private final ReportService reportService;
    private final ReportEvaluationService reportEvaluationService;
    private final SessionService sessionService;
    private final ReportRestMapper reportRestMapper;

    public ReportRestService(ReportService reportService, ReportEvaluationService reportEvaluationService, SessionService sessionService, ReportRestMapper reportRestMapper) {
        this.reportService = reportService;
        this.reportEvaluationService = reportEvaluationService;
        this.sessionService = sessionService;
        this.reportRestMapper = reportRestMapper;
    }

    @PostMapping(value={"/process/single"})
    public IdResponseDto createNewSingleProcessReport(@Valid @RequestBody SingleProcessReportDefinitionRequestDto definition, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        if (definition != null && definition.getData() != null && (((ProcessReportDataDto)definition.getData()).isManagementReport() || ((ProcessReportDataDto)definition.getData()).isInstantPreviewReport())) {
            throw new OptimizeValidationException("Management or Instant Preview Reports cannot be created manually");
        }
        return this.reportService.createNewSingleProcessReport(userId, Optional.ofNullable(definition).orElseGet(SingleProcessReportDefinitionRequestDto::new));
    }

    @PostMapping(value={"/decision/single/"})
    public IdResponseDto createNewSingleDecisionReport(@Valid @RequestBody SingleDecisionReportDefinitionRequestDto singleDecisionReportDefinitionDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.reportService.createNewSingleDecisionReport(userId, Optional.ofNullable(singleDecisionReportDefinitionDto).orElseGet(SingleDecisionReportDefinitionRequestDto::new));
    }

    @PostMapping(value={"/process/combined/"})
    public IdResponseDto createNewCombinedProcessReport(@RequestBody CombinedReportDefinitionRequestDto combinedReportDefinitionDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.reportService.createNewCombinedProcessReport(userId, Optional.ofNullable(combinedReportDefinitionDto).orElseGet(CombinedReportDefinitionRequestDto::new));
    }

    @PostMapping(value={"/{id}/copy"})
    public IdResponseDto copyReport(@PathVariable(value="id") String id, @RequestParam(name="collectionId", required=false) String collectionId, @RequestParam(name="name", required=false) String newReportName, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        if (collectionId == null) {
            return this.reportService.copyReport(id, userId, newReportName);
        }
        collectionId = QueryParamUtil.normalizeNullStringValue(collectionId);
        return this.reportService.copyAndMoveReport(id, userId, collectionId, newReportName);
    }

    @GetMapping
    public List<AuthorizedReportDefinitionResponseDto> getAuthorizedPrivateReports(HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<AuthorizedReportDefinitionResponseDto> reportDefinitions = this.reportService.findAndFilterPrivateReports(userId);
        reportDefinitions.forEach(authorizedReportDefinitionDto -> this.reportRestMapper.prepareLocalizedRestResponse((AuthorizedReportDefinitionResponseDto)authorizedReportDefinitionDto, request.getHeader("X-Optimize-Client-Locale")));
        return reportDefinitions;
    }

    @GetMapping(value={"/{id}"})
    public AuthorizedReportDefinitionResponseDto getReport(@PathVariable(value="id") String reportId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        AuthorizedReportDefinitionResponseDto reportDefinition = this.reportService.getReportDefinition(reportId, userId);
        this.reportRestMapper.prepareLocalizedRestResponse(reportDefinition, request.getHeader("X-Optimize-Client-Locale"));
        return reportDefinition;
    }

    @PostMapping(value={"/{id}/evaluate"})
    public AuthorizedReportEvaluationResponseDto evaluateReportByIdWithFilters(@PathVariable(value="id") String reportId, @Valid PaginationRequestDto paginationRequestDto, @RequestBody AdditionalProcessReportEvaluationFilterDto reportEvaluationFilter, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        ZoneId timezone = TimeZoneUtil.extractTimezone(request);
        AuthorizedReportEvaluationResult reportEvaluationResult = this.reportEvaluationService.evaluateSavedReportWithAdditionalFilters(userId, timezone, reportId, reportEvaluationFilter, PaginationDto.fromPaginationRequest((PaginationRequestDto)paginationRequestDto));
        return this.reportRestMapper.mapToLocalizedEvaluationResponseDto(reportEvaluationResult, request.getHeader("X-Optimize-Client-Locale"));
    }

    @PostMapping(value={"/evaluate"})
    public AuthorizedReportEvaluationResponseDto evaluateProvidedReport(@Valid @RequestBody ReportDefinitionDto reportDefinitionDto, @Valid PaginationRequestDto paginationRequestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        if (reportDefinitionDto instanceof SingleProcessReportDefinitionRequestDto && ((ProcessReportDataDto)((SingleProcessReportDefinitionRequestDto)reportDefinitionDto).getData()).isManagementReport()) {
            throw new OptimizeValidationException("Unsaved Management Reports cannot be evaluated");
        }
        ZoneId timezone = TimeZoneUtil.extractTimezone(request);
        AuthorizedReportEvaluationResult reportEvaluationResult = this.reportEvaluationService.evaluateUnsavedReport(userId, timezone, reportDefinitionDto, PaginationDto.fromPaginationRequest((PaginationRequestDto)paginationRequestDto));
        return this.reportRestMapper.mapToLocalizedEvaluationResponseDto(reportEvaluationResult, request.getHeader("X-Optimize-Client-Locale"));
    }

    @PutMapping(value={"/process/single/{id}"})
    public void updateSingleProcessReport(@PathVariable(value="id") String reportId, @RequestParam(name="force", required=false) boolean force, @RequestBody @Valid SingleProcessReportDefinitionRequestDto updatedReport, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        @Valid ProcessReportDataDto reportData = (ProcessReportDataDto)updatedReport.getData();
        if (reportData != null && (reportData.isManagementReport() || reportData.isInstantPreviewReport())) {
            throw new OptimizeValidationException("Existing Reports cannot be set as Management/Instant Preview Reports");
        }
        updatedReport.setId(reportId);
        updatedReport.setLastModifier(userId);
        updatedReport.setLastModified(LocalDateUtil.getCurrentDateTime());
        this.reportService.updateSingleProcessReport(reportId, updatedReport, userId, force);
    }

    @PutMapping(value={"/decision/single/{id}"})
    public void updateSingleDecisionReport(@PathVariable(value="id") String reportId, @RequestParam(name="force", required=false) boolean force, @RequestBody @Valid SingleDecisionReportDefinitionRequestDto updatedReport, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        updatedReport.setId(reportId);
        updatedReport.setLastModifier(userId);
        updatedReport.setLastModified(LocalDateUtil.getCurrentDateTime());
        this.reportService.updateSingleDecisionReport(reportId, updatedReport, userId, force);
    }

    @PutMapping(value={"/process/combined/{id}"})
    public void updateCombinedProcessReport(@PathVariable(value="id") String reportId, @RequestParam(name="force", required=false) boolean force, @RequestBody CombinedReportDefinitionRequestDto updatedReport, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        updatedReport.setId(reportId);
        updatedReport.setLastModifier(userId);
        updatedReport.setLastModified(LocalDateUtil.getCurrentDateTime());
        this.reportService.updateCombinedProcessReport(userId, reportId, updatedReport);
    }

    @GetMapping(value={"/{id}/delete-conflicts"})
    public ConflictResponseDto getDeleteConflicts(@PathVariable(value="id") String reportId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.reportService.getReportDeleteConflictingItems(userId, reportId);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteReport(@PathVariable(value="id") String reportId, @RequestParam(name="force", required=false) boolean force, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.reportService.deleteReportAsUser(userId, reportId, force);
    }
}

