/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.variable.DefinitionVariableLabelsDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableReportValuesRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableValueRequestDto;
import io.camunda.optimize.dto.optimize.rest.GetVariableNamesForReportsRequestDto;
import io.camunda.optimize.rest.util.TimeZoneUtil;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.variable.ProcessVariableLabelService;
import io.camunda.optimize.service.variable.ProcessVariableService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/variables"})
public class ProcessVariableRestService {
    public static final String PROCESS_VARIABLES_PATH = "/variables";
    private final ProcessVariableService processVariableService;
    private final SessionService sessionService;
    private final ProcessVariableLabelService processVariableLabelService;

    public ProcessVariableRestService(ProcessVariableService processVariableService, SessionService sessionService, ProcessVariableLabelService processVariableLabelService) {
        this.processVariableService = processVariableService;
        this.sessionService = sessionService;
        this.processVariableLabelService = processVariableLabelService;
    }

    @PostMapping
    public List<ProcessVariableNameResponseDto> getVariableNames(@Valid @RequestBody ProcessVariableNameRequestDto variableRequestDto, HttpServletRequest request) {
        variableRequestDto.setTimezone(TimeZoneUtil.extractTimezone(request));
        return this.processVariableService.getVariableNames(variableRequestDto);
    }

    @PostMapping(value={"/reports"})
    public List<ProcessVariableNameResponseDto> getVariableNamesForReports(@RequestBody GetVariableNamesForReportsRequestDto requestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.processVariableService.getVariableNamesForAuthorizedReports(userId, requestDto.getReportIds());
    }

    @PostMapping(value={"/values"})
    public List<String> getVariableValues(@RequestBody ProcessVariableValueRequestDto variableValueRequestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.processVariableService.getVariableValues(userId, variableValueRequestDto);
    }

    @PostMapping(value={"/values/reports"})
    public List<String> getVariableValuesForReports(@RequestBody ProcessVariableReportValuesRequestDto requestDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.processVariableService.getVariableValuesForReports(userId, requestDto);
    }

    @PostMapping(value={"/labels"})
    public void modifyVariableLabels(@Valid @RequestBody DefinitionVariableLabelsDto definitionVariableLabelsDto) {
        this.processVariableLabelService.storeVariableLabels(definitionVariableLabelsDto);
    }
}

