/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.ReportConstants;
import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableRequestDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.rest.exceptions.BadRequestException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.VariableHelper;
import io.camunda.optimize.service.variable.ExternalVariableService;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/ingestion"})
public class IngestionRestService {
    public static final String INGESTION_PATH = "/ingestion";
    public static final String VARIABLE_SUB_PATH = "/variable";
    private static final Logger LOG = LoggerFactory.getLogger(IngestionRestService.class);
    private final ExternalVariableService externalVariableService;

    public IngestionRestService(ExternalVariableService externalVariableService) {
        this.externalVariableService = externalVariableService;
    }

    @PostMapping(value={"/variable"})
    public void ingestVariables(@NotNull @Valid @RequestBody List<ExternalProcessVariableRequestDto> variableDtos) {
        this.validateVariableType(variableDtos);
        this.externalVariableService.storeExternalProcessVariables(ExternalProcessVariableRequestDto.toExternalProcessVariableDtos((Long)LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), variableDtos));
    }

    private void validateVariableType(List<ExternalProcessVariableRequestDto> variables) {
        if (variables.stream().anyMatch(variable -> !VariableHelper.isProcessVariableTypeSupported((VariableType)variable.getType()))) {
            throw new BadRequestException(String.format("A given variable type is not supported. The type must always be one of: %s", ReportConstants.ALL_SUPPORTED_PROCESS_VARIABLE_TYPES));
        }
    }
}

