/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardReportTileDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardTileType;
import io.camunda.optimize.dto.optimize.rest.AuthorizedDashboardDefinitionResponseDto;
import io.camunda.optimize.rest.mapper.DashboardRestMapper;
import io.camunda.optimize.rest.queryparam.QueryParamUtil;
import io.camunda.optimize.service.dashboard.DashboardService;
import io.camunda.optimize.service.dashboard.InstantPreviewDashboardService;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/dashboard"})
public class DashboardRestService {
    public static final String DASHBOARD_PATH = "/dashboard";
    public static final String INSTANT_PREVIEW_PATH = "/instant";
    private final DashboardService dashboardService;
    private final InstantPreviewDashboardService instantPreviewDashboardService;
    private final SessionService sessionService;
    private final DashboardRestMapper dashboardRestMapper;

    public DashboardRestService(DashboardService dashboardService, InstantPreviewDashboardService instantPreviewDashboardService, SessionService sessionService, DashboardRestMapper dashboardRestMapper) {
        this.dashboardService = dashboardService;
        this.instantPreviewDashboardService = instantPreviewDashboardService;
        this.sessionService = sessionService;
        this.dashboardRestMapper = dashboardRestMapper;
    }

    @PostMapping
    public IdResponseDto createNewDashboard(@Valid @RequestBody DashboardDefinitionRestDto dashboardDefinitionDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        if (dashboardDefinitionDto != null) {
            if (dashboardDefinitionDto.isManagementDashboard() || dashboardDefinitionDto.isInstantPreviewDashboard()) {
                throw new OptimizeValidationException("Management and Instant preview dashboards cannot be created");
            }
            this.validateDashboard(dashboardDefinitionDto);
        }
        return this.dashboardService.createNewDashboardAndReturnId(userId, Optional.ofNullable(dashboardDefinitionDto).orElseGet(DashboardDefinitionRestDto::new));
    }

    @PostMapping(path={"/{id}/copy"})
    public IdResponseDto copyDashboard(@PathVariable(value="id") String dashboardId, @RequestParam(name="collectionId", required=false) String collectionId, @RequestParam(name="name", required=false) String newDashboardName, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        if (collectionId == null) {
            return this.dashboardService.copyDashboard(dashboardId, userId, newDashboardName);
        }
        collectionId = QueryParamUtil.normalizeNullStringValue(collectionId);
        return this.dashboardService.copyAndMoveDashboard(dashboardId, userId, collectionId, newDashboardName);
    }

    @GetMapping(path={"/{id}"})
    public AuthorizedDashboardDefinitionResponseDto getDashboard(@PathVariable(name="id") String dashboardId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        AuthorizedDashboardDefinitionResponseDto dashboardDefinition = this.dashboardService.getDashboardDefinition(dashboardId, userId);
        this.dashboardRestMapper.prepareRestResponse(dashboardDefinition, request.getHeader("X-Optimize-Client-Locale"));
        return dashboardDefinition;
    }

    @GetMapping(path={"/instant/{procDefKey}"})
    public AuthorizedDashboardDefinitionResponseDto getInstantDashboard(@PathVariable(value="procDefKey") String processDefinitionKey, @RequestParam(name="template", required=false) String dashboardJsonTemplateFilename, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        AuthorizedDashboardDefinitionResponseDto dashboardDefinition = this.instantPreviewDashboardService.getInstantPreviewDashboard(processDefinitionKey, dashboardJsonTemplateFilename, userId);
        this.dashboardRestMapper.prepareRestResponse(dashboardDefinition, request.getHeader("X-Optimize-Client-Locale"));
        return dashboardDefinition;
    }

    @GetMapping(path={"/management"})
    public AuthorizedDashboardDefinitionResponseDto getManagementDashboard(HttpServletRequest request) {
        AuthorizedDashboardDefinitionResponseDto dashboardDefinition = this.dashboardService.getManagementDashboard();
        this.dashboardRestMapper.prepareRestResponse(dashboardDefinition, request.getHeader("X-Optimize-Client-Locale"));
        return dashboardDefinition;
    }

    @PutMapping(path={"/{id}"})
    public void updateDashboard(@PathVariable(value="id") String dashboardId, @Valid @RequestBody DashboardDefinitionRestDto updatedDashboard, HttpServletRequest request) {
        updatedDashboard.setId(dashboardId);
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.validateDashboard(updatedDashboard);
        this.dashboardService.updateDashboard(updatedDashboard, userId);
    }

    @DeleteMapping(path={"/{id}"})
    public void deleteDashboard(@PathVariable(value="id") String dashboardId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.dashboardService.deleteDashboardAsUser(dashboardId, userId);
    }

    private void validateDashboardTileTypes(DashboardDefinitionRestDto dashboardDefinitionDto) {
        dashboardDefinitionDto.getTiles().forEach(report -> {
            if (report.getType() == DashboardTileType.OPTIMIZE_REPORT) {
                if (StringUtils.isEmpty((CharSequence)report.getId())) {
                    throw new OptimizeValidationException("All Optimize Reports must have an ID");
                }
            } else if (!StringUtils.isEmpty((CharSequence)report.getId())) {
                throw new OptimizeValidationException("Text and external URL tiles must not have an ID");
            }
        });
    }

    private void validateDashboard(DashboardDefinitionRestDto updatedDashboard) {
        this.validateDashboardTileTypes(updatedDashboard);
        this.validateExternalDashboardLinks(updatedDashboard);
        this.dashboardService.validateDashboardDescription(updatedDashboard.getDescription());
    }

    private void validateExternalDashboardLinks(DashboardDefinitionRestDto dashboardDefinitionDto) {
        List<String> invalidExternalLinks = dashboardDefinitionDto.getTiles().stream().filter(dashboard -> dashboard.getType() == DashboardTileType.EXTERNAL_URL).map(DashboardReportTileDto::getConfiguration).filter(Objects::nonNull).filter(Map.class::isInstance).map(Map.class::cast).map(reportConfig -> reportConfig.get("external")).filter(Objects::nonNull).filter(String.class::isInstance).map(String.class::cast).filter(externalLinkString -> !this.isValidURL((String)externalLinkString)).toList();
        if (!invalidExternalLinks.isEmpty()) {
            throw new OptimizeValidationException("Cannot save dashboard as the following external links are invalid: " + String.valueOf(invalidExternalLinks));
        }
    }

    private boolean isValidURL(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
    }
}

