/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.alert.AlertDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleResponseDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleUpdateRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryUpdateDto;
import io.camunda.optimize.dto.optimize.query.collection.PartialCollectionDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.entity.EntityResponseDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.rest.AuthorizedCollectionDefinitionRestDto;
import io.camunda.optimize.dto.optimize.rest.AuthorizedReportDefinitionResponseDto;
import io.camunda.optimize.dto.optimize.rest.ConflictResponseDto;
import io.camunda.optimize.dto.optimize.rest.collection.CollectionScopeEntryResponseDto;
import io.camunda.optimize.dto.optimize.rest.sorting.EntitySorter;
import io.camunda.optimize.rest.mapper.AlertRestMapper;
import io.camunda.optimize.rest.mapper.CollectionRestMapper;
import io.camunda.optimize.rest.mapper.EntityRestMapper;
import io.camunda.optimize.rest.mapper.ReportRestMapper;
import io.camunda.optimize.service.collection.CollectionEntityService;
import io.camunda.optimize.service.collection.CollectionRoleService;
import io.camunda.optimize.service.collection.CollectionScopeService;
import io.camunda.optimize.service.collection.CollectionService;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.security.SessionService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/collection"})
public class CollectionRestService {
    public static final String COLLECTION_PATH = "/collection";
    private final SessionService sessionService;
    private final CollectionService collectionService;
    private final AuthorizedCollectionService authorizedCollectionService;
    private final CollectionRoleService collectionRoleService;
    private final CollectionScopeService collectionScopeService;
    private final CollectionEntityService collectionEntityService;
    private final ReportRestMapper reportRestMapper;
    private final CollectionRestMapper collectionRestMapper;
    private final AlertRestMapper alertRestMapper;
    private final EntityRestMapper entityRestMapper;

    public CollectionRestService(SessionService sessionService, CollectionService collectionService, AuthorizedCollectionService authorizedCollectionService, CollectionRoleService collectionRoleService, CollectionScopeService collectionScopeService, CollectionEntityService collectionEntityService, ReportRestMapper reportRestMapper, CollectionRestMapper collectionRestMapper, AlertRestMapper alertRestMapper, EntityRestMapper entityRestMapper) {
        this.sessionService = sessionService;
        this.collectionService = collectionService;
        this.authorizedCollectionService = authorizedCollectionService;
        this.collectionRoleService = collectionRoleService;
        this.collectionScopeService = collectionScopeService;
        this.collectionEntityService = collectionEntityService;
        this.reportRestMapper = reportRestMapper;
        this.collectionRestMapper = collectionRestMapper;
        this.alertRestMapper = alertRestMapper;
        this.entityRestMapper = entityRestMapper;
    }

    @PostMapping
    public IdResponseDto createNewCollection(@RequestBody PartialCollectionDefinitionRequestDto partialCollectionDefinitionDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.collectionService.createNewCollectionAndReturnId(userId, Optional.ofNullable(partialCollectionDefinitionDto).orElse(new PartialCollectionDefinitionRequestDto()));
    }

    @GetMapping(value={"/{id}"})
    public AuthorizedCollectionDefinitionRestDto getCollection(@PathVariable(value="id") String collectionId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        AuthorizedCollectionDefinitionRestDto authorizedCollectionDefinitionRestDto = this.collectionService.getCollectionDefinitionRestDto(userId, collectionId);
        this.collectionRestMapper.prepareRestResponse(authorizedCollectionDefinitionRestDto);
        return authorizedCollectionDefinitionRestDto;
    }

    @PutMapping(value={"/{id}"})
    public void updateCollectionPartial(@PathVariable(value="id") String collectionId, @NotNull @RequestBody PartialCollectionDefinitionRequestDto updatedCollection, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.collectionService.updatePartialCollection(userId, collectionId, updatedCollection);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteCollection(@PathVariable(value="id") String collectionId, @RequestParam(name="force", required=false) boolean force, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.collectionService.deleteCollection(userId, collectionId, force);
    }

    @PutMapping(value={"/{id}/scope"})
    public void addScopeEntries(@PathVariable(value="id") String collectionId, @NotNull @RequestBody List<CollectionScopeEntryDto> scopeUpdates, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.collectionScopeService.addScopeEntriesToCollection(userId, collectionId, scopeUpdates);
    }

    @DeleteMapping(value={"/{id}/scope/{scopeEntryId}"})
    public void deleteScopeEntry(@PathVariable(value="id") String collectionId, @PathVariable(value="scopeEntryId") String scopeEntryId, @RequestParam(name="force", required=false) boolean force, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.collectionScopeService.deleteScopeEntry(userId, collectionId, scopeEntryId, force);
    }

    @GetMapping(value={"/{id}/scope/{scopeEntryId}/delete-conflicts"})
    public ConflictResponseDto getScopeDeleteConflicts(@PathVariable(value="id") String collectionId, @PathVariable(value="scopeEntryId") String scopeEntryId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return new ConflictResponseDto(this.collectionScopeService.getAllConflictsOnScopeDeletion(userId, collectionId, scopeEntryId));
    }

    @PutMapping(value={"/{id}/scope/{scopeEntryId}"})
    public void updateScopeEntry(@PathVariable(value="id") String collectionId, @NotNull CollectionScopeEntryUpdateDto entryDto, @PathVariable(value="scopeEntryId") String scopeEntryId, @RequestParam(name="force", required=false) boolean force, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.collectionScopeService.updateScopeEntry(userId, collectionId, entryDto, scopeEntryId, force);
    }

    @GetMapping(value={"/{id}/scope"})
    public List<CollectionScopeEntryResponseDto> getScopes(@PathVariable(value="id") String collectionId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.collectionScopeService.getCollectionScope(userId, collectionId);
    }

    @GetMapping(value={"/{id}/role"})
    public List<CollectionRoleResponseDto> getRoles(@PathVariable(value="id") String collectionId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.collectionRoleService.getAllRolesOfCollectionSorted(userId, collectionId);
    }

    @PostMapping(value={"/{id}/role"})
    public void addRoles(@PathVariable(value="id") String collectionId, @NotNull @RequestBody List<CollectionRoleRequestDto> rolesToAdd, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.collectionRoleService.addRolesToCollection(userId, collectionId, rolesToAdd);
    }

    @PutMapping(value={"/{id}/role/{roleEntryId}"})
    public void updateRole(@PathVariable(value="id") String collectionId, @PathVariable(value="roleEntryId") String roleEntryId, @NotNull @RequestBody CollectionRoleUpdateRequestDto roleUpdateDto, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.authorizedCollectionService.verifyUserAuthorizedToEditCollectionRole(userId, collectionId, roleEntryId);
        this.collectionRoleService.updateRoleOfCollection(userId, collectionId, roleEntryId, roleUpdateDto);
    }

    @PostMapping(value={"/{id}/copy"})
    public IdResponseDto copyCollection(@PathVariable(value="id") String collectionId, @RequestParam(name="name", required=false) String newCollectionName, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.collectionService.copyCollection(userId, collectionId, newCollectionName);
    }

    @DeleteMapping(value={"/{id}/role/{roleEntryId}"})
    public void removeRole(@PathVariable(value="id") String collectionId, @PathVariable(value="roleEntryId") String roleEntryId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.authorizedCollectionService.verifyUserAuthorizedToEditCollectionRole(userId, collectionId, roleEntryId);
        this.collectionRoleService.removeRoleFromCollectionUnlessIsLastManager(userId, collectionId, roleEntryId);
    }

    @GetMapping(value={"/{id}/alerts"})
    public List<AlertDefinitionDto> getAlerts(@PathVariable(value="id") String collectionId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<AlertDefinitionDto> alerts = this.collectionEntityService.getStoredAlertsForCollection(userId, collectionId);
        alerts.forEach(this.alertRestMapper::prepareRestResponse);
        return alerts;
    }

    @GetMapping(value={"/{id}/reports"})
    public List<AuthorizedReportDefinitionResponseDto> getReports(@PathVariable(value="id") String collectionId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<AuthorizedReportDefinitionResponseDto> reports = this.collectionEntityService.findAndFilterReports(userId, collectionId);
        reports.forEach(authorizedReportDefinitionDto -> this.reportRestMapper.prepareLocalizedRestResponse((AuthorizedReportDefinitionResponseDto)authorizedReportDefinitionDto, request.getHeader("X-Optimize-Client-Locale")));
        return reports;
    }

    @GetMapping(value={"/{id}/entities"})
    public List<EntityResponseDto> getEntities(@PathVariable(value="id") String collectionId, @RequestParam(name="sortBy", required=false) String sortBy, @RequestParam(name="sortOrder", required=false) SortOrder sortOrder, HttpServletRequest request) {
        EntitySorter entitySorter = new EntitySorter(sortBy, sortOrder);
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        List<EntityResponseDto> entities = this.collectionEntityService.getAuthorizedCollectionEntities(userId, collectionId);
        entities.forEach(this.entityRestMapper::prepareRestResponse);
        return entitySorter.applySort(entities);
    }

    @PostMapping(value={"/{id}/scope/delete-conflicts"})
    public boolean checkCollectionScopeConflicts(@PathVariable(value="id") String collectionId, @RequestBody List<String> collectionScopeIds, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.collectionScopeService.hasConflictsForCollectionScopeDelete(userId, collectionId, collectionScopeIds);
    }

    @PostMapping(value={"/{id}/roles/delete"})
    public void bulkRemoveCollectionRoles(@PathVariable(value="id") String collectionId, @NotNull @RequestBody List<String> roleEntryIds, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.collectionRoleService.removeRolesFromCollection(userId, collectionId, roleEntryIds);
    }

    @PostMapping(value={"/{id}/scope/delete"})
    public void bulkDeleteCollectionScopes(@PathVariable(value="id") String collectionId, @NotNull @RequestBody List<String> collectionScopeIds, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.collectionScopeService.bulkDeleteCollectionScopes(userId, collectionId, collectionScopeIds);
    }
}

