/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.rest;

import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.alert.AlertCreationRequestDto;
import io.camunda.optimize.service.alert.AlertService;
import io.camunda.optimize.service.security.SessionService;
import io.camunda.optimize.service.util.ValidationHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/api/alert"})
public class AlertRestService {
    public static final String ALERT_PATH = "/alert";
    private final AlertService alertService;
    private final SessionService sessionService;

    public AlertRestService(AlertService alertService, SessionService sessionService) {
        this.alertService = alertService;
        this.sessionService = sessionService;
    }

    @PostMapping
    public IdResponseDto createAlert(@RequestBody AlertCreationRequestDto toCreate, HttpServletRequest request) {
        ValidationHelper.ensureNotNull("creation object", toCreate);
        String user = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        return this.alertService.createAlert(toCreate, user);
    }

    @PutMapping(value={"/{id}"})
    public void updateAlert(@PathVariable(value="id") String alertId, @RequestBody AlertCreationRequestDto toCreate, HttpServletRequest request) {
        ValidationHelper.ensureNotNull("creation object", toCreate);
        String user = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.alertService.updateAlert(alertId, toCreate, user);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteAlert(@PathVariable(value="id") String alertId, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.alertService.deleteAlert(alertId, userId);
    }

    @PostMapping(value={"/delete"})
    public void deleteAlerts(@NotNull @RequestBody List<String> alertIds, HttpServletRequest request) {
        String userId = this.sessionService.getRequestUserOrFailNotAuthorized(request);
        this.alertService.deleteAlerts(alertIds, userId);
    }
}

