/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.rest.export.dashboard;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.optimize.dto.optimize.query.dashboard.DashboardDefinitionRestDto;
import io.camunda.optimize.dto.optimize.query.dashboard.filter.DashboardFilterDto;
import io.camunda.optimize.dto.optimize.query.dashboard.tile.DashboardReportTileDto;
import io.camunda.optimize.dto.optimize.rest.export.ExportEntityType;
import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.service.util.IdGenerator;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DashboardDefinitionExportDto
extends OptimizeEntityExportDto {
    @NotNull
    private List<DashboardReportTileDto> tiles = new ArrayList<DashboardReportTileDto>();
    @NotNull
    private List<DashboardFilterDto<?>> availableFilters = new ArrayList();
    private String collectionId;
    private boolean isInstantPreviewDashboard = false;

    public DashboardDefinitionExportDto(DashboardDefinitionRestDto dashboardDefinition) {
        super(dashboardDefinition.getId(), ExportEntityType.DASHBOARD, dashboardDefinition.getName(), dashboardDefinition.getDescription(), 8);
        this.tiles = dashboardDefinition.getTiles();
        this.availableFilters = dashboardDefinition.getAvailableFilters();
        this.collectionId = dashboardDefinition.getCollectionId();
    }

    public DashboardDefinitionExportDto() {
    }

    @JsonIgnore
    public Set<String> getTileIds() {
        return this.tiles.stream().map(DashboardReportTileDto::getId).filter(IdGenerator::isValidId).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<String> getExternalResourceUrls() {
        return this.tiles.stream().map(DashboardReportTileDto::getId).filter(id -> !IdGenerator.isValidId((String)id)).collect(Collectors.toSet());
    }

    @NotNull
    public List<DashboardReportTileDto> getTiles() {
        return this.tiles;
    }

    public void setTiles(@NotNull List<DashboardReportTileDto> tiles) {
        this.tiles = tiles;
    }

    @NotNull
    public List<DashboardFilterDto<?>> getAvailableFilters() {
        return this.availableFilters;
    }

    public void setAvailableFilters(@NotNull List<DashboardFilterDto<?>> availableFilters) {
        this.availableFilters = availableFilters;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public boolean isInstantPreviewDashboard() {
        return this.isInstantPreviewDashboard;
    }

    public void setInstantPreviewDashboard(boolean isInstantPreviewDashboard) {
        this.isInstantPreviewDashboard = isInstantPreviewDashboard;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashboardDefinitionExportDto;
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    @Override
    public String toString() {
        return "DashboardDefinitionExportDto(tiles=" + String.valueOf(this.getTiles()) + ", availableFilters=" + String.valueOf(this.getAvailableFilters()) + ", collectionId=" + this.getCollectionId() + ", isInstantPreviewDashboard=" + this.isInstantPreviewDashboard() + ")";
    }

    public static final class Fields {
        public static final String tiles = "tiles";
        public static final String availableFilters = "availableFilters";
        public static final String collectionId = "collectionId";
        public static final String isInstantPreviewDashboard = "isInstantPreviewDashboard";
    }
}

