/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.query.report;

import com.google.common.collect.Sets;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.ReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.SingleReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.ResultType;
import io.camunda.optimize.dto.optimize.query.report.single.result.hyper.MapResultEntryDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginatedDataExportDto;
import io.camunda.optimize.service.db.report.result.MapCommandResult;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.export.CSVUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedReportEvaluationResult
extends ReportEvaluationResult {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedReportEvaluationResult.class);
    private List<SingleReportEvaluationResult<?>> reportEvaluationResults;
    private long instanceCount;

    public CombinedReportEvaluationResult(List<SingleReportEvaluationResult<?>> singleReportResults, long instanceCount, CombinedReportDefinitionRequestDto reportDefinition) {
        super((ReportDefinitionDto)reportDefinition);
        if (singleReportResults == null) {
            throw new IllegalArgumentException("singleReportResults cannot be null");
        }
        if (reportDefinition == null) {
            throw new IllegalArgumentException("reportDefinition cannot be null");
        }
        this.reportEvaluationResults = new ArrayList(singleReportResults);
        this.instanceCount = instanceCount;
    }

    public List<String[]> getResultAsCsv(Integer limit, Integer offset, ZoneId timezone) {
        Optional<ResultType> resultType = this.reportEvaluationResults.stream().findFirst().map(thing -> thing.getFirstCommandResult().getType());
        return resultType.map(r -> this.mapCombinedReportResultsToCsvList(limit, offset, (ResultType)r)).orElseGet(() -> {
            LOG.debug("No reports to evaluate are available in the combined report. Returning empty csv instead.");
            return Collections.singletonList(new String[0]);
        });
    }

    public PaginatedDataExportDto getResult() {
        throw new OptimizeValidationException("Combined reports cannot be exported");
    }

    protected boolean canEqual(Object other) {
        return other instanceof CombinedReportEvaluationResult;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "CombinedReportEvaluationResult(reportEvaluationResults=" + String.valueOf(this.getReportEvaluationResults()) + ", instanceCount=" + this.getInstanceCount() + ")";
    }

    private List<String[]> mapCombinedReportResultsToCsvList(Integer limit, Integer offset, ResultType resultType) {
        return switch (resultType) {
            case ResultType.MAP -> this.mapCombinedMapReportResultsToCsvList(limit, offset);
            case ResultType.NUMBER -> this.mapCombinedNumberReportResultsToCsvList();
            default -> {
                String message = String.format("Unsupported report type [%s] in combined report", resultType.getClass().getSimpleName());
                LOG.error(message);
                throw new OptimizeRuntimeException(message);
            }
        };
    }

    /*
     * Exception decompiling
     */
    private List<String[]> mapCombinedMapReportResultsToCsvList(Integer limit, Integer offset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<List<String[]>> extractListOfReportResultTables(Integer limit, Integer offset, List<SingleReportEvaluationResult<List<MapResultEntryDto>>> mapReportResults) {
        Set<String> allLabels = this.collectAllLabels(mapReportResults);
        ArrayList<List<String[]>> reportResultTable = new ArrayList<List<String[]>>();
        mapReportResults.forEach(singleResult -> {
            List data = (List)singleResult.getFirstCommandResult().getFirstMeasureData();
            Set labelsInData = data.stream().map(MapResultEntryDto::getLabel).collect(Collectors.toSet());
            Sets.SetView newLabels = Sets.difference((Set)allLabels, labelsInData);
            ArrayList<MapResultEntryDto> enrichedData = new ArrayList<MapResultEntryDto>(data);
            newLabels.forEach(newLabel -> enrichedData.add(new MapResultEntryDto(newLabel, null, newLabel)));
            enrichedData.sort(Comparator.comparing(MapResultEntryDto::getLabel, String.CASE_INSENSITIVE_ORDER));
            List<String[]> singleReportTable = CSVUtils.map(enrichedData, limit, offset);
            new MapCommandResult(singleResult.getFirstCommandResult().getMeasures(), (SingleReportDataDto)singleResult.getReportDefinition().getData()).addCsvHeader(singleReportTable);
            reportResultTable.add(singleReportTable);
        });
        return reportResultTable;
    }

    private Set<String> collectAllLabels(List<SingleReportEvaluationResult<List<MapResultEntryDto>>> reportResults) {
        return reportResults.stream().map(SingleReportEvaluationResult::getFirstCommandResult).flatMap(r -> ((List)r.getFirstMeasureData()).stream()).map(MapResultEntryDto::getLabel).collect(Collectors.toSet());
    }

    public List<SingleReportEvaluationResult<?>> getReportEvaluationResults() {
        return this.reportEvaluationResults;
    }

    public void setReportEvaluationResults(List<SingleReportEvaluationResult<?>> reportEvaluationResults) {
        if (reportEvaluationResults == null) {
            throw new IllegalArgumentException("reportEvaluationResults cannot be null");
        }
        this.reportEvaluationResults = reportEvaluationResults;
    }

    public long getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(long instanceCount) {
        this.instanceCount = instanceCount;
    }

    /*
     * Exception decompiling
     */
    private List<String[]> mapCombinedNumberReportResultsToCsvList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String[]> mergeSingleReportsToOneCsv(List<List<String[]>> allSingleReportsAsCsvList) {
        return (List)allSingleReportsAsCsvList.stream().reduce((l1, l2) -> {
            for (int i = 0; i < l1.size(); ++i) {
                Object[] firstReportWithSeparatorColumn = (String[])ArrayUtils.addAll((Object[])((String[])l1.get(i)), (Object[])new String[]{""});
                l1.set(i, (String[])ArrayUtils.addAll((Object[])firstReportWithSeparatorColumn, (Object[])((String[])l2.get(i))));
            }
            return l1;
        }).orElseThrow(() -> {
            String message = "Was not able to merge single reports to combined report csv";
            LOG.error("Was not able to merge single reports to combined report csv");
            return new OptimizeRuntimeException("Was not able to merge single reports to combined report csv");
        });
    }

    private String[] createCombinedReportHeader(List<SingleReportEvaluationResult<?>> reportResults, ReportResultHeaderMapper singleResultHeaderMapper) {
        return reportResults.stream().map(singleResultHeaderMapper).reduce(ArrayUtils::addAll).map(result -> Arrays.copyOf(result, ((String[])result).length - 1)).orElseThrow(() -> new OptimizeRuntimeException("Was not able to create combined report header"));
    }

    static interface ReportResultHeaderMapper
    extends Function<ReportEvaluationResult, String[]> {
    }
}

