/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.dto.optimize.query.definition;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.SimpleDefinitionDto;
import io.camunda.optimize.service.util.TenantListHandlingUtil;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DefinitionWithTenantIdsDto
extends SimpleDefinitionDto {
    private List<String> tenantIds;

    public DefinitionWithTenantIdsDto(String key, String name, DefinitionType type, List<String> tenantIds, Set<String> engines) {
        super(key, name, type, engines);
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (tenantIds == null) {
            throw new IllegalArgumentException("TenantIds cannot be null");
        }
        if (engines == null) {
            throw new IllegalArgumentException("Engines cannot be null");
        }
        this.tenantIds = tenantIds;
    }

    public DefinitionWithTenantIdsDto(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    protected DefinitionWithTenantIdsDto() {
    }

    public List<String> getTenantIds() {
        return TenantListHandlingUtil.sortAndReturnTenantIdList(this.tenantIds);
    }

    public void setTenantIds(List<String> tenantIds) {
        if (tenantIds == null) {
            throw new IllegalArgumentException("TenantIds cannot be null");
        }
        this.tenantIds = tenantIds;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefinitionWithTenantIdsDto;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "DefinitionWithTenantIdsDto(tenantIds=" + String.valueOf(this.getTenantIds()) + ")";
    }
}

